/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameMomentumBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialForceBasics;
import us.ihmc.mecano.spatial.interfaces.MomentumBasics;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialForceBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class CentroidalMomentumRateCalculator
implements ReferenceFrameHolder {
    private final MultiBodySystemReadOnly input;
    private final ReferenceFrame matrixFrame;
    private final RecursionStep initialRecursionStep;
    private final RecursionStep[] recursionSteps;
    private final Map<RigidBodyReadOnly, RecursionStep> rigidBodyToRecursionStepMap;
    private final Twist jointUnitTwist;
    private final Twist intermediateTwist;
    private final Momentum unitMomentum;
    private final Momentum intermediateMomentum;
    private final DMatrixRMaj centroidalMomentumMatrix;
    private final SpatialForce biasSpatialForce;
    private final FixedFrameMomentumBasics momentum;
    private final FixedFrameSpatialForceBasics momentumRate;
    private final FixedFrameVector3DBasics centerOfMassVelocity;
    private final FixedFrameVector3DBasics centerOfMassAcceleration;
    private final DMatrixRMaj biasSpatialForceMatrix = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj jointVelocityMatrix;
    private final DMatrixRMaj jointAccelerationMatrix;
    private final DMatrixRMaj momentumMatrix = new DMatrixRMaj(6, 1);
    private double totalMass = 0.0;
    private boolean isCentroidalMomentumUpToDate = false;
    private boolean isJointVelocityMatrixUpToDate = false;
    private boolean isJointAccelerationMatrixUpToDate = false;
    private boolean isMomentumUpToDate = false;
    private boolean isMomentumRateUpToDate = false;
    private boolean isTotalMassUpToDate = false;
    private boolean isCenterOfMassVelocityUpToDate = false;
    private boolean isCenterOfMassAccelerationUpToDate = false;

    public CentroidalMomentumRateCalculator(RigidBodyReadOnly rootBody, ReferenceFrame matrixFrame) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody), matrixFrame);
    }

    public CentroidalMomentumRateCalculator(MultiBodySystemReadOnly input, ReferenceFrame matrixFrame) {
        this(input, matrixFrame, true);
    }

    public CentroidalMomentumRateCalculator(MultiBodySystemReadOnly input, ReferenceFrame matrixFrame, boolean considerIgnoredSubtreesInertia) {
        this.input = input;
        this.matrixFrame = matrixFrame;
        RigidBodyReadOnly rootBody = input.getRootBody();
        this.initialRecursionStep = new RecursionStep(rootBody, null, null);
        this.recursionSteps = this.buildMultiBodyTree(this.initialRecursionStep, input.getJointsToIgnore()).toArray(new RecursionStep[0]);
        this.rigidBodyToRecursionStepMap = Arrays.stream(this.recursionSteps).filter(s -> s.isRoot()).collect(Collectors.toMap(s -> s.rigidBody, Function.identity()));
        if (considerIgnoredSubtreesInertia) {
            this.initialRecursionStep.includeIgnoredSubtreeInertia();
        }
        this.biasSpatialForce = new SpatialForce(matrixFrame);
        this.jointUnitTwist = new Twist();
        this.intermediateTwist = new Twist();
        this.unitMomentum = new Momentum(matrixFrame);
        this.intermediateMomentum = new Momentum();
        int nDegreesOfFreedom = MultiBodySystemTools.computeDegreesOfFreedom(input.getJointsToConsider());
        this.centroidalMomentumMatrix = new DMatrixRMaj(6, nDegreesOfFreedom);
        this.jointVelocityMatrix = new DMatrixRMaj(nDegreesOfFreedom, 1);
        this.jointAccelerationMatrix = new DMatrixRMaj(nDegreesOfFreedom, 1);
        this.momentum = new Momentum(matrixFrame);
        this.momentumRate = new SpatialForce(matrixFrame);
        this.centerOfMassVelocity = new FrameVector3D(matrixFrame);
        this.centerOfMassAcceleration = new FrameVector3D(matrixFrame);
    }

    /*
     * WARNING - void declaration
     */
    private List<RecursionStep> buildMultiBodyTree(RecursionStep parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        ArrayList<RecursionStep> recursionSteps = new ArrayList<RecursionStep>();
        recursionSteps.add(parent);
        ArrayList<? extends JointReadOnly> childrenJoints = new ArrayList<JointReadOnly>(parent.rigidBody.getChildrenJoints());
        if (childrenJoints.size() > 1) {
            void var6_7;
            ArrayList<JointReadOnly> loopClosureAncestors = new ArrayList<JointReadOnly>();
            boolean bl = false;
            while (var6_7 < childrenJoints.size()) {
                if (MultiBodySystemTools.doesSubtreeContainLoopClosure(((JointReadOnly)childrenJoints.get((int)var6_7)).getSuccessor())) {
                    loopClosureAncestors.add((JointReadOnly)childrenJoints.remove((int)var6_7));
                    continue;
                }
                ++var6_7;
            }
            childrenJoints.addAll(loopClosureAncestors);
        }
        for (JointReadOnly jointReadOnly : childrenJoints) {
            RigidBodyReadOnly childBody;
            if (jointsToIgnore.contains(jointReadOnly) || jointReadOnly.isLoopClosure() || (childBody = jointReadOnly.getSuccessor()) == null) continue;
            int[] jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(jointReadOnly);
            RecursionStep child = new RecursionStep(childBody, parent, jointIndices);
            recursionSteps.addAll(this.buildMultiBodyTree(child, jointsToIgnore));
        }
        return recursionSteps;
    }

    public void reset() {
        this.isCentroidalMomentumUpToDate = false;
        this.isJointVelocityMatrixUpToDate = false;
        this.isJointAccelerationMatrixUpToDate = false;
        this.isMomentumUpToDate = false;
        this.isMomentumRateUpToDate = false;
        this.isTotalMassUpToDate = false;
        this.isCenterOfMassVelocityUpToDate = false;
        this.isCenterOfMassAccelerationUpToDate = false;
    }

    private void updateCentroidalMomentum() {
        if (this.isCentroidalMomentumUpToDate) {
            return;
        }
        this.biasSpatialForce.setToZero();
        this.passOne(this.initialRecursionStep);
        this.passTwo();
        this.biasSpatialForce.get((DMatrix)this.biasSpatialForceMatrix);
        this.isCentroidalMomentumUpToDate = true;
    }

    private void passOne(RecursionStep current) {
        current.passOne();
        for (int childIndex = 0; childIndex < current.children.size(); ++childIndex) {
            RecursionStep child = current.children.get(childIndex);
            this.passOne(child);
        }
    }

    private void passTwo() {
        for (RecursionStep recursionStep : this.recursionSteps) {
            recursionStep.passTwo();
        }
    }

    private DMatrixRMaj getJointVelocityMatrix() {
        if (!this.isJointVelocityMatrixUpToDate) {
            List<? extends JointReadOnly> joints = this.input.getJointMatrixIndexProvider().getIndexedJointsInOrder();
            MultiBodySystemTools.extractJointsState(joints, JointStateType.VELOCITY, (DMatrix)this.jointVelocityMatrix);
            this.isJointVelocityMatrixUpToDate = true;
        }
        return this.jointVelocityMatrix;
    }

    private DMatrixRMaj getJointAccelerationMatrix() {
        if (!this.isJointAccelerationMatrixUpToDate) {
            List<? extends JointReadOnly> joints = this.input.getJointMatrixIndexProvider().getIndexedJointsInOrder();
            MultiBodySystemTools.extractJointsState(joints, JointStateType.ACCELERATION, (DMatrix)this.jointAccelerationMatrix);
            this.isJointAccelerationMatrixUpToDate = true;
        }
        return this.jointAccelerationMatrix;
    }

    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    public double getTotalMass() {
        if (!this.isTotalMassUpToDate) {
            this.totalMass = 0.0;
            List<? extends JointReadOnly> jointsToConsider = this.input.getJointsToConsider();
            for (int i = 0; i < jointsToConsider.size(); ++i) {
                this.totalMass += jointsToConsider.get(i).getSuccessor().getInertia().getMass();
            }
            this.isTotalMassUpToDate = true;
        }
        return this.totalMass;
    }

    public FrameVector3DReadOnly getCenterOfMassVelocity() {
        if (!this.isCenterOfMassVelocityUpToDate) {
            this.centerOfMassVelocity.setAndScale(1.0 / this.getTotalMass(), (FrameTuple3DReadOnly)this.getMomentum().getLinearPart());
            this.isCenterOfMassVelocityUpToDate = true;
        }
        return this.centerOfMassVelocity;
    }

    public void getCenterOfMassVelocity(DMatrix1Row jointVelocityMatrix, FrameVector3DBasics centerOfMassVelocityToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)this.getCentroidalMomentumMatrix(), (DMatrix1Row)jointVelocityMatrix, (DMatrix1Row)this.momentumMatrix);
        centerOfMassVelocityToPack.setIncludingFrame(this.matrixFrame, 3, (DMatrix)this.momentumMatrix);
        centerOfMassVelocityToPack.scale(1.0 / this.getTotalMass());
    }

    public FrameVector3DReadOnly getCenterOfMassAcceleration() {
        if (!this.isCenterOfMassAccelerationUpToDate) {
            this.centerOfMassAcceleration.setAndScale(1.0 / this.getTotalMass(), (FrameTuple3DReadOnly)this.getMomentumRate().getLinearPart());
            this.isCenterOfMassAccelerationUpToDate = true;
        }
        return this.centerOfMassAcceleration;
    }

    public void getCenterOfMassAcceleration(DMatrixRMaj jointAccelerationMatrix, FrameVector3DBasics centerOfMassAccelerationToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)this.getCentroidalMomentumMatrix(), (DMatrix1Row)jointAccelerationMatrix, (DMatrix1Row)this.momentumMatrix);
        CommonOps_DDRM.addEquals((DMatrixD1)this.momentumMatrix, (DMatrixD1)this.getBiasSpatialForceMatrix());
        centerOfMassAccelerationToPack.setIncludingFrame(this.matrixFrame, 3, (DMatrix)this.momentumMatrix);
        centerOfMassAccelerationToPack.scale(1.0 / this.getTotalMass());
    }

    public MomentumReadOnly getMomentum() {
        if (!this.isMomentumUpToDate) {
            CommonOps_DDRM.mult((DMatrix1Row)this.getCentroidalMomentumMatrix(), (DMatrix1Row)this.getJointVelocityMatrix(), (DMatrix1Row)this.momentumMatrix);
            this.momentum.set((DMatrix)this.momentumMatrix);
            this.isMomentumUpToDate = true;
        }
        return this.momentum;
    }

    public void getMomentum(DMatrix1Row jointVelocityMatrix, MomentumBasics momentumToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)this.getCentroidalMomentumMatrix(), (DMatrix1Row)jointVelocityMatrix, (DMatrix1Row)this.momentumMatrix);
        momentumToPack.setIncludingFrame(this.matrixFrame, (DMatrix)this.momentumMatrix);
    }

    public SpatialForceReadOnly getMomentumRate() {
        if (!this.isMomentumRateUpToDate) {
            CommonOps_DDRM.mult((DMatrix1Row)this.getCentroidalMomentumMatrix(), (DMatrix1Row)this.getJointAccelerationMatrix(), (DMatrix1Row)this.momentumMatrix);
            this.momentumRate.set((DMatrix)this.momentumMatrix);
            this.momentumRate.add(this.getBiasSpatialForce());
            this.isMomentumRateUpToDate = true;
        }
        return this.momentumRate;
    }

    public void getMomentumRate(DMatrix1Row jointAccelerationMatrix, SpatialForceBasics momentumRateToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)this.getCentroidalMomentumMatrix(), (DMatrix1Row)jointAccelerationMatrix, (DMatrix1Row)this.momentumMatrix);
        CommonOps_DDRM.addEquals((DMatrixD1)this.momentumMatrix, (DMatrixD1)this.getBiasSpatialForceMatrix());
        momentumRateToPack.setIncludingFrame(this.matrixFrame, (DMatrix)this.momentumMatrix);
    }

    public DMatrixRMaj getCentroidalMomentumMatrix() {
        this.updateCentroidalMomentum();
        return this.centroidalMomentumMatrix;
    }

    public SpatialForceReadOnly getBiasSpatialForce() {
        this.updateCentroidalMomentum();
        return this.biasSpatialForce;
    }

    public boolean getBiasSpatialForceMatrix(List<? extends JointReadOnly> jointSelection, SpatialForceBasics biasSpatialForceToPack) {
        this.updateCentroidalMomentum();
        biasSpatialForceToPack.setToZero(this.getReferenceFrame());
        boolean foundAllJoints = true;
        for (int i = 0; i < jointSelection.size(); ++i) {
            RigidBodyReadOnly rigidBody = jointSelection.get(i).getPredecessor();
            RecursionStep step = this.rigidBodyToRecursionStepMap.get(rigidBody);
            if (step == null) {
                foundAllJoints = false;
                continue;
            }
            biasSpatialForceToPack.add(step.netCoriolisBodyWrench);
        }
        return foundAllJoints;
    }

    public DMatrixRMaj getBiasSpatialForceMatrix() {
        this.updateCentroidalMomentum();
        return this.biasSpatialForceMatrix;
    }

    public boolean getBiasSpatialForceMatrix(List<? extends JointReadOnly> jointSelection, DMatrixRMaj biasSpatialForceMatrixToPack) {
        this.updateCentroidalMomentum();
        biasSpatialForceMatrixToPack.zero();
        boolean foundAllJoints = true;
        for (int i = 0; i < jointSelection.size(); ++i) {
            RigidBodyReadOnly rigidBody = jointSelection.get(i).getPredecessor();
            RecursionStep step = this.rigidBodyToRecursionStepMap.get(rigidBody);
            if (step == null) {
                foundAllJoints = false;
                continue;
            }
            MecanoTools.addEquals(0, 0, step.netCoriolisBodyWrench, biasSpatialForceMatrixToPack);
        }
        return foundAllJoints;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.matrixFrame;
    }

    private class RecursionStep {
        private final RigidBodyReadOnly rigidBody;
        private final SpatialInertia bodyInertia;
        private final Wrench netCoriolisBodyWrench;
        private final DMatrixRMaj centroidalMomentumMatrixBlock;
        private final SpatialAcceleration coriolisBodyAcceleration;
        private final RigidBodyTransform matrixFrameToBodyFixedFrameTransform;
        private final RecursionStep parent;
        private final List<RecursionStep> children = new ArrayList<RecursionStep>();
        private final int[] jointIndices;

        public RecursionStep(RigidBodyReadOnly rigidBody, RecursionStep parent, int[] jointIndices) {
            this.rigidBody = rigidBody;
            this.parent = parent;
            this.jointIndices = jointIndices;
            if (this.isRoot()) {
                this.bodyInertia = null;
                this.coriolisBodyAcceleration = new SpatialAcceleration((ReferenceFrame)this.getBodyFixedFrame(), CentroidalMomentumRateCalculator.this.input.getInertialFrame(), this.getBodyFixedFrame());
                this.netCoriolisBodyWrench = null;
                this.centroidalMomentumMatrixBlock = null;
                this.matrixFrameToBodyFixedFrameTransform = null;
            } else {
                parent.children.add(this);
                this.bodyInertia = new SpatialInertia(rigidBody.getInertia());
                this.coriolisBodyAcceleration = new SpatialAcceleration();
                this.netCoriolisBodyWrench = new Wrench();
                this.centroidalMomentumMatrixBlock = new DMatrixRMaj(6, this.getJoint().getDegreesOfFreedom());
                this.matrixFrameToBodyFixedFrameTransform = new RigidBodyTransform();
            }
        }

        public void includeIgnoredSubtreeInertia() {
            if (!this.isRoot() && this.children.size() != this.rigidBody.getChildrenJoints().size()) {
                for (JointReadOnly jointReadOnly : this.rigidBody.getChildrenJoints()) {
                    if (!CentroidalMomentumRateCalculator.this.input.getJointsToIgnore().contains(jointReadOnly)) continue;
                    SpatialInertia subtreeIneria = MultiBodySystemTools.computeSubtreeInertia(jointReadOnly);
                    subtreeIneria.changeFrame(this.getBodyFixedFrame());
                    this.bodyInertia.add(subtreeIneria);
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).includeIgnoredSubtreeInertia();
            }
        }

        public void passOne() {
            if (this.isRoot()) {
                return;
            }
            ReferenceFrame inertiaFrame = this.bodyInertia.getReferenceFrame();
            CentroidalMomentumRateCalculator.this.matrixFrame.getTransformToDesiredFrame(this.matrixFrameToBodyFixedFrameTransform, inertiaFrame);
            this.coriolisBodyAcceleration.setIncludingFrame(this.parent.coriolisBodyAcceleration);
            this.getJoint().getPredecessorTwist(CentroidalMomentumRateCalculator.this.intermediateTwist);
            this.coriolisBodyAcceleration.changeFrame(this.getBodyFixedFrame(), CentroidalMomentumRateCalculator.this.intermediateTwist, this.parent.getBodyFixedFrame().getTwistOfFrame());
            this.coriolisBodyAcceleration.setBodyFrame(this.getBodyFixedFrame());
            this.bodyInertia.computeDynamicWrench(this.coriolisBodyAcceleration, this.getBodyFixedFrame().getTwistOfFrame(), this.netCoriolisBodyWrench);
            this.netCoriolisBodyWrench.applyInverseTransform((RigidBodyTransformReadOnly)this.matrixFrameToBodyFixedFrameTransform);
            this.netCoriolisBodyWrench.setReferenceFrame(CentroidalMomentumRateCalculator.this.matrixFrame);
            CentroidalMomentumRateCalculator.this.biasSpatialForce.add(this.netCoriolisBodyWrench);
        }

        public void passTwo() {
            if (this.isRoot()) {
                return;
            }
            for (int dofIndex = 0; dofIndex < this.getJoint().getDegreesOfFreedom(); ++dofIndex) {
                CentroidalMomentumRateCalculator.this.unitMomentum.setToZero();
                CentroidalMomentumRateCalculator.this.jointUnitTwist.setIncludingFrame(this.getJoint().getUnitTwists().get(dofIndex));
                CentroidalMomentumRateCalculator.this.jointUnitTwist.changeFrame(CentroidalMomentumRateCalculator.this.matrixFrame);
                this.addToUnitMomentumRecursively(CentroidalMomentumRateCalculator.this.jointUnitTwist, CentroidalMomentumRateCalculator.this.unitMomentum);
                CentroidalMomentumRateCalculator.this.unitMomentum.get(0, dofIndex, (DMatrix)this.centroidalMomentumMatrixBlock);
                int column = this.jointIndices[dofIndex];
                CommonOps_DDRM.extract((DMatrix)this.centroidalMomentumMatrixBlock, (int)0, (int)6, (int)dofIndex, (int)(dofIndex + 1), (DMatrix)CentroidalMomentumRateCalculator.this.centroidalMomentumMatrix, (int)0, (int)column);
            }
        }

        private void addToUnitMomentumRecursively(TwistReadOnly ancestorUnitTwist, FixedFrameMomentumBasics unitMomentumToAddTo) {
            SpatialInertiaReadOnly inertia = this.rigidBody.getInertia();
            ReferenceFrame inertiaFrame = inertia.getReferenceFrame();
            CentroidalMomentumRateCalculator.this.intermediateTwist.setIncludingFrame(ancestorUnitTwist);
            CentroidalMomentumRateCalculator.this.intermediateTwist.applyTransform((RigidBodyTransformReadOnly)this.matrixFrameToBodyFixedFrameTransform);
            CentroidalMomentumRateCalculator.this.intermediateTwist.setReferenceFrame(inertiaFrame);
            CentroidalMomentumRateCalculator.this.intermediateMomentum.setReferenceFrame(inertiaFrame);
            CentroidalMomentumRateCalculator.this.intermediateMomentum.compute(inertia, CentroidalMomentumRateCalculator.this.intermediateTwist);
            CentroidalMomentumRateCalculator.this.intermediateMomentum.applyInverseTransform((RigidBodyTransformReadOnly)this.matrixFrameToBodyFixedFrameTransform);
            CentroidalMomentumRateCalculator.this.intermediateMomentum.setReferenceFrame(CentroidalMomentumRateCalculator.this.matrixFrame);
            unitMomentumToAddTo.add(CentroidalMomentumRateCalculator.this.intermediateMomentum);
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).addToUnitMomentumRecursively(ancestorUnitTwist, unitMomentumToAddTo);
            }
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public JointReadOnly getJoint() {
            return this.rigidBody.getParentJoint();
        }

        public MovingReferenceFrame getBodyFixedFrame() {
            return this.rigidBody.getBodyFixedFrame();
        }
    }
}

