/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.iterators;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.IteratorSearchMode;
import us.ihmc.mecano.multiBodySystem.iterators.RigidBodyIterator;

public class RigidBodyIterable<B extends RigidBodyReadOnly>
implements Iterable<B> {
    private final Collection<? extends RigidBodyReadOnly> roots;
    private final Predicate<B> selectionRule;
    private final Class<B> filteringClass;
    private final IteratorSearchMode mode;

    public RigidBodyIterable(Class<B> filteringClass, Predicate<B> selectionRule, IteratorSearchMode mode, RigidBodyReadOnly root) {
        this(filteringClass, selectionRule, mode, Collections.singletonList(root));
    }

    public RigidBodyIterable(Class<B> filteringClass, Predicate<B> selectionRule, IteratorSearchMode mode, Collection<? extends RigidBodyReadOnly> roots) {
        this.filteringClass = filteringClass;
        this.selectionRule = selectionRule;
        this.roots = roots;
        this.mode = mode;
    }

    @Override
    public Iterator<B> iterator() {
        return new RigidBodyIterator<B>(this.filteringClass, this.selectionRule, this.mode, this.roots);
    }

    public Stream<B> toStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

