/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public interface OneDoFJointReadOnly
extends JointReadOnly {
    public static final int NUMBER_OF_DOFS = 1;

    public FrameVector3DReadOnly getJointAxis();

    public double getQ();

    public double getQd();

    public double getQdd();

    public double getTau();

    public double getJointLimitLower();

    public double getJointLimitUpper();

    public double getVelocityLimitLower();

    public double getVelocityLimitUpper();

    public double getEffortLimitLower();

    public double getEffortLimitUpper();

    @Override
    default public boolean getMotionSubspaceDot(DMatrix1Row matrixToPack) {
        if (!this.isMotionSubspaceVariable()) {
            return false;
        }
        double qd = this.getQd();
        if (EuclidCoreTools.isZero((double)qd, (double)1.0E-12)) {
            matrixToPack.zero();
        } else {
            this.getJointBiasAcceleration().get((DMatrix)matrixToPack);
            CommonOps_DDRM.scale((double)(1.0 / qd), (DMatrixD1)matrixToPack);
        }
        return true;
    }

    public TwistReadOnly getUnitJointTwist();

    public TwistReadOnly getUnitSuccessorTwist();

    public TwistReadOnly getUnitPredecessorTwist();

    public SpatialAccelerationReadOnly getUnitJointAcceleration();

    public SpatialAccelerationReadOnly getUnitSuccessorAcceleration();

    public SpatialAccelerationReadOnly getUnitPredecessorAcceleration();

    @Override
    default public void getSuccessorTwist(TwistBasics twistToPack) {
        twistToPack.setIncludingFrame(this.getUnitSuccessorTwist());
        twistToPack.scale(this.getQd());
    }

    @Override
    default public void getPredecessorTwist(TwistBasics twistToPack) {
        twistToPack.setIncludingFrame(this.getUnitPredecessorTwist());
        twistToPack.scale(this.getQd());
    }

    @Override
    default public void getSuccessorAcceleration(SpatialAccelerationBasics accelerationToPack) {
        accelerationToPack.setIncludingFrame(this.getUnitSuccessorAcceleration());
        accelerationToPack.scale(this.getQdd());
        if (this.isMotionSubspaceVariable()) {
            SpatialAccelerationReadOnly successorBiasAcceleration = this.getSuccessorBiasAcceleration();
            accelerationToPack.checkReferenceFrameMatch(successorBiasAcceleration);
            accelerationToPack.add(successorBiasAcceleration);
        }
    }

    @Override
    default public void getPredecessorAcceleration(SpatialAccelerationBasics accelerationToPack) {
        accelerationToPack.setIncludingFrame(this.getUnitPredecessorAcceleration());
        accelerationToPack.scale(this.getQdd());
        if (this.isMotionSubspaceVariable()) {
            SpatialAccelerationReadOnly predecessorBiasAcceleration = this.getPredecessorBiasAcceleration();
            accelerationToPack.checkReferenceFrameMatch(predecessorBiasAcceleration);
            accelerationToPack.add(predecessorBiasAcceleration);
        }
    }

    @Override
    default public int getJointConfiguration(int rowStart, DMatrix matrixToPack) {
        matrixToPack.set(rowStart, 0, this.getQ());
        return rowStart + this.getConfigurationMatrixSize();
    }

    @Override
    default public int getJointVelocity(int rowStart, DMatrix matrixToPack) {
        matrixToPack.set(rowStart, 0, this.getQd());
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getJointAcceleration(int rowStart, DMatrix matrixToPack) {
        matrixToPack.set(rowStart, 0, this.getQdd());
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getJointTau(int rowStart, DMatrix matrixToPack) {
        matrixToPack.set(rowStart, 0, this.getTau());
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getDegreesOfFreedom() {
        return 1;
    }

    @Override
    default public int getConfigurationMatrixSize() {
        return this.getDegreesOfFreedom();
    }
}

