/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class GeometricJacobianCalculator {
    private RigidBodyReadOnly base;
    private RigidBodyReadOnly endEffector;
    private RigidBodyReadOnly commonAncestor;
    private final List<JointReadOnly> jointsFromBaseToEndEffector = new ArrayList<JointReadOnly>(12);
    private final List<RigidBodyReadOnly> bodyPathFromBaseToEndEffector = new ArrayList<RigidBodyReadOnly>(12);
    private ReferenceFrame jacobianFrame;
    private int numberOfDegreesOfFreedom;
    private final DMatrixRMaj jacobianMatrix = new DMatrixRMaj(6, 12);
    private final DMatrixRMaj jacobianRateMatrix = new DMatrixRMaj(6, 12);
    private final DMatrixRMaj convectiveTerm = new DMatrixRMaj(6, 1);
    private final Twist jointUnitTwist = new Twist();
    private final DMatrixRMaj spatialVector = new DMatrixRMaj(6, 1);
    private final SpatialAcceleration endEffectorCoriolisAcceleration = new SpatialAcceleration();
    private final SpatialVector twistToEndEffector = new SpatialVector();
    private final SpatialVector jacobianRateColumn = new SpatialVector();
    private boolean isJacobianUpToDate = false;
    private boolean isJacobianRateUpToDate = false;
    private final DMatrixRMaj jointVelocities = new DMatrixRMaj(12, 1);

    public GeometricJacobianCalculator() {
        this.clear();
    }

    public void clear() {
        this.base = null;
        this.endEffector = null;
        this.commonAncestor = null;
        this.numberOfDegreesOfFreedom = -1;
        this.jacobianFrame = null;
        this.jointsFromBaseToEndEffector.clear();
        this.reset();
    }

    public void reset() {
        this.isJacobianUpToDate = false;
        this.isJacobianRateUpToDate = false;
    }

    public void setKinematicChain(RigidBodyReadOnly base, RigidBodyReadOnly endEffector) {
        this.base = base;
        this.endEffector = endEffector;
        this.jacobianFrame = endEffector.getBodyFixedFrame();
        this.reset();
        this.numberOfDegreesOfFreedom = MultiBodySystemTools.computeDegreesOfFreedom(base, endEffector);
        this.commonAncestor = MultiBodySystemTools.collectJointPath(base, endEffector, this.jointsFromBaseToEndEffector);
        MultiBodySystemTools.collectRigidBodyPath(base, endEffector, this.bodyPathFromBaseToEndEffector);
    }

    public void setKinematicChain(JointReadOnly[] joints) {
        Objects.requireNonNull(joints);
        if (joints.length == 0) {
            throw new IllegalArgumentException("Cannot create a geometric jacobian for an empty kinematic chain.");
        }
        if (joints.length == 1) {
            JointReadOnly joint = joints[0];
            this.base = joint.getPredecessor();
            this.endEffector = joint.getSuccessor();
            this.commonAncestor = this.base;
            this.bodyPathFromBaseToEndEffector.clear();
            this.bodyPathFromBaseToEndEffector.add(this.base);
            this.bodyPathFromBaseToEndEffector.add(this.endEffector);
            this.numberOfDegreesOfFreedom = joint.getDegreesOfFreedom();
        } else {
            JointReadOnly firstJoint = joints[0];
            JointReadOnly secondJoint = joints[1];
            JointReadOnly lastJoint = joints[joints.length - 1];
            JointReadOnly secondToLastJoint = joints[joints.length - 2];
            this.base = firstJoint == secondJoint.getPredecessor().getParentJoint() ? firstJoint.getPredecessor() : firstJoint.getSuccessor();
            this.endEffector = lastJoint == secondToLastJoint.getPredecessor().getParentJoint() ? lastJoint.getPredecessor() : lastJoint.getSuccessor();
            this.commonAncestor = MultiBodySystemTools.collectRigidBodyPath(this.base, this.endEffector, this.bodyPathFromBaseToEndEffector);
            this.numberOfDegreesOfFreedom = MultiBodySystemTools.computeDegreesOfFreedom(joints);
        }
        this.jacobianFrame = this.endEffector.getBodyFixedFrame();
        this.reset();
        this.jointsFromBaseToEndEffector.clear();
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            this.jointsFromBaseToEndEffector.add(joints[jointIndex]);
        }
    }

    public void setJacobianFrame(ReferenceFrame jacobianFrame) {
        if (jacobianFrame == this.jacobianFrame) {
            return;
        }
        this.jacobianFrame = jacobianFrame;
        this.reset();
    }

    private void updateJacobianMatrix() {
        if (this.isJacobianUpToDate) {
            return;
        }
        if (this.base == null || this.endEffector == null) {
            throw new RuntimeException("The base and end-effector have to be set first.");
        }
        this.jacobianMatrix.reshape(6, this.numberOfDegreesOfFreedom);
        boolean isGoingUpstream = this.commonAncestor != this.base;
        int column = 0;
        for (int jointIndex = 0; jointIndex < this.jointsFromBaseToEndEffector.size(); ++jointIndex) {
            JointReadOnly joint = this.jointsFromBaseToEndEffector.get(jointIndex);
            for (int dofIndex = 0; dofIndex < joint.getDegreesOfFreedom(); ++dofIndex) {
                this.jointUnitTwist.setIncludingFrame(joint.getUnitTwists().get(dofIndex));
                if (isGoingUpstream) {
                    this.jointUnitTwist.invert();
                }
                this.jointUnitTwist.changeFrame(this.jacobianFrame);
                this.jointUnitTwist.get(0, column++, (DMatrix)this.jacobianMatrix);
            }
            if (!isGoingUpstream) continue;
            isGoingUpstream = joint.getPredecessor() != this.commonAncestor;
        }
        this.isJacobianUpToDate = true;
    }

    private void updateJacobianRateMatrix() {
        if (this.isJacobianRateUpToDate) {
            return;
        }
        this.updateJacobianMatrix();
        this.jointVelocities.reshape(this.numberOfDegreesOfFreedom, 1);
        MultiBodySystemTools.extractJointsState(this.jointsFromBaseToEndEffector, JointStateType.VELOCITY, (DMatrix)this.jointVelocities);
        this.jacobianRateMatrix.reshape(6, this.numberOfDegreesOfFreedom);
        JointReadOnly joint = this.jointsFromBaseToEndEffector.get(this.jointsFromBaseToEndEffector.size() - 1);
        int startCol = this.numberOfDegreesOfFreedom - joint.getDegreesOfFreedom();
        int endCol = this.numberOfDegreesOfFreedom;
        GeometricJacobianCalculator.fillColumns(startCol, endCol, 0.0, (DMatrix)this.jacobianRateMatrix);
        this.twistToEndEffector.setToZero();
        for (int jointIdx = this.jointsFromBaseToEndEffector.size() - 2; jointIdx >= 0; --jointIdx) {
            GeometricJacobianCalculator.addJointTwist(startCol, endCol, this.jointVelocities, this.jacobianMatrix, this.twistToEndEffector);
            joint = this.jointsFromBaseToEndEffector.get(jointIdx);
            endCol = startCol;
            this.computeJacobianRateMatrixBlock(startCol -= joint.getDegreesOfFreedom(), endCol, this.twistToEndEffector);
        }
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobianRateMatrix, (DMatrix1Row)this.jointVelocities, (DMatrix1Row)this.convectiveTerm);
        this.endEffectorCoriolisAcceleration.setIncludingFrame(this.getEndEffectorFrame(), this.getBaseFrame(), this.getJacobianFrame(), (DMatrix)this.convectiveTerm);
        this.isJacobianRateUpToDate = true;
    }

    private void computeJacobianRateMatrixBlock(int startIndex, int endIndex, SpatialVectorReadOnly twistToEndEffector) {
        for (int i = startIndex; i < endIndex; ++i) {
            this.jacobianRateColumn.set(0, i, (DMatrix)this.jacobianMatrix);
            this.jacobianRateColumn.getLinearPart().cross((FrameVector3DReadOnly)this.jacobianRateColumn.getLinearPart(), twistToEndEffector.getAngularPart());
            this.jacobianRateColumn.addCrossToLinearPart((Tuple3DReadOnly)this.jacobianRateColumn.getAngularPart(), (Tuple3DReadOnly)twistToEndEffector.getLinearPart());
            this.jacobianRateColumn.getAngularPart().cross((FrameVector3DReadOnly)this.jacobianRateColumn.getAngularPart(), twistToEndEffector.getAngularPart());
            this.jacobianRateColumn.get(0, i, (DMatrix)this.jacobianRateMatrix);
        }
    }

    private static void fillColumns(int startColumn, int endColumn, double value, DMatrix matrix) {
        if (startColumn == endColumn) {
            return;
        }
        if (startColumn < 0 || startColumn >= matrix.getNumCols() || endColumn < 0 || endColumn > matrix.getNumCols() || endColumn < startColumn) {
            throw new IllegalArgumentException("Illegal arguments: startColumn = " + startColumn + " , endColumn = " + endColumn + ".");
        }
        for (int col = startColumn; col < endColumn; ++col) {
            for (int row = 0; row < matrix.getNumRows(); ++row) {
                matrix.unsafe_set(row, col, value);
            }
        }
    }

    private static void addJointTwist(int startIndex, int endIndex, DMatrixRMaj jointVelocities, DMatrixRMaj jacobianMatrix, SpatialVectorBasics vectorToModify) {
        for (int col = startIndex; col < endIndex; ++col) {
            double qDot = jointVelocities.get(col);
            double wx = qDot * jacobianMatrix.get(0, col);
            double wy = qDot * jacobianMatrix.get(1, col);
            double wz = qDot * jacobianMatrix.get(2, col);
            double vx = qDot * jacobianMatrix.get(3, col);
            double vy = qDot * jacobianMatrix.get(4, col);
            double vz = qDot * jacobianMatrix.get(5, col);
            vectorToModify.getAngularPart().add(wx, wy, wz);
            vectorToModify.getLinearPart().add(vx, vy, vz);
        }
    }

    public void getEndEffectorTwist(DMatrix1Row jointVelocities, TwistBasics endEffectorTwistToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)this.getJacobianMatrix(), (DMatrix1Row)jointVelocities, (DMatrix1Row)this.spatialVector);
        endEffectorTwistToPack.setIncludingFrame(this.getEndEffectorFrame(), this.getBaseFrame(), this.jacobianFrame, (DMatrix)this.spatialVector);
    }

    public void getEndEffectorAcceleration(DMatrix1Row jointAccelerations, SpatialAccelerationBasics spatialAccelerationToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)this.getJacobianMatrix(), (DMatrix1Row)jointAccelerations, (DMatrix1Row)this.spatialVector);
        CommonOps_DDRM.addEquals((DMatrixD1)this.spatialVector, (DMatrixD1)this.getConvectiveTermMatrix());
        spatialAccelerationToPack.setIncludingFrame(this.getEndEffectorFrame(), this.getBaseFrame(), this.jacobianFrame, (DMatrix)this.spatialVector);
    }

    public void getJointTorques(WrenchReadOnly endEffectorWrench, DMatrix1Row jointTorquesToPack) {
        endEffectorWrench.checkReferenceFrameMatch(this.getEndEffectorFrame(), this.jacobianFrame);
        endEffectorWrench.get((DMatrix)this.spatialVector);
        jointTorquesToPack.reshape(1, this.numberOfDegreesOfFreedom);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.spatialVector, (DMatrix1Row)this.getJacobianMatrix(), (DMatrix1Row)jointTorquesToPack);
        jointTorquesToPack.reshape(this.numberOfDegreesOfFreedom, 1, true);
    }

    public RigidBodyReadOnly getBase() {
        return this.base;
    }

    public ReferenceFrame getBaseFrame() {
        return this.base.getBodyFixedFrame();
    }

    public RigidBodyReadOnly getEndEffector() {
        return this.endEffector;
    }

    public RigidBodyReadOnly getCommonAncestor() {
        return this.commonAncestor;
    }

    public ReferenceFrame getEndEffectorFrame() {
        return this.endEffector.getBodyFixedFrame();
    }

    public ReferenceFrame getJacobianFrame() {
        return this.jacobianFrame;
    }

    public int getNumberOfDegreesOfFreedom() {
        return this.numberOfDegreesOfFreedom;
    }

    public List<JointReadOnly> getJointsFromBaseToEndEffector() {
        return this.jointsFromBaseToEndEffector;
    }

    public DMatrixRMaj getJacobianMatrix() {
        this.updateJacobianMatrix();
        return this.jacobianMatrix;
    }

    public DMatrixRMaj getJacobianRateMatrix() {
        this.updateJacobianRateMatrix();
        return this.jacobianRateMatrix;
    }

    public DMatrixRMaj getConvectiveTermMatrix() {
        this.updateJacobianRateMatrix();
        return this.convectiveTerm;
    }

    public SpatialAccelerationReadOnly getConvectiveTerm() {
        this.updateJacobianRateMatrix();
        return this.endEffectorCoriolisAcceleration;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Jacobian. jacobianFrame = " + this.jacobianFrame + ". Joints:\n");
        RigidBodyReadOnly currentBody = this.endEffector;
        while (currentBody != this.base) {
            JointReadOnly joint = currentBody.getParentJoint();
            builder.append(joint.getClass().getSimpleName() + " " + joint.getName() + "\n");
            currentBody = joint.getPredecessor();
        }
        builder.append("\n");
        builder.append(this.jacobianMatrix.toString());
        return builder.toString();
    }

    public String getShortInfo() {
        return "Jacobian, end effector = " + this.getEndEffector() + ", base = " + this.getBase() + ", expressed in " + this.getJacobianFrame();
    }
}

