/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public interface MultiBodySystemReadOnly {
    default public ReferenceFrame getInertialFrame() {
        return this.getRootBody().getBodyFixedFrame().getRootFrame();
    }

    public RigidBodyReadOnly getRootBody();

    default public List<? extends JointReadOnly> getAllJoints() {
        return SubtreeStreams.fromChildren(this.getRootBody()).collect(Collectors.toList());
    }

    default public List<? extends JointReadOnly> getJointsToConsider() {
        return this.getAllJoints();
    }

    default public int getNumberOfDoFs() {
        return MultiBodySystemTools.computeDegreesOfFreedom(this.getJointsToConsider());
    }

    default public List<? extends JointReadOnly> getJointsToIgnore() {
        return this.getAllJoints().stream().filter(joint -> !this.getJointsToConsider().contains(joint)).collect(Collectors.toList());
    }

    default public JointMatrixIndexProvider getJointMatrixIndexProvider() {
        return JointMatrixIndexProvider.toIndexProvider(this.getJointsToConsider());
    }

    default public JointReadOnly findJoint(String jointName) {
        return MultiBodySystemTools.findJoint(this.getRootBody(), jointName);
    }

    default public RigidBodyReadOnly findRigidBody(String rigidBodyName) {
        return MultiBodySystemTools.findRigidBody(this.getRootBody(), rigidBodyName);
    }

    public static MultiBodySystemReadOnly toMultiBodySystemInput(RigidBodyReadOnly rootBody) {
        return MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody, Collections.emptyList());
    }

    public static MultiBodySystemReadOnly toMultiBodySystemInput(RigidBodyReadOnly rootBody, JointReadOnly[] jointsToIgnore) {
        return MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody, Arrays.asList(jointsToIgnore));
    }

    public static MultiBodySystemReadOnly toMultiBodySystemInput(final RigidBodyReadOnly rootBody, final List<? extends JointReadOnly> jointsToIgnore) {
        final List allJoints = SubtreeStreams.fromChildren(rootBody).collect(Collectors.toList());
        final List<? extends JointReadOnly> jointsToConsider = MultiBodySystemReadOnly.extractJointsToConsider(rootBody, jointsToIgnore);
        final JointMatrixIndexProvider jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(jointsToConsider);
        return new MultiBodySystemReadOnly(){

            @Override
            public RigidBodyReadOnly getRootBody() {
                return rootBody;
            }

            @Override
            public List<? extends JointReadOnly> getAllJoints() {
                return allJoints;
            }

            @Override
            public List<? extends JointReadOnly> getJointsToConsider() {
                return jointsToConsider;
            }

            @Override
            public List<? extends JointReadOnly> getJointsToIgnore() {
                return jointsToIgnore;
            }

            @Override
            public JointMatrixIndexProvider getJointMatrixIndexProvider() {
                return jointMatrixIndexProvider;
            }
        };
    }

    public static MultiBodySystemReadOnly toMultiBodySystemInput(JointReadOnly[] jointsToConsider) {
        return MultiBodySystemReadOnly.toMultiBodySystemInput(Arrays.asList(jointsToConsider));
    }

    public static MultiBodySystemReadOnly toMultiBodySystemInput(final List<? extends JointReadOnly> jointsToConsider) {
        final RigidBodyReadOnly rootBody = MultiBodySystemReadOnly.getClosestJointToRoot(jointsToConsider).getPredecessor();
        final List allJoints = SubtreeStreams.fromChildren(rootBody).collect(Collectors.toList());
        final List jointsToIgnore = SubtreeStreams.fromChildren(rootBody).filter(joint -> !jointsToConsider.contains(joint)).collect(Collectors.toList());
        final JointMatrixIndexProvider jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(jointsToConsider);
        return new MultiBodySystemReadOnly(){

            @Override
            public RigidBodyReadOnly getRootBody() {
                return rootBody;
            }

            @Override
            public List<? extends JointReadOnly> getAllJoints() {
                return allJoints;
            }

            @Override
            public List<? extends JointReadOnly> getJointsToConsider() {
                return jointsToConsider;
            }

            @Override
            public List<? extends JointReadOnly> getJointsToIgnore() {
                return jointsToIgnore;
            }

            @Override
            public JointMatrixIndexProvider getJointMatrixIndexProvider() {
                return jointMatrixIndexProvider;
            }
        };
    }

    public static List<? extends JointReadOnly> extractJointsToConsider(RigidBodyReadOnly rootBody, List<? extends JointReadOnly> jointsToIgnore) {
        return SubtreeStreams.fromChildren(rootBody).filter(candidate -> !MultiBodySystemReadOnly.isJointToBeIgnored(candidate, jointsToIgnore)).collect(Collectors.toList());
    }

    public static boolean isJointToBeIgnored(JointReadOnly query, List<? extends JointReadOnly> jointsToIgnore) {
        for (int i = 0; i < jointsToIgnore.size(); ++i) {
            JointReadOnly jointToIgnore = jointsToIgnore.get(i);
            if (!MultiBodySystemTools.isAncestor(query.getSuccessor(), jointToIgnore.getSuccessor())) continue;
            return true;
        }
        return false;
    }

    public static JointReadOnly getClosestJointToRoot(List<? extends JointReadOnly> joints) {
        JointReadOnly closest = joints.get(0);
        RigidBodyReadOnly rootBody = MultiBodySystemTools.getRootBody(closest.getPredecessor());
        int distanceToRoot = MultiBodySystemTools.computeDistanceToAncestor(closest.getPredecessor(), rootBody);
        for (int i = 1; i < joints.size(); ++i) {
            JointReadOnly candidate = joints.get(i);
            int candidateDistanceToRoot = MultiBodySystemTools.computeDistanceToAncestor(candidate.getPredecessor(), rootBody);
            if (candidateDistanceToRoot >= distanceToRoot) continue;
            distanceToRoot = candidateDistanceToRoot;
            closest = candidate;
        }
        return closest;
    }
}

