/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class SpatialAccelerationCalculator
implements RigidBodyAccelerationProvider {
    private final RigidBodyReadOnly rootBody;
    private final boolean doVelocityTerms;
    private final boolean doAccelerationTerms;
    private final Map<RigidBodyReadOnly, AccelerationIndex> rigidBodyToAssignedAccelerationIndex = new HashMap<RigidBodyReadOnly, AccelerationIndex>();
    private final List<RigidBodyReadOnly> rigidBodiesWithAssignedAcceleration;
    private final List<SpatialAcceleration> assignedAccelerations;
    private final List<SpatialAcceleration> unnassignedAccelerations = new ArrayList<SpatialAcceleration>();
    private final ReferenceFrame inertialFrame;
    private final RigidBodyAccelerationProvider accelerationProvider;
    private final Twist twistForComputeOrGetTwistOfBody1 = new Twist();
    private final Twist twistForComputeOrGetTwistOfBody2 = new Twist();
    private final SpatialAcceleration accelerationForComputeOrGetAccelerationOfBody = new SpatialAcceleration();

    public SpatialAccelerationCalculator(RigidBodyReadOnly body, ReferenceFrame inertialFrame) {
        this(body, inertialFrame, true);
    }

    public SpatialAccelerationCalculator(RigidBodyReadOnly body, ReferenceFrame inertialFrame, boolean doVelocityTerms) {
        this(body, inertialFrame, doVelocityTerms, true);
    }

    public SpatialAccelerationCalculator(RigidBodyReadOnly body, ReferenceFrame inertialFrame, boolean doVelocityTerms, boolean doAccelerationTerms) {
        this.inertialFrame = inertialFrame;
        this.rootBody = MultiBodySystemTools.getRootBody(body);
        this.doVelocityTerms = doVelocityTerms;
        this.doAccelerationTerms = doAccelerationTerms;
        int numberOfRigidBodies = (int)this.rootBody.subtreeStream().count();
        while (this.unnassignedAccelerations.size() < numberOfRigidBodies) {
            this.unnassignedAccelerations.add(new SpatialAcceleration());
        }
        this.rigidBodiesWithAssignedAcceleration = new ArrayList<RigidBodyReadOnly>(numberOfRigidBodies);
        this.assignedAccelerations = new ArrayList<SpatialAcceleration>(numberOfRigidBodies);
        this.assignedAccelerations.add(new SpatialAcceleration((ReferenceFrame)this.rootBody.getBodyFixedFrame(), inertialFrame, this.rootBody.getBodyFixedFrame()));
        this.rigidBodiesWithAssignedAcceleration.add(this.rootBody);
        this.rigidBodyToAssignedAccelerationIndex.put(this.rootBody, new AccelerationIndex(0));
        this.accelerationProvider = RigidBodyAccelerationProvider.toRigidBodyAccelerationProvider(this::getAccelerationOfBody, inertialFrame, doVelocityTerms, doAccelerationTerms);
    }

    public void setGravitionalAcceleration(FrameTuple3DReadOnly gravity) {
        gravity.checkReferenceFrameMatch(this.inertialFrame);
        this.setGravitionalAcceleration((Tuple3DReadOnly)gravity);
    }

    public void setGravitionalAcceleration(Tuple3DReadOnly gravity) {
        SpatialAcceleration rootAcceleration = this.assignedAccelerations.get(0);
        rootAcceleration.setToZero();
        rootAcceleration.getLinearPart().setAndNegate(gravity);
    }

    public void setGravitionalAcceleration(double gravity) {
        this.setGravitionalAcceleration(0.0, 0.0, gravity);
    }

    public void setGravitionalAcceleration(double gravityX, double gravityY, double gravityZ) {
        SpatialAcceleration rootAcceleration = this.assignedAccelerations.get(0);
        rootAcceleration.setToZero();
        rootAcceleration.getLinearPart().set(gravityX, gravityY, gravityZ);
        rootAcceleration.negate();
    }

    public void setRootAcceleration(SpatialAccelerationReadOnly newRootAcceleration) {
        this.assignedAccelerations.get(0).set(newRootAcceleration);
    }

    public void reset() {
        while (this.rigidBodiesWithAssignedAcceleration.size() > 1) {
            this.rigidBodyToAssignedAccelerationIndex.get(this.rigidBodiesWithAssignedAcceleration.remove(this.rigidBodiesWithAssignedAcceleration.size() - 1)).setIndex(-1);
        }
        while (this.assignedAccelerations.size() > 1) {
            this.unnassignedAccelerations.add(this.assignedAccelerations.remove(this.assignedAccelerations.size() - 1));
        }
        this.rigidBodyToAssignedAccelerationIndex.get(this.rootBody).setIndex(0);
    }

    @Override
    public SpatialAccelerationReadOnly getAccelerationOfBody(RigidBodyReadOnly body) {
        return this.computeOrGetAccelerationOfBody(body);
    }

    @Override
    public SpatialAccelerationReadOnly getRelativeAcceleration(RigidBodyReadOnly base, RigidBodyReadOnly body) {
        return this.accelerationProvider.getRelativeAcceleration(base, body);
    }

    @Override
    public FrameVector3DReadOnly getLinearAccelerationOfBodyFixedPoint(RigidBodyReadOnly base, RigidBodyReadOnly body, FramePoint3DReadOnly bodyFixedPoint) {
        return this.accelerationProvider.getLinearAccelerationOfBodyFixedPoint(base, body, bodyFixedPoint);
    }

    public RigidBodyReadOnly getRootBody() {
        return this.rootBody;
    }

    @Override
    public boolean areVelocitiesConsidered() {
        return this.doVelocityTerms;
    }

    @Override
    public boolean areAccelerationsConsidered() {
        return this.doAccelerationTerms;
    }

    @Override
    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }

    private SpatialAccelerationReadOnly computeOrGetAccelerationOfBody(RigidBodyReadOnly body) {
        SpatialAcceleration acceleration = this.retrieveAssignedAcceleration(body);
        if (acceleration == null) {
            MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
            JointReadOnly parentJoint = body.getParentJoint();
            RigidBodyReadOnly predecessor = parentJoint.getPredecessor();
            acceleration = this.assignAndGetEmptyAcceleration(body);
            Twist localJointTwist = this.twistForComputeOrGetTwistOfBody1;
            Twist localPredecessorTwist = this.twistForComputeOrGetTwistOfBody2;
            SpatialAcceleration localJointAcceleration = this.accelerationForComputeOrGetAccelerationOfBody;
            MovingReferenceFrame predecessorFrame = predecessor.getBodyFixedFrame();
            acceleration.setIncludingFrame(this.computeOrGetAccelerationOfBody(predecessor));
            if (this.doVelocityTerms) {
                parentJoint.getPredecessorTwist(localJointTwist);
                predecessorFrame.getTwistOfFrame(localPredecessorTwist);
                acceleration.changeFrame(bodyFrame, localJointTwist, localPredecessorTwist);
            } else {
                acceleration.changeFrame(bodyFrame);
            }
            if (this.doAccelerationTerms) {
                parentJoint.getSuccessorAcceleration(localJointAcceleration);
                acceleration.add(localJointAcceleration);
            } else {
                acceleration.setBodyFrame(bodyFrame);
            }
        }
        return acceleration;
    }

    private SpatialAcceleration retrieveAssignedAcceleration(RigidBodyReadOnly body) {
        int assignedAccelerationIndex;
        AccelerationIndex index = this.rigidBodyToAssignedAccelerationIndex.get(body);
        if (index == null) {
            index = new AccelerationIndex(-1);
            this.rigidBodyToAssignedAccelerationIndex.put(body, index);
        }
        if ((assignedAccelerationIndex = index.getIndex()) == -1) {
            return null;
        }
        return this.assignedAccelerations.get(assignedAccelerationIndex);
    }

    private SpatialAcceleration assignAndGetEmptyAcceleration(RigidBodyReadOnly body) {
        SpatialAcceleration newAssignedAcceleration = this.unnassignedAccelerations.isEmpty() ? new SpatialAcceleration() : this.unnassignedAccelerations.remove(this.unnassignedAccelerations.size() - 1);
        AccelerationIndex index = this.rigidBodyToAssignedAccelerationIndex.get(body);
        if (index == null) {
            index = new AccelerationIndex(0);
            this.rigidBodyToAssignedAccelerationIndex.put(body, index);
        }
        index.setIndex(this.assignedAccelerations.size());
        this.rigidBodiesWithAssignedAcceleration.add(body);
        this.assignedAccelerations.add(newAssignedAcceleration);
        return newAssignedAcceleration;
    }

    private static class AccelerationIndex {
        private int index = -1;

        public AccelerationIndex(int index) {
            this.index = index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

