/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;

public interface SpatialMotionReadOnly
extends SpatialVectorReadOnly {
    public ReferenceFrame getBodyFrame();

    public ReferenceFrame getBaseFrame();

    default public void checkReferenceFrameMatch(SpatialMotionReadOnly other) throws ReferenceFrameMismatchException {
        this.checkReferenceFrameMatch(other.getBodyFrame(), other.getBaseFrame(), other.getReferenceFrame());
    }

    default public void checkReferenceFrameMatch(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame) throws ReferenceFrameMismatchException {
        this.checkBodyFrameMatch(bodyFrame);
        this.checkBaseFrameMatch(baseFrame);
        this.checkExpressedInFrameMatch(expressedInFrame);
    }

    default public void checkBodyFrameMatch(ReferenceFrame bodyFrame) {
        if (this.getBodyFrame() != bodyFrame) {
            throw new ReferenceFrameMismatchException("bodyFrame mismatch: this.bodyFrame = " + this.getBodyFrame() + ", other bodyFrame = " + bodyFrame);
        }
    }

    default public void checkBaseFrameMatch(ReferenceFrame baseFrame) {
        if (this.getBaseFrame() != baseFrame) {
            throw new ReferenceFrameMismatchException("baseFrame mismatch: this.baseFrame = " + this.getBaseFrame() + ", other baseFrame = " + baseFrame);
        }
    }

    default public void checkExpressedInFrameMatch(ReferenceFrame expressedInFrame) {
        if (this.getReferenceFrame() != expressedInFrame) {
            throw new ReferenceFrameMismatchException("expressedInFrame mismatch: this.expressedInFrame = " + this.getReferenceFrame() + ", other expressedInFrame = " + expressedInFrame);
        }
    }

    default public boolean epsilonEquals(SpatialMotionReadOnly other, double epsilon) {
        if (this.getBodyFrame() != other.getBodyFrame()) {
            return false;
        }
        if (this.getBaseFrame() != other.getBaseFrame()) {
            return false;
        }
        return SpatialVectorReadOnly.super.epsilonEquals(other, epsilon);
    }

    default public boolean equals(SpatialMotionReadOnly other) {
        if (other == null) {
            return false;
        }
        if (this.getBodyFrame() != other.getBodyFrame()) {
            return false;
        }
        if (this.getBaseFrame() != other.getBaseFrame()) {
            return false;
        }
        return SpatialVectorReadOnly.super.equals(other);
    }
}

