/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.tools.MecanoTools;

public interface OneDoFJointBasics
extends OneDoFJointReadOnly,
JointBasics {
    public void setQ(double var1);

    public void setQd(double var1);

    public void setQdd(double var1);

    public void setTau(double var1);

    @Override
    default public void setJointConfigurationToZero() {
        this.setQ(0.0);
    }

    @Override
    default public void setJointTwistToZero() {
        this.setQd(0.0);
    }

    @Override
    default public void setJointAccelerationToZero() {
        this.setQdd(0.0);
    }

    @Override
    default public void setJointTauToZero() {
        this.setTau(0.0);
    }

    @Override
    default public void setJointConfiguration(JointReadOnly other) {
        this.setJointConfiguration(MecanoTools.checkTypeAndCast(other, OneDoFJointReadOnly.class));
    }

    default public void setJointConfiguration(OneDoFJointReadOnly other) {
        this.setQ(other.getQ());
    }

    @Override
    default public void setJointTwist(JointReadOnly other) {
        this.setJointTwist(MecanoTools.checkTypeAndCast(other, OneDoFJointReadOnly.class));
    }

    default public void setJointTwist(OneDoFJointReadOnly other) {
        this.setQd(other.getQd());
    }

    @Override
    default public void setJointAcceleration(JointReadOnly other) {
        this.setJointAcceleration(MecanoTools.checkTypeAndCast(other, OneDoFJointReadOnly.class));
    }

    default public void setJointAcceleration(OneDoFJointReadOnly other) {
        this.setQdd(other.getQdd());
    }

    @Override
    default public void setJointWrench(JointReadOnly other) {
        this.setJointWrench(MecanoTools.checkTypeAndCast(other, OneDoFJointReadOnly.class));
    }

    default public void setJointWrench(OneDoFJointReadOnly other) {
        this.setTau(other.getTau());
    }

    @Override
    default public int setJointConfiguration(int rowStart, DMatrix matrix) {
        this.setQ(matrix.get(rowStart, 0));
        return rowStart + this.getConfigurationMatrixSize();
    }

    @Override
    default public int setJointVelocity(int rowStart, DMatrix matrix) {
        this.setQd(matrix.get(rowStart, 0));
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int setJointAcceleration(int rowStart, DMatrix matrix) {
        this.setQdd(matrix.get(rowStart + 0, 0));
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int setJointTau(int rowStart, DMatrix matrix) {
        this.setTau(matrix.get(rowStart, 0));
        return rowStart + this.getDegreesOfFreedom();
    }

    public void setJointLimitLower(double var1);

    public void setJointLimitUpper(double var1);

    default public void setJointLimits(double jointLimitLower, double jointLimitUpper) {
        this.setJointLimitLower(jointLimitLower);
        this.setJointLimitUpper(jointLimitUpper);
    }

    public void setVelocityLimitLower(double var1);

    public void setVelocityLimitUpper(double var1);

    default public void setVelocityLimits(double velocityLimitLower, double velocityLimitUpper) {
        this.setVelocityLimitLower(velocityLimitLower);
        this.setVelocityLimitUpper(velocityLimitUpper);
    }

    default public void setVelocityLimit(double velocityLimit) {
        this.setVelocityLimits(-velocityLimit, velocityLimit);
    }

    public void setEffortLimitLower(double var1);

    public void setEffortLimitUpper(double var1);

    default public void setEffortLimits(double effortLimitLower, double effortLimitUpper) {
        this.setEffortLimitLower(effortLimitLower);
        this.setEffortLimitUpper(effortLimitUpper);
    }

    default public void setEffortLimit(double effortLimit) {
        this.setEffortLimits(-effortLimit, effortLimit);
    }
}

