/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public interface MultiBodySystemBasics
extends MultiBodySystemReadOnly {
    @Override
    public RigidBodyBasics getRootBody();

    default public List<? extends JointBasics> getAllJoints() {
        return SubtreeStreams.fromChildren(this.getRootBody()).collect(Collectors.toList());
    }

    default public List<? extends JointBasics> getJointsToConsider() {
        return this.getAllJoints();
    }

    default public List<? extends JointBasics> getJointsToIgnore() {
        return this.getAllJoints().stream().filter(joint -> !this.getJointsToConsider().contains(joint)).collect(Collectors.toList());
    }

    @Override
    default public JointBasics findJoint(String jointName) {
        return MultiBodySystemTools.findJoint(this.getRootBody(), jointName);
    }

    @Override
    default public RigidBodyBasics findRigidBody(String rigidBodyName) {
        return MultiBodySystemTools.findRigidBody(this.getRootBody(), rigidBodyName);
    }

    public static MultiBodySystemBasics toMultiBodySystemBasics(RigidBodyBasics rootBody) {
        return MultiBodySystemBasics.toMultiBodySystemBasics(rootBody, Collections.emptyList());
    }

    public static MultiBodySystemBasics toMultiBodySystemBasics(RigidBodyBasics rootBody, JointBasics[] jointsToIgnore) {
        return MultiBodySystemBasics.toMultiBodySystemBasics(rootBody, Arrays.asList(jointsToIgnore));
    }

    public static MultiBodySystemBasics toMultiBodySystemBasics(final RigidBodyBasics rootBody, final List<? extends JointBasics> jointsToIgnore) {
        final List allJoints = SubtreeStreams.fromChildren(rootBody).collect(Collectors.toList());
        final List<? extends JointBasics> jointsToConsider = MultiBodySystemBasics.extractJointsToConsider(rootBody, jointsToIgnore);
        final JointMatrixIndexProvider jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(jointsToConsider);
        return new MultiBodySystemBasics(){

            @Override
            public RigidBodyBasics getRootBody() {
                return rootBody;
            }

            @Override
            public List<? extends JointBasics> getAllJoints() {
                return allJoints;
            }

            @Override
            public List<? extends JointBasics> getJointsToConsider() {
                return jointsToConsider;
            }

            @Override
            public List<? extends JointBasics> getJointsToIgnore() {
                return jointsToIgnore;
            }

            @Override
            public JointMatrixIndexProvider getJointMatrixIndexProvider() {
                return jointMatrixIndexProvider;
            }
        };
    }

    public static MultiBodySystemBasics toMultiBodySystemBasics(JointBasics[] jointsToConsider) {
        return MultiBodySystemBasics.toMultiBodySystemBasics(Arrays.asList(jointsToConsider));
    }

    public static MultiBodySystemBasics toMultiBodySystemBasics(final List<? extends JointBasics> jointsToConsider) {
        final RigidBodyBasics rootBody = (RigidBodyBasics)MultiBodySystemReadOnly.getClosestJointToRoot(jointsToConsider).getPredecessor();
        final List allJoints = SubtreeStreams.fromChildren(rootBody).collect(Collectors.toList());
        final List jointsToIgnore = SubtreeStreams.fromChildren(rootBody).filter(joint -> !jointsToConsider.contains(joint)).collect(Collectors.toList());
        final JointMatrixIndexProvider jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(jointsToConsider);
        return new MultiBodySystemBasics(){

            @Override
            public RigidBodyBasics getRootBody() {
                return rootBody;
            }

            @Override
            public List<? extends JointBasics> getAllJoints() {
                return allJoints;
            }

            @Override
            public List<? extends JointBasics> getJointsToConsider() {
                return jointsToConsider;
            }

            @Override
            public List<? extends JointBasics> getJointsToIgnore() {
                return jointsToIgnore;
            }

            @Override
            public JointMatrixIndexProvider getJointMatrixIndexProvider() {
                return jointMatrixIndexProvider;
            }
        };
    }

    public static List<? extends JointBasics> extractJointsToConsider(RigidBodyBasics rootBody, List<? extends JointBasics> jointsToIgnore) {
        return SubtreeStreams.fromChildren(rootBody).filter(candidate -> !MultiBodySystemReadOnly.isJointToBeIgnored(candidate, jointsToIgnore)).collect(Collectors.toList());
    }

    public static MultiBodySystemBasics clone(MultiBodySystemReadOnly original, ReferenceFrame cloneRootFrame) {
        RigidBodyBasics cloneRootBody = MultiBodySystemFactories.cloneMultiBodySystem(original.getRootBody(), cloneRootFrame, "");
        Set namesOfJointsToConsider = SubtreeStreams.fromChildren(original.getRootBody()).map(JointReadOnly::getName).collect(Collectors.toSet());
        List jointsToConsider = SubtreeStreams.fromChildren(cloneRootBody).filter(joint -> namesOfJointsToConsider.contains(joint.getName())).collect(Collectors.toList());
        return MultiBodySystemBasics.toMultiBodySystemBasics(jointsToConsider);
    }
}

