/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.mecano.fourBar.FourBarAngle;
import us.ihmc.mecano.fourBar.FourBarDiagonal;
import us.ihmc.mecano.fourBar.FourBarEdge;
import us.ihmc.mecano.fourBar.FourBarTools;
import us.ihmc.mecano.fourBar.FourBarVertex;

public class FourBar {
    private final FourBarVertex A = new FourBarVertex("A", FourBarAngle.DAB);
    private final FourBarVertex B = new FourBarVertex("B", FourBarAngle.ABC);
    private final FourBarVertex C = new FourBarVertex("C", FourBarAngle.BCD);
    private final FourBarVertex D = new FourBarVertex("D", FourBarAngle.CDA);
    private final FourBarVertex[] vertices = new FourBarVertex[]{this.A, this.B, this.C, this.D};
    private final FourBarEdge AB = new FourBarEdge("AB");
    private final FourBarEdge BC = new FourBarEdge("BC");
    private final FourBarEdge CD = new FourBarEdge("CD");
    private final FourBarEdge DA = new FourBarEdge("DA");
    private final FourBarDiagonal AC = new FourBarDiagonal("AC");
    private final FourBarDiagonal BD = new FourBarDiagonal("BD");

    public FourBar() {
        this.A.setup(this.DA, this.AB, this.AC);
        this.B.setup(this.AB, this.BC, this.BD);
        this.C.setup(this.BC, this.CD, this.AC);
        this.D.setup(this.CD, this.DA, this.BD);
        this.AB.setup(this.A, this.B, this.DA, this.BC);
        this.BC.setup(this.B, this.C, this.AB, this.CD);
        this.CD.setup(this.C, this.D, this.BC, this.DA);
        this.DA.setup(this.D, this.A, this.CD, this.AB);
        this.AC.setup(this.A, this.C, this.BD);
        this.BD.setup(this.B, this.D, this.AC);
        this.A.checkProperlySetup();
        this.B.checkProperlySetup();
        this.C.checkProperlySetup();
        this.D.checkProperlySetup();
        this.AB.checkProperlySetup();
        this.BC.checkProperlySetup();
        this.CD.checkProperlySetup();
        this.DA.checkProperlySetup();
        this.AC.checkProperlySetup();
        this.BD.checkProperlySetup();
    }

    public void setup(Point2DReadOnly A, Point2DReadOnly B, Point2DReadOnly C, Point2DReadOnly D) {
        boolean isAConvex = !EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)A, (Point2DReadOnly)D, (Point2DReadOnly)B);
        boolean isBConvex = !EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)B, (Point2DReadOnly)A, (Point2DReadOnly)C);
        boolean isCConvex = !EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)C, (Point2DReadOnly)B, (Point2DReadOnly)D);
        boolean isDConvex = !EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)D, (Point2DReadOnly)C, (Point2DReadOnly)A);
        int convexCount = isAConvex ? 1 : 0;
        convexCount += isBConvex ? 1 : 0;
        convexCount += isCConvex ? 1 : 0;
        if ((convexCount += isDConvex ? 1 : 0) <= 1) {
            isAConvex = !isAConvex;
            isBConvex = !isBConvex;
            isCConvex = !isCConvex;
            isDConvex = !isDConvex;
        }
        this.setup(A.distance(B), B.distance(C), C.distance(D), D.distance(A), isAConvex, isBConvex, isCConvex, isDConvex);
    }

    public void setup(double AB, double BC, double CD, double DA) {
        this.setup(AB, BC, CD, DA, true, true, true, true);
    }

    public void setup(double AB, double BC, double CD, double DA, boolean isAConvex, boolean isBConvex, boolean isCConvex, boolean isDConvex) {
        this.setToNaN();
        this.AB.setLength(AB);
        this.BC.setLength(BC);
        this.CD.setLength(CD);
        this.DA.setLength(DA);
        int convexCount = isAConvex ? 1 : 0;
        convexCount += isBConvex ? 1 : 0;
        convexCount += isCConvex ? 1 : 0;
        if ((convexCount += isDConvex ? 1 : 0) == 1 || convexCount == 3) {
            throw new UnsupportedOperationException("The quadrilateral ABCD is concave at " + (4 - convexCount) + "vertices, only handles either 0 or 2 concave vertices.");
        }
        if (convexCount == 0) {
            throw new IllegalArgumentException("The four bar linkage cannot be concave at all vertices");
        }
        this.A.setConvex(isAConvex);
        this.B.setConvex(isBConvex);
        this.C.setConvex(isCConvex);
        this.D.setConvex(isDConvex);
    }

    public void setToNaN() {
        this.getVertexA().setToNaN();
        this.getVertexB().setToNaN();
        this.getVertexC().setToNaN();
        this.getVertexD().setToNaN();
        this.getEdgeAB().setToNaN();
        this.getEdgeBC().setToNaN();
        this.getEdgeCD().setToNaN();
        this.getEdgeDA().setToNaN();
        this.getDiagonalAC().setToNaN();
        this.getDiagonalBD().setToNaN();
    }

    public void setToMin(FourBarAngle source) {
        FourBarTools.setToMinAngle(this.getVertex(source));
    }

    public void setToMax(FourBarAngle source) {
        FourBarTools.setToMaxAngle(this.getVertex(source));
    }

    public boolean isCrossed() {
        return FourBarTools.isCrossFourBar(this);
    }

    public Bound update(FourBarAngle source, double angle) {
        return FourBarTools.update(this.vertices[source.ordinal()], angle);
    }

    public Bound update(FourBarAngle source, double angle, double angleDot) {
        return FourBarTools.update(this.vertices[source.ordinal()], angle, angleDot);
    }

    public Bound update(FourBarAngle source, double angle, double angleDot, double angleDDot) {
        return FourBarTools.update(this.vertices[source.ordinal()], angle, angleDot, angleDDot);
    }

    public FourBarVertex getVertexA() {
        return this.A;
    }

    public FourBarVertex getVertexB() {
        return this.B;
    }

    public FourBarVertex getVertexC() {
        return this.C;
    }

    public FourBarVertex getVertexD() {
        return this.D;
    }

    public FourBarVertex getVertex(FourBarAngle angle) {
        return this.vertices[angle.ordinal()];
    }

    public FourBarEdge getEdgeAB() {
        return this.AB;
    }

    public FourBarEdge getEdgeBC() {
        return this.BC;
    }

    public FourBarEdge getEdgeCD() {
        return this.CD;
    }

    public FourBarEdge getEdgeDA() {
        return this.DA;
    }

    public FourBarDiagonal getDiagonalAC() {
        return this.AC;
    }

    public FourBarDiagonal getDiagonalBD() {
        return this.BD;
    }

    public double getAngleDAB() {
        return this.getVertexA().getAngle();
    }

    public double getAngleABC() {
        return this.getVertexB().getAngle();
    }

    public double getAngleBCD() {
        return this.getVertexC().getAngle();
    }

    public double getAngleCDA() {
        return this.getVertexD().getAngle();
    }

    public double getAngleDtDAB() {
        return this.getVertexA().getAngleDot();
    }

    public double getAngleDtABC() {
        return this.getVertexB().getAngleDot();
    }

    public double getAngleDtBCD() {
        return this.getVertexC().getAngleDot();
    }

    public double getAngleDtCDA() {
        return this.getVertexD().getAngleDot();
    }

    public double getAngleDt2DAB() {
        return this.getVertexA().getAngleDDot();
    }

    public double getAngleDt2ABC() {
        return this.getVertexB().getAngleDDot();
    }

    public double getAngleDt2BCD() {
        return this.getVertexC().getAngleDDot();
    }

    public double getAngleDt2CDA() {
        return this.getVertexD().getAngleDDot();
    }

    public double getMinDAB() {
        return this.getVertexA().getMinAngle();
    }

    public double getMaxDAB() {
        return this.getVertexA().getMaxAngle();
    }

    public double getMinABC() {
        return this.getVertexB().getMinAngle();
    }

    public double getMaxABC() {
        return this.getVertexB().getMaxAngle();
    }

    public double getMinBCD() {
        return this.getVertexC().getMinAngle();
    }

    public double getMaxBCD() {
        return this.getVertexC().getMaxAngle();
    }

    public double getMinCDA() {
        return this.getVertexD().getMinAngle();
    }

    public double getMaxCDA() {
        return this.getVertexD().getMaxAngle();
    }

    public double getAB() {
        return this.getEdgeAB().getLength();
    }

    public double getBC() {
        return this.getEdgeBC().getLength();
    }

    public double getCD() {
        return this.getEdgeCD().getLength();
    }

    public double getDA() {
        return this.getEdgeDA().getLength();
    }

    public String toString() {
        return String.format("Lengths: AB=%f, BC=%f, CD=%f, DA=%f\nAngles: DAB=%f, ABC=%f, BCD=%f, CDA=%f", this.AB.getLength(), this.BC.getLength(), this.CD.getLength(), this.DA.getLength(), this.A.getAngle(), this.B.getAngle(), this.C.getAngle(), this.D.getAngle());
    }
}

