/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.fourBar.CrossFourBarJointIKSolver;
import us.ihmc.mecano.fourBar.FourBar;
import us.ihmc.mecano.fourBar.FourBarAngle;
import us.ihmc.mecano.fourBar.FourBarEdge;
import us.ihmc.mecano.fourBar.FourBarKinematicLoopFunctionTools;
import us.ihmc.mecano.fourBar.FourBarTools;
import us.ihmc.mecano.fourBar.FourBarVertex;

public class CrossFourBarJointIKBinarySolver
implements CrossFourBarJointIKSolver {
    private static final boolean DEBUG = false;
    private final double tolerance;
    private final int maxIterations;
    private int iterations;
    private final FourBar fourBar = new FourBar();
    private boolean useNaiveMethod = false;
    private FourBarKinematicLoopFunctionTools.FourBarToJointConverter[] converters = null;
    private final SolutionBounds solutionBounds = new SolutionBounds();
    private FourBarVertex lastVertexToSolveFor = null;

    public CrossFourBarJointIKBinarySolver(double tolerance) {
        this(tolerance, 100);
    }

    public CrossFourBarJointIKBinarySolver(double tolerance, int maxIterations) {
        this.tolerance = tolerance;
        this.maxIterations = maxIterations;
    }

    public void setUseNaiveMethod(boolean useNaiveMethod) {
        this.useNaiveMethod = useNaiveMethod;
    }

    @Override
    public void setConverters(FourBarKinematicLoopFunctionTools.FourBarToJointConverter[] converters) {
        this.converters = converters;
    }

    @Override
    public double solve(double theta, FourBarVertex vertexToSolveFor) {
        if (vertexToSolveFor == this.lastVertexToSolveFor && this.solutionBounds.isInsideBounds(theta)) {
            return this.convert(vertexToSolveFor, this.solutionBounds.computeSolution(theta));
        }
        if (!FourBarTools.isCrossFourBar(vertexToSolveFor)) {
            throw new IllegalArgumentException("The given vertex does not belong to a cross four bar.");
        }
        this.lastVertexToSolveFor = vertexToSolveFor;
        this.solutionBounds.clear();
        double angle = this.isThetaAtLimit(theta, vertexToSolveFor, this.solutionBounds);
        if (!Double.isNaN(angle)) {
            this.solutionBounds.clear();
            return angle;
        }
        if (vertexToSolveFor.isConvex() != vertexToSolveFor.getNextEdge().isCrossing()) {
            theta = -theta;
        }
        if (this.useNaiveMethod) {
            this.solveNaive(theta, vertexToSolveFor, this.solutionBounds);
        } else {
            this.solveInternal(theta, vertexToSolveFor, this.solutionBounds);
        }
        return this.convert(vertexToSolveFor, this.solutionBounds.computeSolution(theta));
    }

    private double isThetaAtLimit(double theta, FourBarVertex vertexToSolveFor, SolutionBounds boundsToPack) {
        FourBarVertex A = vertexToSolveFor;
        boolean isNextCrossing = A.getNextEdge().isCrossing();
        FourBarVertex B = isNextCrossing ? A.getNextVertex() : A.getPreviousVertex();
        boundsToPack.minDAB = A.getMinAngle();
        boundsToPack.maxDAB = A.getMaxAngle();
        double minAngleA = this.convert(A, boundsToPack.minDAB);
        double maxAngleA = this.convert(A, boundsToPack.maxDAB);
        boundsToPack.thetaMin = minAngleA + this.convert(B, B.getMinAngle());
        boundsToPack.thetaMax = maxAngleA + this.convert(B, B.getMaxAngle());
        boolean bl = boundsToPack.limitsInverted = boundsToPack.thetaMin > boundsToPack.thetaMax;
        if (boundsToPack.limitsInverted) {
            boundsToPack.thetaMin = -boundsToPack.thetaMin;
            boundsToPack.thetaMax = -boundsToPack.thetaMax;
        }
        if (A.isConvex() == isNextCrossing) {
            if (theta <= boundsToPack.thetaMin + this.tolerance) {
                return minAngleA;
            }
            if (theta >= boundsToPack.thetaMax - this.tolerance) {
                return maxAngleA;
            }
        } else {
            if (-theta <= boundsToPack.thetaMin + this.tolerance) {
                return minAngleA;
            }
            if (-theta >= boundsToPack.thetaMax - this.tolerance) {
                return maxAngleA;
            }
        }
        return Double.NaN;
    }

    private void solveNaive(double theta, FourBarVertex vertexToSolveFor, SolutionBounds bounds) {
        long start = System.nanoTime();
        this.setupFourBar(vertexToSolveFor);
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterA = null;
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterB = null;
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterD = null;
        if (this.converters != null) {
            converterA = this.getConverter(vertexToSolveFor);
            converterB = this.getConverter(vertexToSolveFor.getNextVertex());
            converterD = this.getConverter(vertexToSolveFor.getPreviousVertex());
        }
        double minDAB = bounds.minDAB;
        double maxDAB = bounds.maxDAB;
        double thetaMin = bounds.thetaMin;
        double thetaMax = bounds.thetaMax;
        double currentDAB = Double.NaN;
        this.iterations = 0;
        while (this.iterations < this.maxIterations) {
            currentDAB = 0.5 * (minDAB + maxDAB);
            this.fourBar.update(FourBarAngle.DAB, currentDAB);
            double actualTheta = converterA == null ? currentDAB : converterA.toJointAngle(currentDAB);
            actualTheta = this.fourBar.getEdgeDA().isCrossing() ? (actualTheta += this.convert(converterD, this.fourBar.getAngleCDA())) : (actualTheta += this.convert(converterB, this.fourBar.getAngleABC()));
            if (bounds.limitsInverted) {
                actualTheta = -actualTheta;
            }
            if (actualTheta > theta) {
                maxDAB = currentDAB;
                thetaMax = actualTheta;
            } else {
                minDAB = currentDAB;
                thetaMin = actualTheta;
            }
            if (Math.abs(thetaMax - thetaMin) <= this.tolerance) break;
            ++this.iterations;
        }
        bounds.thetaMin = thetaMin;
        bounds.thetaMax = thetaMax;
        bounds.minDAB = minDAB;
        bounds.maxDAB = maxDAB;
    }

    private void setupFourBar(FourBarVertex vertexToSolverFor) {
        FourBarVertex A = vertexToSolverFor;
        FourBarVertex B = A.getNextVertex();
        FourBarVertex C = B.getNextVertex();
        FourBarVertex D = C.getNextVertex();
        this.fourBar.setup(A.getNextEdge().getLength(), B.getNextEdge().getLength(), C.getNextEdge().getLength(), D.getNextEdge().getLength(), A.isConvex(), B.isConvex(), C.isConvex(), D.isConvex());
    }

    private void solveInternal(double theta, FourBarVertex vertexToSolveFor, SolutionBounds bounds) {
        long start = System.nanoTime();
        FourBarVertex A = vertexToSolveFor;
        FourBarEdge ABEdge = A.getNextEdge();
        FourBarEdge BCEdge = ABEdge.getNext();
        FourBarEdge CDEdge = BCEdge.getNext();
        FourBarEdge DAEdge = CDEdge.getNext();
        double AB = ABEdge.getLength();
        double BC = BCEdge.getLength();
        double CD = CDEdge.getLength();
        double DA = DAEdge.getLength();
        double minDAB = bounds.minDAB;
        double maxDAB = bounds.maxDAB;
        double thetaMin = bounds.thetaMin;
        double thetaMax = bounds.thetaMax;
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterA = null;
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterB = null;
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterD = null;
        if (this.converters != null) {
            converterA = this.getConverter(vertexToSolveFor);
            converterB = this.getConverter(vertexToSolveFor.getNextVertex());
            converterD = this.getConverter(vertexToSolveFor.getPreviousVertex());
        }
        double currentDAB = Double.NaN;
        this.iterations = 0;
        while (this.iterations < this.maxIterations) {
            double otherAngle;
            currentDAB = 0.5 * (minDAB + maxDAB);
            double BD = EuclidGeometryTools.unknownTriangleSideLengthByLawOfCosine((double)AB, (double)DA, (double)currentDAB);
            if (DAEdge.isCrossing()) {
                double cosADB = FourBarTools.cosineAngleWithCosineLaw(DA, BD, AB);
                double cosCDB = FourBarTools.cosineAngleWithCosineLaw(CD, BD, BC);
                otherAngle = Math.abs(FourBarTools.fastAcos(cosADB * cosCDB + Math.sqrt((1.0 - cosADB * cosADB) * (1.0 - cosCDB * cosCDB))));
                if (!DAEdge.getStart().isConvex()) {
                    otherAngle = -otherAngle;
                }
                otherAngle = this.convert(converterD, otherAngle);
            } else {
                double cosABD = FourBarTools.cosineAngleWithCosineLaw(AB, BD, DA);
                double cosCBD = FourBarTools.cosineAngleWithCosineLaw(BC, BD, CD);
                otherAngle = Math.abs(FourBarTools.fastAcos(cosABD * cosCBD + Math.sqrt((1.0 - cosABD * cosABD) * (1.0 - cosCBD * cosCBD))));
                if (!BCEdge.getStart().isConvex()) {
                    otherAngle = -otherAngle;
                }
                otherAngle = this.convert(converterB, otherAngle);
            }
            double actualTheta = this.convert(converterA, currentDAB) + otherAngle;
            if (bounds.limitsInverted) {
                actualTheta = -actualTheta;
            }
            if (actualTheta > theta) {
                maxDAB = currentDAB;
                thetaMax = actualTheta;
            } else {
                minDAB = currentDAB;
                thetaMin = actualTheta;
            }
            if (Math.abs(thetaMax - thetaMin) <= this.tolerance) break;
            ++this.iterations;
        }
        bounds.thetaMin = thetaMin;
        bounds.thetaMax = thetaMax;
        bounds.minDAB = minDAB;
        bounds.maxDAB = maxDAB;
    }

    private double convert(FourBarVertex vertex, double vertexAngle) {
        return this.convert(this.getConverter(vertex), vertexAngle);
    }

    private double convert(FourBarKinematicLoopFunctionTools.FourBarToJointConverter converter, double vertexAngle) {
        return converter == null ? vertexAngle : converter.toJointAngle(vertexAngle);
    }

    private FourBarKinematicLoopFunctionTools.FourBarToJointConverter getConverter(FourBarVertex vertex) {
        return this.converters == null ? null : this.converters[vertex.getFourBarAngle().ordinal()];
    }

    private static class SolutionBounds {
        private boolean limitsInverted;
        private double thetaMin;
        private double thetaMax;
        private double minDAB;
        private double maxDAB;

        public SolutionBounds() {
            this.clear();
        }

        private void clear() {
            this.thetaMin = Double.NaN;
            this.thetaMax = Double.NaN;
            this.minDAB = Double.NaN;
            this.maxDAB = Double.NaN;
        }

        private boolean isInsideBounds(double theta) {
            if (Double.isNaN(this.thetaMin) || Double.isNaN(this.thetaMax)) {
                return false;
            }
            return theta >= this.thetaMin && theta <= this.thetaMax;
        }

        private double computeSolution(double theta) {
            double alpha = (theta - this.thetaMin) / (this.thetaMax - this.thetaMin);
            return EuclidCoreTools.interpolate((double)this.minDAB, (double)this.maxDAB, (double)alpha);
        }
    }
}

