/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MultiBodyResponseCalculator {
    private final MultiBodySystemReadOnly input;
    private final ResponseRecursionStep initialRecursionStep;
    private final Map<RigidBodyReadOnly, ResponseRecursionStep> rigidBodyToRecursionStepMap = new HashMap<RigidBodyReadOnly, ResponseRecursionStep>();
    private final DMatrixRMaj jointMotionChangeMatrix;
    private final ForwardDynamicsCalculator forwardDynamicsCalculator;
    private final RigidBodyAccelerationProvider accelerationChangeProvider;
    private final RigidBodyTwistProvider twistChangeProvider;
    private ResponseType currentResponseType = null;
    private final DMatrixRMaj singleElementMatrix = new DMatrixRMaj(1, 1);

    public MultiBodyResponseCalculator(MultiBodySystemReadOnly input) {
        this(new ForwardDynamicsCalculator(input));
    }

    public MultiBodyResponseCalculator(ForwardDynamicsCalculator forwardDynamicsCalculator) {
        this.forwardDynamicsCalculator = forwardDynamicsCalculator;
        this.input = forwardDynamicsCalculator.getInput();
        this.initialRecursionStep = new ResponseRecursionStep(forwardDynamicsCalculator.getInitialRecursionStep(), null);
        this.buildMultiBodyTree(this.initialRecursionStep);
        int nDoFs = MultiBodySystemTools.computeDegreesOfFreedom(this.input.getJointsToConsider());
        this.jointMotionChangeMatrix = new DMatrixRMaj(nDoFs, 1);
        this.accelerationChangeProvider = RigidBodyAccelerationProvider.toRigidBodyAccelerationProvider(this.buildAccelerationSupplier(), this.input.getInertialFrame());
        this.twistChangeProvider = RigidBodyTwistProvider.toRigidBodyTwistProvider(this.buildTwistSupplier(), this.input.getInertialFrame());
    }

    private Function<RigidBodyReadOnly, SpatialAccelerationReadOnly> buildAccelerationSupplier() {
        SpatialAcceleration bodyAcceleration = new SpatialAcceleration();
        Function<RigidBodyReadOnly, SpatialAccelerationReadOnly> accelerationFunction = body -> {
            if (this.currentResponseType == ResponseType.TWIST) {
                throw new IllegalStateException("This calculator is currently setup for calculating twists.");
            }
            ResponseRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(body);
            if (recursionStep == null) {
                return null;
            }
            if (this.currentResponseType == null || !this.initialRecursionStep.isUpToDate) {
                bodyAcceleration.setToZero(body.getBodyFixedFrame(), this.input.getInertialFrame(), body.getBodyFixedFrame());
            } else {
                recursionStep.updateRigidBodyMotionChange();
                bodyAcceleration.setIncludingFrame(recursionStep.rigidBodyMotionChange);
                bodyAcceleration.changeFrame(body.getBodyFixedFrame());
            }
            return bodyAcceleration;
        };
        return accelerationFunction;
    }

    private Function<RigidBodyReadOnly, TwistReadOnly> buildTwistSupplier() {
        Twist bodyTwist = new Twist();
        Function<RigidBodyReadOnly, TwistReadOnly> twistFunction = body -> {
            if (this.currentResponseType == ResponseType.ACCELERATION) {
                throw new IllegalStateException("This calculator is currently setup for calculating accelerations.");
            }
            ResponseRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(body);
            if (recursionStep == null) {
                return null;
            }
            if (!this.initialRecursionStep.isUpToDate) {
                bodyTwist.setToZero(body.getBodyFixedFrame(), this.input.getInertialFrame(), body.getBodyFixedFrame());
            } else {
                recursionStep.updateRigidBodyMotionChange();
                bodyTwist.setIncludingFrame(recursionStep.rigidBodyMotionChange);
                bodyTwist.changeFrame(body.getBodyFixedFrame());
            }
            return bodyTwist;
        };
        return twistFunction;
    }

    private void buildMultiBodyTree(ResponseRecursionStep recursionStep) {
        for (ForwardDynamicsCalculator.ArticulatedBodyRecursionStep childInertia : recursionStep.articulatedBodyRecursionStep.children) {
            ResponseRecursionStep child = new ResponseRecursionStep(childInertia, recursionStep);
            this.rigidBodyToRecursionStepMap.put(childInertia.rigidBody, child);
            this.buildMultiBodyTree(child);
        }
    }

    public ForwardDynamicsCalculator getForwardDynamicsCalculator() {
        return this.forwardDynamicsCalculator;
    }

    public void reset() {
        this.currentResponseType = null;
        this.initialRecursionStep.reset();
    }

    public boolean computeRigidBodyApparentSpatialInertiaInverse(RigidBodyReadOnly target, ReferenceFrame inertiaFrame, DMatrix1Row apparentSpatialInertiaToPack) {
        return this.computeRigidBodyApparentSpatialInertiaInverse(target, inertiaFrame, null, apparentSpatialInertiaToPack);
    }

    public boolean computeRigidBodyApparentSpatialInertiaInverse(RigidBodyReadOnly target, ReferenceFrame inertiaFrame, boolean[] selectedAxes, DMatrix1Row apparentSpatialInertiaToPack) {
        int axis;
        ResponseRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(target);
        if (recursionStep == null) {
            return false;
        }
        MovingReferenceFrame bodyFrame = target.getBodyFixedFrame();
        apparentSpatialInertiaToPack.reshape(6, 6);
        this.reset();
        for (axis = 0; axis < 3; ++axis) {
            if (selectedAxes == null || selectedAxes[axis]) {
                recursionStep.testDisturbancePlus.setIncludingFrame((ReferenceFrame)bodyFrame, inertiaFrame, (Vector3DReadOnly)Axis3D.values[axis], EuclidCoreTools.zeroVector3D);
                recursionStep.initializeDisturbance();
                recursionStep.updateRigidBodyMotionChange();
                recursionStep.rigidBodyMotionChange.changeFrame(inertiaFrame);
                recursionStep.rigidBodyMotionChange.get(0, axis, (DMatrix)apparentSpatialInertiaToPack);
                this.reset();
                continue;
            }
            apparentSpatialInertiaToPack.unsafe_set(0, axis, 0.0);
            apparentSpatialInertiaToPack.unsafe_set(1, axis, 0.0);
            apparentSpatialInertiaToPack.unsafe_set(2, axis, 0.0);
            apparentSpatialInertiaToPack.unsafe_set(0, axis + 3, 0.0);
            apparentSpatialInertiaToPack.unsafe_set(2, axis + 3, 0.0);
            apparentSpatialInertiaToPack.unsafe_set(3, axis + 3, 0.0);
        }
        for (axis = 0; axis < 3; ++axis) {
            if (selectedAxes == null || selectedAxes[axis + 3]) {
                recursionStep.testDisturbancePlus.setIncludingFrame((ReferenceFrame)bodyFrame, inertiaFrame, EuclidCoreTools.zeroVector3D, (Vector3DReadOnly)Axis3D.values[axis]);
                recursionStep.initializeDisturbance();
                recursionStep.updateRigidBodyMotionChange();
                recursionStep.rigidBodyMotionChange.changeFrame(inertiaFrame);
                recursionStep.rigidBodyMotionChange.get(0, axis + 3, (DMatrix)apparentSpatialInertiaToPack);
                this.reset();
                continue;
            }
            apparentSpatialInertiaToPack.unsafe_set(3, axis, 0.0);
            apparentSpatialInertiaToPack.unsafe_set(4, axis, 0.0);
            apparentSpatialInertiaToPack.unsafe_set(5, axis, 0.0);
            apparentSpatialInertiaToPack.unsafe_set(3, axis + 3, 0.0);
            apparentSpatialInertiaToPack.unsafe_set(4, axis + 3, 0.0);
            apparentSpatialInertiaToPack.unsafe_set(5, axis + 3, 0.0);
        }
        return true;
    }

    public boolean computeRigidBodyApparentLinearInertiaInverse(RigidBodyReadOnly target, ReferenceFrame inertiaFrame, DMatrix1Row apparentLinearInertiaToPack) {
        ResponseRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(target);
        if (recursionStep == null) {
            return false;
        }
        MovingReferenceFrame bodyFrame = target.getBodyFixedFrame();
        apparentLinearInertiaToPack.reshape(3, 3);
        this.reset();
        for (int axis = 0; axis < 3; ++axis) {
            recursionStep.testDisturbancePlus.setIncludingFrame((ReferenceFrame)bodyFrame, inertiaFrame, EuclidCoreTools.zeroVector3D, (Vector3DReadOnly)Axis3D.values[axis], EuclidCoreTools.origin3D);
            recursionStep.initializeDisturbance();
            recursionStep.updateRigidBodyMotionChange();
            recursionStep.rigidBodyMotionChange.changeFrame(inertiaFrame);
            recursionStep.rigidBodyMotionChange.getLinearPart().get(0, axis, (DMatrix)apparentLinearInertiaToPack);
            this.reset();
        }
        return true;
    }

    public boolean computeJointApparentInertiaInverse(JointReadOnly target, DMatrix1Row inertiaToPack) {
        ResponseRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(target.getSuccessor());
        if (recursionStep == null) {
            return false;
        }
        inertiaToPack.reshape(target.getDegreesOfFreedom(), target.getDegreesOfFreedom());
        this.reset();
        for (int i = 0; i < target.getDegreesOfFreedom(); ++i) {
            recursionStep.tauPlus.set(i, 0, 1.0);
            recursionStep.initializeDisturbance();
            recursionStep.updateRigidBodyMotionChange();
            CommonOps_DDRM.insert((DMatrix)recursionStep.qddPlus, (DMatrix)inertiaToPack, (int)0, (int)i);
            recursionStep.tauPlus.set(i, 0, 0.0);
            this.reset();
        }
        return true;
    }

    public double computeJointApparentInertiaInverse(OneDoFJointReadOnly target) {
        ResponseRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(target.getSuccessor());
        if (recursionStep == null) {
            return Double.NaN;
        }
        this.reset();
        recursionStep.tauPlus.set(0, 1.0);
        recursionStep.initializeDisturbance();
        recursionStep.updateRigidBodyMotionChange();
        this.reset();
        return recursionStep.qddPlus.get(0);
    }

    public boolean applyRigidBodyWrench(RigidBodyReadOnly target, WrenchReadOnly wrench) {
        if (this.currentResponseType == ResponseType.TWIST) {
            return false;
        }
        if (!this.applyRigidBodyDisturbance(target, wrench)) {
            return false;
        }
        this.currentResponseType = ResponseType.ACCELERATION;
        return true;
    }

    public boolean applyRigidBodyImpulse(RigidBodyReadOnly target, SpatialImpulseReadOnly impulse) {
        if (this.currentResponseType == ResponseType.ACCELERATION) {
            return false;
        }
        if (!this.applyRigidBodyDisturbance(target, impulse)) {
            return false;
        }
        this.currentResponseType = ResponseType.TWIST;
        return true;
    }

    private boolean applyRigidBodyDisturbance(RigidBodyReadOnly target, SpatialForceReadOnly disturbance) {
        ResponseRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(target);
        if (recursionStep == null) {
            return false;
        }
        MovingReferenceFrame bodyFrame = target.getBodyFixedFrame();
        recursionStep.testDisturbancePlus.setIncludingFrame((ReferenceFrame)bodyFrame, disturbance);
        recursionStep.initializeDisturbance();
        return true;
    }

    public boolean applyJointWrench(OneDoFJointReadOnly target, double effort) {
        if (this.currentResponseType == ResponseType.TWIST) {
            return false;
        }
        if (!this.applyJointDisturbance(target, effort)) {
            return false;
        }
        this.currentResponseType = ResponseType.ACCELERATION;
        return true;
    }

    public boolean applyJointWrench(JointReadOnly target, DMatrix wrench) {
        if (this.currentResponseType == ResponseType.TWIST) {
            return false;
        }
        if (!this.applyJointDisturbance(target, wrench)) {
            return false;
        }
        this.currentResponseType = ResponseType.ACCELERATION;
        return true;
    }

    public boolean applyJointImpulse(OneDoFJointReadOnly target, double impulse) {
        if (this.currentResponseType == ResponseType.ACCELERATION) {
            return false;
        }
        if (!this.applyJointDisturbance(target, impulse)) {
            return false;
        }
        this.currentResponseType = ResponseType.TWIST;
        return true;
    }

    public boolean applyJointImpulse(JointReadOnly target, DMatrix impulse) {
        if (this.currentResponseType == ResponseType.ACCELERATION) {
            return false;
        }
        if (!this.applyJointDisturbance(target, impulse)) {
            return false;
        }
        this.currentResponseType = ResponseType.TWIST;
        return true;
    }

    private boolean applyJointDisturbance(OneDoFJointReadOnly target, double disturbance) {
        this.singleElementMatrix.set(0, disturbance);
        return this.applyJointDisturbance((JointReadOnly)target, (DMatrix)this.singleElementMatrix);
    }

    private boolean applyJointDisturbance(JointReadOnly target, DMatrix disturbance) {
        ResponseRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(target.getSuccessor());
        if (recursionStep == null) {
            return false;
        }
        if (disturbance.getNumRows() != recursionStep.getJoint().getDegreesOfFreedom() || disturbance.getNumCols() != 1) {
            throw new IllegalArgumentException("Matrix dimension mismatch: expected " + recursionStep.getJoint().getDegreesOfFreedom() + "-by-1, was " + disturbance.getNumRows() + "-by-" + disturbance.getNumCols());
        }
        recursionStep.tauPlus.set((Matrix)disturbance);
        recursionStep.initializeDisturbance();
        return true;
    }

    public DMatrixRMaj propagateWrench() {
        return this.currentResponseType == ResponseType.ACCELERATION ? this.propagateDisturbance() : null;
    }

    public DMatrixRMaj propagateImpulse() {
        return this.currentResponseType == ResponseType.TWIST ? this.propagateDisturbance() : null;
    }

    private DMatrixRMaj propagateDisturbance() {
        if (!this.initialRecursionStep.isUpToDate) {
            return null;
        }
        this.initialRecursionStep.propagateDownDisturbance();
        return this.jointMotionChangeMatrix;
    }

    public RigidBodyAccelerationProvider getAccelerationChangeProvider() {
        return this.accelerationChangeProvider;
    }

    public RigidBodyTwistProvider getTwistChangeProvider() {
        return this.twistChangeProvider;
    }

    public double getJointAccelerationChange(OneDoFJointReadOnly joint) {
        return this.currentResponseType != ResponseType.ACCELERATION ? Double.NaN : this.getJointMotionChange(joint);
    }

    public DMatrixRMaj getJointAccelerationChange(JointReadOnly joint) {
        return this.currentResponseType != ResponseType.ACCELERATION ? null : this.getJointMotionChange(joint);
    }

    public double getJointTwistChange(OneDoFJointReadOnly joint) {
        return this.currentResponseType != ResponseType.TWIST ? Double.NaN : this.getJointMotionChange(joint);
    }

    public DMatrixRMaj getJointTwistChange(JointReadOnly joint) {
        return this.currentResponseType != ResponseType.TWIST ? null : this.getJointMotionChange(joint);
    }

    private double getJointMotionChange(OneDoFJointReadOnly joint) {
        ResponseRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(joint.getSuccessor());
        if (recursionStep == null) {
            return Double.NaN;
        }
        if (this.currentResponseType == null || !this.initialRecursionStep.isUpToDate) {
            return Double.NaN;
        }
        recursionStep.updateRigidBodyMotionChange();
        return recursionStep.qddPlus.get(0);
    }

    private DMatrixRMaj getJointMotionChange(JointReadOnly joint) {
        ResponseRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(joint.getSuccessor());
        if (recursionStep == null) {
            return null;
        }
        if (this.currentResponseType == null || !this.initialRecursionStep.isUpToDate) {
            return null;
        }
        recursionStep.updateRigidBodyMotionChange();
        return recursionStep.qddPlus;
    }

    private static enum ResponseType {
        ACCELERATION,
        TWIST;

    }

    class ResponseRecursionStep {
        final Wrench testDisturbancePlus;
        final Wrench totalDisturbancePlus;
        final SpatialForce totalDisturbancePlusForParent;
        final SpatialAcceleration rigidBodyMotionChange = new SpatialAcceleration();
        final SpatialAcceleration parentMotionChange;
        final DMatrixRMaj tauPlus;
        final DMatrixRMaj pAPlus;
        final DMatrixRMaj uPlus;
        final DMatrixRMaj paPlus;
        final DMatrixRMaj aParentPlus;
        final DMatrixRMaj aPlus;
        final DMatrixRMaj qddPlus_intermediate;
        final DMatrixRMaj qddPlus;
        private ForwardDynamicsCalculator.ArticulatedBodyRecursionStep articulatedBodyRecursionStep;
        private ResponseRecursionStep parent;
        final List<ResponseRecursionStep> children = new ArrayList<ResponseRecursionStep>();
        private boolean isOnDisturbedBranch = false;
        private boolean isUpToDate = false;

        public ResponseRecursionStep(ForwardDynamicsCalculator.ArticulatedBodyRecursionStep articulatedBodyRecursionStep, ResponseRecursionStep parent) {
            this.articulatedBodyRecursionStep = articulatedBodyRecursionStep;
            this.parent = parent;
            if (parent == null) {
                this.testDisturbancePlus = null;
                this.totalDisturbancePlus = null;
                this.totalDisturbancePlusForParent = null;
                this.parentMotionChange = null;
                this.rigidBodyMotionChange.setToZero(this.getBodyFixedFrame(), MultiBodyResponseCalculator.this.input.getInertialFrame(), this.getBodyFixedFrame());
                this.tauPlus = null;
                this.pAPlus = null;
                this.uPlus = null;
                this.paPlus = null;
                this.qddPlus_intermediate = null;
                this.qddPlus = null;
                this.aParentPlus = null;
                this.aPlus = null;
            } else {
                parent.children.add(this);
                int nDoFs = this.getJoint().getDegreesOfFreedom();
                this.testDisturbancePlus = new Wrench((ReferenceFrame)this.getBodyFixedFrame(), this.getBodyFixedFrame());
                this.totalDisturbancePlus = new Wrench((ReferenceFrame)this.getBodyFixedFrame(), this.getFrameAfterJoint());
                this.totalDisturbancePlusForParent = parent.isRoot() ? null : new SpatialForce();
                this.parentMotionChange = new SpatialAcceleration();
                this.tauPlus = new DMatrixRMaj(nDoFs, 1);
                this.pAPlus = new DMatrixRMaj(6, 1);
                this.uPlus = new DMatrixRMaj(nDoFs, 1);
                this.paPlus = new DMatrixRMaj(6, 1);
                this.qddPlus_intermediate = new DMatrixRMaj(nDoFs, 1);
                this.qddPlus = new DMatrixRMaj(nDoFs, 1);
                this.aParentPlus = new DMatrixRMaj(6, 1);
                this.aPlus = new DMatrixRMaj(6, 1);
            }
        }

        public void reset() {
            if (!this.isOnDisturbedBranch && !this.isUpToDate) {
                return;
            }
            this.isOnDisturbedBranch = false;
            this.isUpToDate = false;
            if (!this.isRoot()) {
                this.testDisturbancePlus.setToZero();
                this.tauPlus.zero();
            }
            for (ResponseRecursionStep child : this.children) {
                child.reset();
            }
        }

        public void markDirty() {
            if (!this.isUpToDate) {
                return;
            }
            this.isUpToDate = false;
            for (ResponseRecursionStep child : this.children) {
                child.markDirty();
            }
        }

        public void initializeDisturbance() {
            if (this.isRoot()) {
                this.isUpToDate = true;
                this.isOnDisturbedBranch = true;
                return;
            }
            this.stepUpDisturbance();
            this.isOnDisturbedBranch = true;
            this.parent.initializeDisturbance();
        }

        public void stepUpDisturbance() {
            this.isUpToDate = false;
            this.totalDisturbancePlus.setToZero();
            for (int i = 0; i < this.children.size(); ++i) {
                ResponseRecursionStep child = this.children.get(i);
                if (child.isOnDisturbedBranch) {
                    this.totalDisturbancePlus.add(child.totalDisturbancePlusForParent);
                }
                child.markDirty();
            }
            this.testDisturbancePlus.changeFrame(this.getFrameAfterJoint());
            this.totalDisturbancePlus.sub(this.testDisturbancePlus);
            this.totalDisturbancePlus.get((DMatrix)this.pAPlus);
            if (this.articulatedBodyRecursionStep.sourceMode == ForwardDynamicsCalculator.JointSourceMode.EFFORT_SOURCE) {
                DMatrixRMaj S = this.articulatedBodyRecursionStep.S;
                CommonOps_DDRM.multTransA((double)-1.0, (DMatrix1Row)S, (DMatrix1Row)this.pAPlus, (DMatrix1Row)this.uPlus);
                CommonOps_DDRM.addEquals((DMatrixD1)this.uPlus, (DMatrixD1)this.tauPlus);
                if (!this.parent.isRoot()) {
                    DMatrixRMaj U_Dinv = this.articulatedBodyRecursionStep.U_Dinv;
                    CommonOps_DDRM.mult((DMatrix1Row)U_Dinv, (DMatrix1Row)this.uPlus, (DMatrix1Row)this.paPlus);
                    CommonOps_DDRM.addEquals((DMatrixD1)this.paPlus, (DMatrixD1)this.pAPlus);
                    this.totalDisturbancePlusForParent.setIncludingFrame(this.totalDisturbancePlus.getReferenceFrame(), (DMatrix)this.paPlus);
                    this.totalDisturbancePlusForParent.applyTransform((RigidBodyTransformReadOnly)this.articulatedBodyRecursionStep.transformToParentJointFrame);
                    this.totalDisturbancePlusForParent.setReferenceFrame(this.parent.getFrameAfterJoint());
                }
            } else if (!this.parent.isRoot()) {
                this.totalDisturbancePlusForParent.setIncludingFrame(this.totalDisturbancePlus.getReferenceFrame(), (DMatrix)this.pAPlus);
                this.totalDisturbancePlusForParent.applyTransform((RigidBodyTransformReadOnly)this.articulatedBodyRecursionStep.transformToParentJointFrame);
                this.totalDisturbancePlusForParent.setReferenceFrame(this.parent.getFrameAfterJoint());
            }
        }

        public void propagateDownDisturbance() {
            this.stepDownDisturbance();
            if (!this.isRoot()) {
                int[] jointIndices = this.articulatedBodyRecursionStep.jointIndices;
                if (this.articulatedBodyRecursionStep.sourceMode == ForwardDynamicsCalculator.JointSourceMode.EFFORT_SOURCE) {
                    for (dofIndex = 0; dofIndex < this.getJoint().getDegreesOfFreedom(); ++dofIndex) {
                        MultiBodyResponseCalculator.this.jointMotionChangeMatrix.set(jointIndices[dofIndex], 0, this.qddPlus.get(dofIndex, 0));
                    }
                } else {
                    for (dofIndex = 0; dofIndex < this.getJoint().getDegreesOfFreedom(); ++dofIndex) {
                        MultiBodyResponseCalculator.this.jointMotionChangeMatrix.set(jointIndices[dofIndex], 0, 0.0);
                    }
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).propagateDownDisturbance();
            }
        }

        public void updateRigidBodyMotionChange() {
            if (this.isUpToDate || this.isRoot()) {
                return;
            }
            this.parent.updateRigidBodyMotionChange();
            this.stepDownDisturbance();
        }

        private void stepDownDisturbance() {
            if (this.isUpToDate) {
                return;
            }
            if (!this.isRoot()) {
                this.parentMotionChange.setIncludingFrame(this.parent.rigidBodyMotionChange);
                this.parentMotionChange.applyInverseTransform((RigidBodyTransformReadOnly)this.articulatedBodyRecursionStep.transformToParentJointFrame);
                this.parentMotionChange.setReferenceFrame(this.getFrameAfterJoint());
                this.parentMotionChange.get((DMatrix)this.aParentPlus);
                if (this.articulatedBodyRecursionStep.sourceMode == ForwardDynamicsCalculator.JointSourceMode.EFFORT_SOURCE) {
                    DMatrixRMaj S = this.articulatedBodyRecursionStep.S;
                    DMatrixRMaj U = this.articulatedBodyRecursionStep.U;
                    DMatrixRMaj Dinv = this.articulatedBodyRecursionStep.Dinv;
                    if (this.isOnDisturbedBranch) {
                        CommonOps_DDRM.multTransA((double)-1.0, (DMatrix1Row)U, (DMatrix1Row)this.aParentPlus, (DMatrix1Row)this.qddPlus_intermediate);
                        CommonOps_DDRM.addEquals((DMatrixD1)this.qddPlus_intermediate, (DMatrixD1)this.uPlus);
                        CommonOps_DDRM.mult((DMatrix1Row)Dinv, (DMatrix1Row)this.qddPlus_intermediate, (DMatrix1Row)this.qddPlus);
                    } else {
                        CommonOps_DDRM.multTransA((double)-1.0, (DMatrix1Row)U, (DMatrix1Row)this.aParentPlus, (DMatrix1Row)this.qddPlus_intermediate);
                        CommonOps_DDRM.mult((DMatrix1Row)Dinv, (DMatrix1Row)this.qddPlus_intermediate, (DMatrix1Row)this.qddPlus);
                    }
                    CommonOps_DDRM.mult((DMatrix1Row)S, (DMatrix1Row)this.qddPlus, (DMatrix1Row)this.aPlus);
                    CommonOps_DDRM.addEquals((DMatrixD1)this.aPlus, (DMatrixD1)this.aParentPlus);
                    this.rigidBodyMotionChange.setIncludingFrame(this.getBodyFixedFrame(), MultiBodyResponseCalculator.this.input.getInertialFrame(), this.getFrameAfterJoint(), (DMatrix)this.aPlus);
                } else {
                    this.rigidBodyMotionChange.setIncludingFrame(this.getBodyFixedFrame(), MultiBodyResponseCalculator.this.input.getInertialFrame(), this.getFrameAfterJoint(), (DMatrix)this.aParentPlus);
                }
            }
            this.isUpToDate = true;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public MovingReferenceFrame getBodyFixedFrame() {
            return this.articulatedBodyRecursionStep.getBodyFixedFrame();
        }

        public MovingReferenceFrame getFrameAfterJoint() {
            return this.getJoint().getFrameAfterJoint();
        }

        public JointReadOnly getJoint() {
            return this.articulatedBodyRecursionStep.getJoint();
        }

        public String toString() {
            return "RigidBody: " + this.articulatedBodyRecursionStep.rigidBody + ", parent: " + this.parent.articulatedBodyRecursionStep.rigidBody;
        }
    }
}

