/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public interface SpatialAccelerationBasics
extends FixedFrameSpatialAccelerationBasics,
SpatialMotionBasics {
    default public void changeFrame(ReferenceFrame desiredFrame, TwistReadOnly deltaTwist, TwistReadOnly bodyTwist) {
        if (this.getReferenceFrame() == desiredFrame) {
            return;
        }
        if (this.getReferenceFrame() == this.getBaseFrame() && desiredFrame == this.getBodyFrame()) {
            this.changeFrame(desiredFrame);
        } else if (this.getReferenceFrame() == this.getBodyFrame() && desiredFrame == this.getBaseFrame()) {
            this.changeFrame(desiredFrame);
        } else {
            boolean flipCrossProducts;
            bodyTwist.checkBodyFrameMatch(this.getBodyFrame());
            ReferenceFrameTools.checkEqualOrStationary((ReferenceFrame)this.getBaseFrame(), (ReferenceFrame)bodyTwist.getBaseFrame());
            if (deltaTwist.getBodyFrame() == this.getReferenceFrame()) {
                deltaTwist.checkBaseFrameMatch(desiredFrame);
                flipCrossProducts = false;
            } else {
                deltaTwist.checkBodyFrameMatch(desiredFrame);
                deltaTwist.checkBaseFrameMatch(this.getReferenceFrame());
                flipCrossProducts = true;
            }
            deltaTwist.checkExpressedInFrameMatch(bodyTwist.getReferenceFrame());
            if (deltaTwist.getReferenceFrame() == this.getReferenceFrame()) {
                if (flipCrossProducts) {
                    this.addCrossToLinearPart((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DReadOnly)deltaTwist.getLinearPart());
                    this.addCrossToLinearPart((Tuple3DReadOnly)bodyTwist.getLinearPart(), (Tuple3DReadOnly)deltaTwist.getAngularPart());
                    this.addCrossToAngularPart((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DReadOnly)deltaTwist.getAngularPart());
                } else {
                    this.addCrossToLinearPart((Tuple3DReadOnly)deltaTwist.getLinearPart(), (Tuple3DReadOnly)bodyTwist.getAngularPart());
                    this.addCrossToLinearPart((Tuple3DReadOnly)deltaTwist.getAngularPart(), (Tuple3DReadOnly)bodyTwist.getLinearPart());
                    this.addCrossToAngularPart((Tuple3DReadOnly)deltaTwist.getAngularPart(), (Tuple3DReadOnly)bodyTwist.getAngularPart());
                }
                this.changeFrame(desiredFrame);
            } else if (deltaTwist.getReferenceFrame() == desiredFrame) {
                this.changeFrame(desiredFrame);
                if (flipCrossProducts) {
                    this.addCrossToLinearPart((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DReadOnly)deltaTwist.getLinearPart());
                    this.addCrossToLinearPart((Tuple3DReadOnly)bodyTwist.getLinearPart(), (Tuple3DReadOnly)deltaTwist.getAngularPart());
                    this.addCrossToAngularPart((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DReadOnly)deltaTwist.getAngularPart());
                } else {
                    this.addCrossToLinearPart((Tuple3DReadOnly)deltaTwist.getLinearPart(), (Tuple3DReadOnly)bodyTwist.getAngularPart());
                    this.addCrossToLinearPart((Tuple3DReadOnly)deltaTwist.getAngularPart(), (Tuple3DReadOnly)bodyTwist.getLinearPart());
                    this.addCrossToAngularPart((Tuple3DReadOnly)deltaTwist.getAngularPart(), (Tuple3DReadOnly)bodyTwist.getAngularPart());
                }
            } else {
                throw new ReferenceFrameMismatchException("The given twists should be expressed in either: " + this.getReferenceFrame() + " or " + desiredFrame + " but were expressed in: " + deltaTwist.getReferenceFrame());
            }
        }
    }

    default public void setBasedOnOriginAccelerationIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, FrameVector3DReadOnly angularAcceleration, FrameVector3DReadOnly originAcceleration, TwistReadOnly bodyTwist) {
        this.setBodyFrame(bodyFrame);
        this.setBaseFrame(baseFrame);
        this.setReferenceFrame(bodyFrame);
        this.setBasedOnOriginAcceleration(angularAcceleration, originAcceleration, bodyTwist);
    }

    default public void add(SpatialAccelerationReadOnly other) {
        this.checkExpressedInFrameMatch(other.getReferenceFrame());
        if (this.getBodyFrame() == other.getBaseFrame()) {
            this.setBodyFrame(other.getBodyFrame());
        } else if (this.getBaseFrame() == other.getBodyFrame()) {
            this.setBaseFrame(other.getBaseFrame());
        } else {
            throw new ReferenceFrameMismatchException("This acceleration and other are incompatible for addition.");
        }
        this.getAngularPart().add((Tuple3DReadOnly)other.getAngularPart());
        this.getLinearPart().add((Tuple3DReadOnly)other.getLinearPart());
    }

    default public void sub(SpatialAccelerationReadOnly other) {
        this.checkExpressedInFrameMatch(other.getReferenceFrame());
        if (ReferenceFrameTools.areEqualOrStationary((ReferenceFrame)this.getBaseFrame(), (ReferenceFrame)other.getBaseFrame())) {
            this.setBaseFrame(other.getBodyFrame());
        } else if (this.getBodyFrame() == other.getBodyFrame()) {
            this.setBodyFrame(other.getBaseFrame());
        } else {
            throw new ReferenceFrameMismatchException("This acceleration and other are incompatible for difference.");
        }
        this.getAngularPart().sub((Tuple3DReadOnly)other.getAngularPart());
        this.getLinearPart().sub((Tuple3DReadOnly)other.getLinearPart());
    }
}

