/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;

public class RigidBody
implements RigidBodyBasics {
    private final SpatialInertia inertia;
    private final MovingReferenceFrame bodyFixedFrame;
    private final JointBasics parentJoint;
    private final List<JointBasics> parentLoopClosureJoints = new ArrayList<JointBasics>();
    private final List<JointBasics> childrenJoints = new ArrayList<JointBasics>();
    private final String name;
    private final String nameId;

    public RigidBody(String bodyName, ReferenceFrame parentStationaryFrame) {
        this(bodyName, (RigidBodyTransformReadOnly)new RigidBodyTransform(), parentStationaryFrame);
    }

    public RigidBody(String bodyName, RigidBodyTransformReadOnly transformToParent, ReferenceFrame parentStationaryFrame) {
        if (bodyName == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = bodyName;
        this.inertia = null;
        this.bodyFixedFrame = MovingReferenceFrame.constructFrameFixedInParent(bodyName + "Frame", parentStationaryFrame, transformToParent);
        this.parentJoint = null;
        this.nameId = bodyName;
    }

    public RigidBody(String bodyName, JointBasics parentJoint, double Ixx, double Iyy, double Izz, double mass, Tuple3DReadOnly centerOfMassOffset) {
        this(bodyName, parentJoint, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), centerOfMassOffset));
        this.inertia.setMomentOfInertia(Ixx, Iyy, Izz);
        this.inertia.setMass(mass);
    }

    public RigidBody(String bodyName, JointBasics parentJoint, Matrix3DReadOnly momentOfInertia, double mass, Tuple3DReadOnly centerOfMassOffset) {
        this(bodyName, parentJoint, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), centerOfMassOffset));
        this.inertia.getMomentOfInertia().set(momentOfInertia);
        this.inertia.setMass(mass);
    }

    public RigidBody(String bodyName, JointBasics parentJoint, Matrix3DReadOnly momentOfInertia, double mass, RigidBodyTransformReadOnly inertiaPose) {
        this(bodyName, parentJoint, inertiaPose);
        this.inertia.getMomentOfInertia().set(momentOfInertia);
        this.inertia.setMass(mass);
    }

    private RigidBody(String bodyName, JointBasics parentJoint, RigidBodyTransformReadOnly inertiaPose) {
        if (bodyName == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = bodyName;
        this.parentJoint = parentJoint;
        MovingReferenceFrame frameAfterJoint = parentJoint.getFrameAfterJoint();
        this.bodyFixedFrame = MovingReferenceFrame.constructFrameFixedInParent(bodyName + "CoM", frameAfterJoint, inertiaPose);
        this.inertia = new SpatialInertia(this.bodyFixedFrame, this.bodyFixedFrame);
        this.inertia.getBodyFrame().checkReferenceFrameMatch(this.inertia.getReferenceFrame());
        parentJoint.setSuccessor(this);
        this.nameId = parentJoint.getPredecessor().getNameId() + ":" + bodyName;
    }

    @Override
    public SpatialInertiaBasics getInertia() {
        return this.inertia;
    }

    @Override
    public MovingReferenceFrame getBodyFixedFrame() {
        return this.bodyFixedFrame;
    }

    @Override
    public JointBasics getParentJoint() {
        return this.parentJoint;
    }

    @Override
    public List<JointBasics> getParentLoopClosureJoints() {
        return this.parentLoopClosureJoints;
    }

    @Override
    public void addChildJoint(JointBasics joint) {
        this.childrenJoints.add(joint);
    }

    @Override
    public List<JointBasics> getChildrenJoints() {
        return this.childrenJoints;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameId() {
        return this.nameId;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.nameId.hashCode();
    }
}

