/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import java.util.Arrays;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.fourBar.FourBar;
import us.ihmc.mecano.fourBar.FourBarAngle;
import us.ihmc.mecano.fourBar.FourBarKinematicLoopFunctionTools;
import us.ihmc.mecano.fourBar.FourBarVertex;
import us.ihmc.mecano.multiBodySystem.interfaces.KinematicLoopFunction;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;

public class FourBarKinematicLoopFunction
implements KinematicLoopFunction {
    private static final double EPSILON = 1.0E-7;
    private final String name;
    private final FourBarVertex actuatedVertex;
    private final FourBar fourBar = new FourBar();
    private final RevoluteJointBasics jointA;
    private final RevoluteJointBasics jointB;
    private final RevoluteJointBasics jointC;
    private final RevoluteJointBasics jointD;
    private final List<RevoluteJointBasics> joints;
    private final FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterA = new FourBarKinematicLoopFunctionTools.FourBarToJointConverter();
    private final FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterB = new FourBarKinematicLoopFunctionTools.FourBarToJointConverter();
    private final FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterC = new FourBarKinematicLoopFunctionTools.FourBarToJointConverter();
    private final FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterD = new FourBarKinematicLoopFunctionTools.FourBarToJointConverter();
    private final FourBarKinematicLoopFunctionTools.FourBarToJointConverter[] converters = new FourBarKinematicLoopFunctionTools.FourBarToJointConverter[]{this.converterA, this.converterB, this.converterC, this.converterD};
    private final DMatrixRMaj loopJacobianMatrix = new DMatrixRMaj(4, 1);
    private final DMatrixRMaj loopConvectiveTermMatrix = new DMatrixRMaj(4, 1);
    private final int actuatedJointIndex;
    private final int[] actuatedJointIndices;

    public FourBarKinematicLoopFunction(String name, List<? extends RevoluteJointBasics> joints, int actuatedJointIndex) {
        this(name, joints.toArray(new RevoluteJointBasics[0]), actuatedJointIndex);
    }

    public FourBarKinematicLoopFunction(String name, RevoluteJointBasics[] joints, int actuatedJointIndex) {
        this.name = name;
        joints = Arrays.copyOf(joints, joints.length);
        this.actuatedJointIndex = FourBarKinematicLoopFunctionTools.configureFourBarKinematics(joints, this.converters, this.fourBar, actuatedJointIndex, 1.0E-7);
        this.actuatedJointIndices = new int[]{this.actuatedJointIndex};
        this.joints = Arrays.asList(joints);
        this.jointA = joints[0];
        this.jointB = joints[1];
        this.jointC = joints[2];
        this.jointD = joints[3];
        this.actuatedVertex = this.fourBar.getVertex(FourBarAngle.values[this.actuatedJointIndex]);
    }

    public boolean isCrossed() {
        return this.fourBar.isCrossed();
    }

    public Bound updateState(boolean updateVelocity, boolean updateAcceleration) {
        Bound limit;
        if (updateAcceleration && !updateVelocity) {
            throw new IllegalArgumentException("updateVelocity needs to be true for updateAcceleration to be true.");
        }
        this.clampActuatedJointPosition();
        RevoluteJointBasics actuatedJoint = this.getActuatedJoint();
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter actuatedConverter = this.converters[this.actuatedJointIndex];
        double angle = actuatedConverter.toFourBarInteriorAngle(actuatedJoint.getQ());
        if (updateVelocity) {
            double angleDot = actuatedConverter.toFourBarInteriorAngularDerivative(actuatedJoint.getQd());
            if (updateAcceleration) {
                double angleDDot = actuatedConverter.toFourBarInteriorAngularDerivative(actuatedJoint.getQdd());
                limit = this.fourBar.update(FourBarAngle.values[this.actuatedJointIndex], angle, angleDot, angleDDot);
            } else {
                limit = this.fourBar.update(FourBarAngle.values[this.actuatedJointIndex], angle, angleDot);
            }
        } else {
            limit = this.fourBar.update(FourBarAngle.values[this.actuatedJointIndex], angle);
        }
        for (int i = 0; i < 4; ++i) {
            if (i == this.actuatedJointIndex) continue;
            RevoluteJointBasics joint = this.joints.get(i);
            FourBarKinematicLoopFunctionTools.FourBarToJointConverter converter = this.converters[i];
            FourBarVertex fourBarVertex = this.fourBar.getVertex(FourBarAngle.values[i]);
            joint.setQ(converter.toJointAngle(fourBarVertex.getAngle()));
            if (updateVelocity) {
                joint.setQd(converter.toJointDerivative(fourBarVertex.getAngleDot()));
            }
            if (!updateAcceleration) continue;
            joint.setQdd(converter.toJointDerivative(fourBarVertex.getAngleDDot()));
        }
        this.updateLoopJacobian();
        this.updateLoopConvectiveTerm();
        return limit;
    }

    public void updateEffort() {
        double tau = 0.0;
        for (int i = 0; i < 4; ++i) {
            RevoluteJointBasics joint = this.joints.get(i);
            tau += this.loopJacobianMatrix.get(i, 0) * joint.getTau();
            joint.setTau(0.0);
        }
        this.getActuatedJoint().setTau(tau / this.loopJacobianMatrix.get(this.actuatedJointIndex, 0));
    }

    @Override
    public void adjustConfiguration(DMatrixRMaj jointConfigurations) {
        if (jointConfigurations.getNumRows() != 4 || jointConfigurations.getNumCols() != 1) {
            throw new IllegalArgumentException("Unexpected matrix size. [row=" + jointConfigurations.getNumRows() + ", col=" + jointConfigurations.getNumCols() + "].");
        }
        double angle = EuclidCoreTools.clamp((double)jointConfigurations.get(this.actuatedJointIndex), (double)this.getActuatedJoint().getJointLimitLower(), (double)this.getActuatedJoint().getJointLimitUpper());
        this.fourBar.update(FourBarAngle.values[this.actuatedJointIndex], this.converters[this.actuatedJointIndex].toFourBarInteriorAngle(angle));
        for (int i = 0; i < 4; ++i) {
            double q = this.converters[i].toJointAngle(this.fourBar.getVertex(FourBarAngle.values[i]).getAngle());
            jointConfigurations.set(i, q);
        }
    }

    @Override
    public void adjustTau(DMatrixRMaj tauJoints) {
        if (tauJoints.getNumRows() != 4 || tauJoints.getNumCols() != 1) {
            throw new IllegalArgumentException("Unexpected matrix size. [row=" + tauJoints.getNumRows() + ", col=" + tauJoints.getNumCols() + "].");
        }
        double tau = 0.0;
        for (int i = 0; i < 4; ++i) {
            tau += this.loopJacobianMatrix.get(i, 0) * tauJoints.get(i);
            tauJoints.set(i, 0.0);
        }
        tauJoints.set(this.actuatedJointIndex, tau / this.loopJacobianMatrix.get(this.actuatedJointIndex, 0));
    }

    private void updateLoopJacobian() {
        double angle = this.converters[this.actuatedJointIndex].toFourBarInteriorAngle(this.getActuatedJoint().getQ());
        double angleDot = this.converters[this.actuatedJointIndex].toFourBarInteriorAngularDerivative(1.0);
        this.fourBar.update(FourBarAngle.values[this.actuatedJointIndex], angle, angleDot);
        for (int i = 0; i < 4; ++i) {
            if (i == this.actuatedJointIndex) {
                this.loopJacobianMatrix.set(i, 0, 1.0);
                continue;
            }
            FourBarVertex fourBarVertex = this.fourBar.getVertex(FourBarAngle.values[i]);
            this.loopJacobianMatrix.set(i, 0, this.converters[i].toJointDerivative(fourBarVertex.getAngleDot()));
        }
    }

    private void updateLoopConvectiveTerm() {
        double angle = this.converters[this.actuatedJointIndex].toFourBarInteriorAngle(this.getActuatedJoint().getQ());
        double angleDot = this.converters[this.actuatedJointIndex].toFourBarInteriorAngularDerivative(this.getActuatedJoint().getQd());
        double angleDDot = 0.0;
        this.fourBar.update(FourBarAngle.values[this.actuatedJointIndex], angle, angleDot, angleDDot);
        for (int i = 0; i < 4; ++i) {
            if (i == this.actuatedJointIndex) {
                this.loopConvectiveTermMatrix.set(i, 0, 0.0);
                continue;
            }
            FourBarVertex fourBarVertex = this.fourBar.getVertex(FourBarAngle.values[i]);
            this.loopConvectiveTermMatrix.set(i, 0, this.converters[i].toJointDerivative(fourBarVertex.getAngleDDot()));
        }
    }

    public List<RevoluteJointBasics> getLoopJoints() {
        return this.joints;
    }

    private void clampActuatedJointPosition() {
        RevoluteJointBasics actuatedJoint = this.getActuatedJoint();
        if (actuatedJoint.getQ() < actuatedJoint.getJointLimitLower()) {
            actuatedJoint.setQ(actuatedJoint.getJointLimitLower());
        } else if (actuatedJoint.getQ() > actuatedJoint.getJointLimitUpper()) {
            actuatedJoint.setQ(actuatedJoint.getJointLimitUpper());
        }
    }

    public String getName() {
        return this.name;
    }

    public RevoluteJointBasics getJointA() {
        return this.jointA;
    }

    public RevoluteJointBasics getJointB() {
        return this.jointB;
    }

    public RevoluteJointBasics getJointC() {
        return this.jointC;
    }

    public RevoluteJointBasics getJointD() {
        return this.jointD;
    }

    public int getActuatedJointIndex() {
        return this.actuatedJointIndex;
    }

    public FourBarVertex getActuatedVertex() {
        return this.actuatedVertex;
    }

    @Override
    public int[] getActuatedJointIndices() {
        return this.actuatedJointIndices;
    }

    public RevoluteJointBasics getActuatedJoint() {
        return this.joints.get(this.actuatedJointIndex);
    }

    @Override
    public DMatrixRMaj getLoopJacobian() {
        return this.loopJacobianMatrix;
    }

    @Override
    public DMatrixRMaj getLoopConvectiveTerm() {
        return this.loopConvectiveTermMatrix;
    }

    public FourBar getFourBar() {
        return this.fourBar;
    }

    public FourBarKinematicLoopFunctionTools.FourBarToJointConverter[] getConverters() {
        return this.converters;
    }
}

