/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;

public class Wrench
implements WrenchBasics,
Settable<Wrench> {
    private ReferenceFrame bodyFrame;
    private final SpatialForce spatialForceVector = new SpatialForce();

    public Wrench() {
        this.setToZero(null, null);
    }

    public Wrench(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        this.setToZero(bodyFrame, expressedInFrame);
    }

    public Wrench(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.setIncludingFrame(bodyFrame, expressedInFrame, angularPart, linearPart);
    }

    public Wrench(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, DMatrix matrix) {
        this.setIncludingFrame(bodyFrame, expressedInFrame, matrix);
    }

    public Wrench(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, double[] array) {
        this.setIncludingFrame(bodyFrame, expressedInFrame, array);
    }

    public Wrench(ReferenceFrame bodyFrame, SpatialVectorReadOnly spatialVector) {
        this.setIncludingFrame(bodyFrame, spatialVector);
    }

    public Wrench(WrenchReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(Wrench other) {
        WrenchBasics.super.set(other);
    }

    @Override
    public void setBodyFrame(ReferenceFrame bodyFrame) {
        this.bodyFrame = bodyFrame;
    }

    @Override
    public void setReferenceFrame(ReferenceFrame expressedInFrame) {
        this.spatialForceVector.setReferenceFrame(expressedInFrame);
    }

    @Override
    public ReferenceFrame getBodyFrame() {
        return this.bodyFrame;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.spatialForceVector.getReferenceFrame();
    }

    @Override
    public FixedFrameVector3DBasics getAngularPart() {
        return this.spatialForceVector.getAngularPart();
    }

    @Override
    public FixedFrameVector3DBasics getLinearPart() {
        return this.spatialForceVector.getLinearPart();
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        this.spatialForceVector.changeFrame(desiredFrame);
    }

    @Override
    public void applyTransform(Transform transform) {
        this.spatialForceVector.applyTransform(transform);
    }

    @Override
    public void applyInverseTransform(Transform transform) {
        this.spatialForceVector.applyInverseTransform(transform);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof WrenchReadOnly) {
            return WrenchBasics.super.equals((WrenchReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return MecanoIOTools.getWrenchString(this);
    }
}

