/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.tools.MecanoTools;

class FactorizedBodyInertia
implements Settable<FactorizedBodyInertia>,
ReferenceFrameHolder,
FrameChangeable,
Clearable {
    private ReferenceFrame referenceFrame = null;
    private final Matrix3D angularInertia = new Matrix3D();
    private final Matrix3D linearInertia = new Matrix3D();
    private final Matrix3D topRightInertia = new Matrix3D();
    private final Matrix3D bottomLeftInertia = new Matrix3D();
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public FactorizedBodyInertia() {
    }

    public FactorizedBodyInertia(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public boolean containsNaN() {
        return this.angularInertia.containsNaN() || this.linearInertia.containsNaN() || this.topRightInertia.containsNaN() || this.bottomLeftInertia.containsNaN();
    }

    public void setToNaN() {
        this.angularInertia.setToNaN();
        this.linearInertia.setToNaN();
        this.topRightInertia.setToNaN();
        this.bottomLeftInertia.setToNaN();
    }

    public void setToNaN(ReferenceFrame referenceFrame) {
        this.setReferenceFrame(referenceFrame);
        this.setToNaN();
    }

    public void setToZero() {
        this.angularInertia.setToZero();
        this.linearInertia.setToZero();
        this.topRightInertia.setToZero();
        this.bottomLeftInertia.setToZero();
    }

    public void setToZero(ReferenceFrame referenceFrame) {
        this.setReferenceFrame(referenceFrame);
        this.setToZero();
    }

    public void set(FactorizedBodyInertia other) {
        this.checkReferenceFrameMatch(other);
        this.angularInertia.set(other.angularInertia);
        this.linearInertia.set(other.linearInertia);
        this.topRightInertia.set(other.topRightInertia);
        this.bottomLeftInertia.set(other.bottomLeftInertia);
    }

    public void setIncludingFrame(FactorizedBodyInertia other) {
        this.setReferenceFrame(other.referenceFrame);
        this.angularInertia.set(other.angularInertia);
        this.linearInertia.set(other.linearInertia);
        this.topRightInertia.set(other.topRightInertia);
        this.bottomLeftInertia.set(other.bottomLeftInertia);
    }

    public void setIncludingFrame(SpatialInertiaReadOnly spatialInertia, TwistReadOnly bodyTwist) {
        spatialInertia.checkBodyFrameMatch(bodyTwist.getBodyFrame());
        spatialInertia.checkReferenceFrameMatch(bodyTwist.getReferenceFrame());
        this.setReferenceFrame(spatialInertia.getReferenceFrame());
        FactorizedBodyInertia.tildeTimesTilde((Tuple3DReadOnly)bodyTwist.getLinearPart(), (Tuple3DReadOnly)spatialInertia.getCenterOfMassOffset(), (Matrix3DBasics)this.angularInertia);
        this.angularInertia.scale(-spatialInertia.getMass());
        FactorizedBodyInertia.addTildeTimesMatrix((Tuple3DReadOnly)bodyTwist.getAngularPart(), spatialInertia.getMomentOfInertia(), (Matrix3DBasics)this.angularInertia);
        FactorizedBodyInertia.tildeTimesTilde((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DReadOnly)spatialInertia.getCenterOfMassOffset(), (Matrix3DBasics)this.bottomLeftInertia);
        this.bottomLeftInertia.scale(-spatialInertia.getMass());
        this.topRightInertia.setToTildeForm((Tuple3DReadOnly)bodyTwist.getLinearPart());
        this.topRightInertia.scale(spatialInertia.getMass());
        this.topRightInertia.sub((Matrix3DReadOnly)this.bottomLeftInertia);
        this.linearInertia.setToTildeForm((Tuple3DReadOnly)bodyTwist.getAngularPart());
        this.linearInertia.scale(spatialInertia.getMass());
    }

    public void add(FactorizedBodyInertia other) {
        this.checkReferenceFrameMatch(other);
        this.angularInertia.add((Matrix3DReadOnly)other.angularInertia);
        this.linearInertia.add((Matrix3DReadOnly)other.linearInertia);
        this.topRightInertia.add((Matrix3DReadOnly)other.topRightInertia);
        this.bottomLeftInertia.add((Matrix3DReadOnly)other.bottomLeftInertia);
    }

    public void add(DMatrix matrix) {
        MecanoTools.addEquals(0, 0, matrix, (Matrix3DBasics)this.angularInertia);
        MecanoTools.addEquals(3, 3, matrix, (Matrix3DBasics)this.linearInertia);
        MecanoTools.addEquals(0, 3, matrix, (Matrix3DBasics)this.topRightInertia);
        MecanoTools.addEquals(3, 0, matrix, (Matrix3DBasics)this.bottomLeftInertia);
    }

    public void sub(FactorizedBodyInertia other) {
        this.checkReferenceFrameMatch(other);
        this.angularInertia.sub((Matrix3DReadOnly)other.angularInertia);
        this.linearInertia.sub((Matrix3DReadOnly)other.linearInertia);
        this.topRightInertia.sub((Matrix3DReadOnly)other.topRightInertia);
        this.bottomLeftInertia.sub((Matrix3DReadOnly)other.bottomLeftInertia);
    }

    public void sub(DMatrix matrix) {
        MecanoTools.subEquals(0, 0, matrix, (Matrix3DBasics)this.angularInertia);
        MecanoTools.subEquals(3, 3, matrix, (Matrix3DBasics)this.linearInertia);
        MecanoTools.subEquals(0, 3, matrix, (Matrix3DBasics)this.topRightInertia);
        MecanoTools.subEquals(3, 0, matrix, (Matrix3DBasics)this.bottomLeftInertia);
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.getReferenceFrame()) {
            return;
        }
        this.getReferenceFrame().getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform(this.transformToDesiredFrame);
        this.setReferenceFrame(desiredFrame);
    }

    public void transform(SpatialVectorReadOnly vectorOriginal, SpatialVectorBasics vectorTransformed) {
        if (vectorOriginal == vectorTransformed) {
            throw new UnsupportedOperationException("In-place transformation is not supported.");
        }
        this.checkReferenceFrameMatch(vectorOriginal);
        vectorTransformed.setReferenceFrame(this.referenceFrame);
        this.angularInertia.transform((Tuple3DReadOnly)vectorOriginal.getAngularPart(), (Tuple3DBasics)vectorTransformed.getAngularPart());
        this.topRightInertia.addTransform((Tuple3DReadOnly)vectorOriginal.getLinearPart(), (Tuple3DBasics)vectorTransformed.getAngularPart());
        this.bottomLeftInertia.transform((Tuple3DReadOnly)vectorOriginal.getAngularPart(), (Tuple3DBasics)vectorTransformed.getLinearPart());
        this.linearInertia.addTransform((Tuple3DReadOnly)vectorOriginal.getLinearPart(), (Tuple3DBasics)vectorTransformed.getLinearPart());
    }

    public void addTransform(SpatialVectorReadOnly vectorOriginal, SpatialVectorBasics vectorTransformed) {
        if (vectorOriginal == vectorTransformed) {
            throw new UnsupportedOperationException("In-place transformation is not supported.");
        }
        this.checkReferenceFrameMatch(vectorOriginal);
        this.checkReferenceFrameMatch(vectorTransformed);
        this.angularInertia.addTransform((Tuple3DReadOnly)vectorOriginal.getAngularPart(), (Tuple3DBasics)vectorTransformed.getAngularPart());
        this.topRightInertia.addTransform((Tuple3DReadOnly)vectorOriginal.getLinearPart(), (Tuple3DBasics)vectorTransformed.getAngularPart());
        this.bottomLeftInertia.addTransform((Tuple3DReadOnly)vectorOriginal.getAngularPart(), (Tuple3DBasics)vectorTransformed.getLinearPart());
        this.linearInertia.addTransform((Tuple3DReadOnly)vectorOriginal.getLinearPart(), (Tuple3DBasics)vectorTransformed.getLinearPart());
    }

    public void transposeTransform(SpatialVectorReadOnly vectorOriginal, SpatialVectorBasics vectorTransformed) {
        if (vectorOriginal == vectorTransformed) {
            throw new UnsupportedOperationException("In-place transformation is not supported.");
        }
        this.checkReferenceFrameMatch(vectorOriginal);
        vectorTransformed.setReferenceFrame(this.referenceFrame);
        FactorizedBodyInertia.transposeTransform((Matrix3DReadOnly)this.angularInertia, (Tuple3DReadOnly)vectorOriginal.getAngularPart(), (Tuple3DBasics)vectorTransformed.getAngularPart());
        FactorizedBodyInertia.addTransposeTransform((Matrix3DReadOnly)this.bottomLeftInertia, (Tuple3DReadOnly)vectorOriginal.getLinearPart(), (Tuple3DBasics)vectorTransformed.getAngularPart());
        FactorizedBodyInertia.transposeTransform((Matrix3DReadOnly)this.topRightInertia, (Tuple3DReadOnly)vectorOriginal.getAngularPart(), (Tuple3DBasics)vectorTransformed.getLinearPart());
        FactorizedBodyInertia.addTransposeTransform((Matrix3DReadOnly)this.linearInertia, (Tuple3DReadOnly)vectorOriginal.getLinearPart(), (Tuple3DBasics)vectorTransformed.getLinearPart());
    }

    static void transposeTransform(Matrix3DReadOnly matrix, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double x = matrix.getM00() * tupleOriginal.getX() + matrix.getM10() * tupleOriginal.getY() + matrix.getM20() * tupleOriginal.getZ();
        double y = matrix.getM01() * tupleOriginal.getX() + matrix.getM11() * tupleOriginal.getY() + matrix.getM21() * tupleOriginal.getZ();
        double z = matrix.getM02() * tupleOriginal.getX() + matrix.getM12() * tupleOriginal.getY() + matrix.getM22() * tupleOriginal.getZ();
        tupleTransformed.set(x, y, z);
    }

    static void addTransposeTransform(Matrix3DReadOnly matrix, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double x = matrix.getM00() * tupleOriginal.getX() + matrix.getM10() * tupleOriginal.getY() + matrix.getM20() * tupleOriginal.getZ();
        double y = matrix.getM01() * tupleOriginal.getX() + matrix.getM11() * tupleOriginal.getY() + matrix.getM21() * tupleOriginal.getZ();
        double z = matrix.getM02() * tupleOriginal.getX() + matrix.getM12() * tupleOriginal.getY() + matrix.getM22() * tupleOriginal.getZ();
        tupleTransformed.add(x, y, z);
    }

    public Matrix3D getAngularInertia() {
        return this.angularInertia;
    }

    public Matrix3D getLinearInertia() {
        return this.linearInertia;
    }

    public Matrix3D getTopRightInertia() {
        return this.topRightInertia;
    }

    public Matrix3D getBottomLeftInertia() {
        return this.bottomLeftInertia;
    }

    public void get(DMatrix matrixToPack) {
        this.angularInertia.get(0, 0, matrixToPack);
        this.linearInertia.get(3, 3, matrixToPack);
        this.topRightInertia.get(0, 3, matrixToPack);
        this.bottomLeftInertia.get(3, 0, matrixToPack);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public void applyTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransform)) {
            throw new UnsupportedOperationException("The feature applyTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyTransform((RigidBodyTransform)transform);
    }

    public void applyInverseTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransform)) {
            throw new UnsupportedOperationException("The feature applyInverseTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyInverseTransform((RigidBodyTransform)transform);
    }

    public void applyTransform(RigidBodyTransform transform) {
        if (transform.hasRotation()) {
            transform.getRotation().transform((Matrix3DBasics)this.angularInertia);
            transform.getRotation().transform((Matrix3DBasics)this.linearInertia);
            transform.getRotation().transform((Matrix3DBasics)this.topRightInertia);
            transform.getRotation().transform((Matrix3DBasics)this.bottomLeftInertia);
        }
        if (transform.hasTranslation()) {
            FactorizedBodyInertia.addTildeTimesMatrix((Tuple3DReadOnly)transform.getTranslation(), (Matrix3DReadOnly)this.linearInertia, (Matrix3DBasics)this.topRightInertia);
            FactorizedBodyInertia.addTildeTimesMatrix((Tuple3DReadOnly)transform.getTranslation(), (Matrix3DReadOnly)this.bottomLeftInertia, (Matrix3DBasics)this.angularInertia);
            FactorizedBodyInertia.subMatrixTimesTilde((Matrix3DReadOnly)this.topRightInertia, (Tuple3DReadOnly)transform.getTranslation(), (Matrix3DBasics)this.angularInertia);
            FactorizedBodyInertia.subMatrixTimesTilde((Matrix3DReadOnly)this.linearInertia, (Tuple3DReadOnly)transform.getTranslation(), (Matrix3DBasics)this.bottomLeftInertia);
        }
    }

    public void applyInverseTransform(RigidBodyTransform transform) {
        this.transformToDesiredFrame.setAndInvert((RigidBodyTransformReadOnly)transform);
        this.applyTransform(this.transformToDesiredFrame);
    }

    static void addTildeTimesMatrix(Tuple3DReadOnly p, Matrix3DReadOnly m, Matrix3DBasics resultToPack) {
        double c00 = -p.getZ() * m.getM10() + p.getY() * m.getM20();
        double c01 = -p.getZ() * m.getM11() + p.getY() * m.getM21();
        double c02 = -p.getZ() * m.getM12() + p.getY() * m.getM22();
        double c10 = p.getZ() * m.getM00() - p.getX() * m.getM20();
        double c11 = p.getZ() * m.getM01() - p.getX() * m.getM21();
        double c12 = p.getZ() * m.getM02() - p.getX() * m.getM22();
        double c20 = -p.getY() * m.getM00() + p.getX() * m.getM10();
        double c21 = -p.getY() * m.getM01() + p.getX() * m.getM11();
        double c22 = -p.getY() * m.getM02() + p.getX() * m.getM12();
        resultToPack.addM00(c00);
        resultToPack.addM01(c01);
        resultToPack.addM02(c02);
        resultToPack.addM10(c10);
        resultToPack.addM11(c11);
        resultToPack.addM12(c12);
        resultToPack.addM20(c20);
        resultToPack.addM21(c21);
        resultToPack.addM22(c22);
    }

    static void subMatrixTimesTilde(Matrix3DReadOnly m, Tuple3DReadOnly p, Matrix3DBasics resultToPack) {
        double c00 = m.getM01() * p.getZ() - m.getM02() * p.getY();
        double c01 = m.getM02() * p.getX() - m.getM00() * p.getZ();
        double c02 = m.getM00() * p.getY() - m.getM01() * p.getX();
        double c10 = m.getM11() * p.getZ() - m.getM12() * p.getY();
        double c11 = m.getM12() * p.getX() - m.getM10() * p.getZ();
        double c12 = m.getM10() * p.getY() - m.getM11() * p.getX();
        double c20 = m.getM21() * p.getZ() - m.getM22() * p.getY();
        double c21 = m.getM22() * p.getX() - m.getM20() * p.getZ();
        double c22 = m.getM20() * p.getY() - m.getM21() * p.getX();
        resultToPack.subM00(c00);
        resultToPack.subM01(c01);
        resultToPack.subM02(c02);
        resultToPack.subM10(c10);
        resultToPack.subM11(c11);
        resultToPack.subM12(c12);
        resultToPack.subM20(c20);
        resultToPack.subM21(c21);
        resultToPack.subM22(c22);
    }

    static void tildeTimesTilde(Tuple3DReadOnly p1, Tuple3DReadOnly p2, Matrix3DBasics resultToPack) {
        double c00 = -p1.getZ() * p2.getZ() - p1.getY() * p2.getY();
        double c01 = p1.getY() * p2.getX();
        double c02 = p1.getZ() * p2.getX();
        double c10 = p1.getX() * p2.getY();
        double c11 = -p1.getZ() * p2.getZ() - p1.getX() * p2.getX();
        double c12 = p1.getZ() * p2.getY();
        double c20 = p1.getX() * p2.getZ();
        double c21 = p1.getY() * p2.getZ();
        double c22 = -p1.getY() * p2.getY() - p1.getX() * p2.getX();
        resultToPack.set(c00, c01, c02, c10, c11, c12, c20, c21, c22);
    }

    public boolean epsilonEquals(FactorizedBodyInertia other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        if (!this.getAngularInertia().epsilonEquals((EuclidGeometry)other.getAngularInertia(), epsilon)) {
            return false;
        }
        if (!this.getLinearInertia().epsilonEquals((EuclidGeometry)other.getLinearInertia(), epsilon)) {
            return false;
        }
        if (!this.getTopRightInertia().epsilonEquals((EuclidGeometry)other.getTopRightInertia(), epsilon)) {
            return false;
        }
        return this.getBottomLeftInertia().epsilonEquals((EuclidGeometry)other.getBottomLeftInertia(), epsilon);
    }

    public boolean geometricallyEquals(FactorizedBodyInertia other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return this.epsilonEquals(other, epsilon);
    }

    public String toString() {
        DMatrixRMaj matrix = new DMatrixRMaj(6, 6);
        this.get((DMatrix)matrix);
        return "Articulated-body inertia expressed in " + this.referenceFrame + "\n" + MecanoIOTools.getDMatrixString((DMatrix)matrix);
    }
}

