/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialInertiaBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.MecanoTools;

public interface SpatialInertiaBasics
extends FixedFrameSpatialInertiaBasics,
FrameChangeable {
    public void setBodyFrame(ReferenceFrame var1);

    default public void setToZero(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        this.setBodyFrame(bodyFrame);
        this.setReferenceFrame(expressedInFrame);
        this.setToZero();
    }

    default public void setToNaN(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        this.setBodyFrame(bodyFrame);
        this.setReferenceFrame(expressedInFrame);
        this.setToNaN();
    }

    default public void setIncludingFrame(SpatialInertiaReadOnly other) {
        this.setBodyFrame(other.getBodyFrame());
        this.setReferenceFrame(other.getReferenceFrame());
        this.getMomentOfInertia().set(other.getMomentOfInertia());
        this.setMass(other.getMass());
        this.getCenterOfMassOffset().set((FrameTuple3DReadOnly)other.getCenterOfMassOffset());
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, double Ixx, double Iyy, double Izz, double mass) {
        this.setBodyFrame(bodyFrame);
        this.setReferenceFrame(expressedInFrame);
        this.setMomentOfInertia(Ixx, Iyy, Izz);
        this.setMass(mass);
        this.getCenterOfMassOffset().setToZero();
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, Matrix3DReadOnly momentOfInertia, double mass) {
        this.setBodyFrame(bodyFrame);
        this.setReferenceFrame(expressedInFrame);
        this.getMomentOfInertia().set(momentOfInertia);
        this.setMass(mass);
        this.getCenterOfMassOffset().setToZero();
    }

    default public void setIncludingFrame(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, Matrix3DReadOnly momentOfInertia, double mass, Tuple3DReadOnly centerOfMassOffset) {
        this.setBodyFrame(bodyFrame);
        this.setReferenceFrame(expressedInFrame);
        this.getMomentOfInertia().set(momentOfInertia);
        this.setMass(mass);
        this.getCenterOfMassOffset().set(centerOfMassOffset);
    }

    default public void applyTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransform)) {
            throw new UnsupportedOperationException("The feature applyTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyTransform((RigidBodyTransformReadOnly)((RigidBodyTransform)transform));
    }

    default public void applyInverseTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransform)) {
            throw new UnsupportedOperationException("The feature applyInverseTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyInverseTransform((RigidBodyTransformReadOnly)((RigidBodyTransform)transform));
    }

    default public void applyTransform(RigidBodyTransformReadOnly transform) {
        if (transform.hasRotation()) {
            Orientation3DReadOnly orientation3DReadOnly = transform.getRotation();
            if (orientation3DReadOnly instanceof RotationMatrixReadOnly) {
                RotationMatrixReadOnly rotationMatrix = (RotationMatrixReadOnly)orientation3DReadOnly;
                MecanoTools.transformSymmetricMatrix3D(rotationMatrix, this.getMomentOfInertia());
            } else {
                transform.getRotation().transform(this.getMomentOfInertia());
            }
            this.getCenterOfMassOffset().applyTransform((Transform)transform);
        }
        if (transform.hasTranslation()) {
            MecanoTools.translateMomentOfInertia(this.getMass(), (Tuple3DReadOnly)this.getCenterOfMassOffset(), false, transform.getTranslation(), this.getMomentOfInertia());
            this.getCenterOfMassOffset().add(transform.getTranslation());
        }
    }

    default public void applyInverseTransform(RigidBodyTransformReadOnly transform) {
        if (transform.hasTranslation()) {
            MecanoTools.translateMomentOfInertia(this.getMass(), (Tuple3DReadOnly)this.getCenterOfMassOffset(), true, transform.getTranslation(), this.getMomentOfInertia());
            this.getCenterOfMassOffset().sub(transform.getTranslation());
        }
        if (transform.hasRotation()) {
            Orientation3DReadOnly orientation3DReadOnly = transform.getRotation();
            if (orientation3DReadOnly instanceof RotationMatrixReadOnly) {
                RotationMatrixReadOnly rotationMatrix = (RotationMatrixReadOnly)orientation3DReadOnly;
                MecanoTools.inverseTransformSymmetricMatrix3D(rotationMatrix, this.getMomentOfInertia());
            } else {
                transform.getRotation().inverseTransform(this.getMomentOfInertia());
            }
            this.getCenterOfMassOffset().applyInverseTransform((Transform)transform);
        }
    }
}

