/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterable;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;

public interface JointBasics
extends JointReadOnly {
    @Override
    public RigidBodyBasics getPredecessor();

    @Override
    public RigidBodyBasics getSuccessor();

    public void setSuccessor(RigidBodyBasics var1);

    public void setupLoopClosure(RigidBodyBasics var1, RigidBodyTransformReadOnly var2);

    public void setJointConfigurationToZero();

    public void setJointTwistToZero();

    public void setJointAccelerationToZero();

    public void setJointTauToZero();

    public void setJointConfiguration(JointReadOnly var1);

    public void setJointTwist(JointReadOnly var1);

    public void setJointAcceleration(JointReadOnly var1);

    public void setJointWrench(JointReadOnly var1);

    public int setJointConfiguration(int var1, DMatrix var2);

    public int setJointVelocity(int var1, DMatrix var2);

    public int setJointAcceleration(int var1, DMatrix var2);

    public int setJointTau(int var1, DMatrix var2);

    default public void setJointConfiguration(RigidBodyTransformReadOnly jointConfiguration) {
        this.setJointOrientation(jointConfiguration.getRotation());
        this.setJointPosition(jointConfiguration.getTranslation());
    }

    default public void setJointConfiguration(Pose3DReadOnly jointConfiguration) {
        this.setJointOrientation((Orientation3DReadOnly)jointConfiguration.getOrientation());
        this.setJointPosition((Tuple3DReadOnly)jointConfiguration.getPosition());
    }

    default public void setJointConfiguration(Orientation3DReadOnly jointOrientation, Tuple3DReadOnly jointPosition) {
        this.setJointOrientation(jointOrientation);
        this.setJointPosition(jointPosition);
    }

    public void setJointOrientation(Orientation3DReadOnly var1);

    public void setJointPosition(Tuple3DReadOnly var1);

    default public void setJointTwist(TwistReadOnly jointTwist) {
        jointTwist.checkBodyFrameMatch(this.getFrameAfterJoint());
        jointTwist.checkBaseFrameMatch(this.getFrameBeforeJoint());
        jointTwist.checkExpressedInFrameMatch(this.getFrameAfterJoint());
        this.setJointAngularVelocity((Vector3DReadOnly)jointTwist.getAngularPart());
        this.setJointLinearVelocity((Vector3DReadOnly)jointTwist.getLinearPart());
    }

    default public void setJointAngularVelocity(FrameVector3DReadOnly jointAngularVelocity) {
        jointAngularVelocity.checkReferenceFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointAngularVelocity((Vector3DReadOnly)jointAngularVelocity);
    }

    default public void setJointLinearVelocity(FrameVector3DReadOnly jointLinearVelocity) {
        jointLinearVelocity.checkReferenceFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointLinearVelocity((Vector3DReadOnly)jointLinearVelocity);
    }

    public void setJointAngularVelocity(Vector3DReadOnly var1);

    public void setJointLinearVelocity(Vector3DReadOnly var1);

    default public void setJointAcceleration(SpatialAccelerationReadOnly jointAcceleration) {
        jointAcceleration.checkBodyFrameMatch(this.getFrameAfterJoint());
        jointAcceleration.checkBaseFrameMatch(this.getFrameBeforeJoint());
        jointAcceleration.checkExpressedInFrameMatch(this.getFrameAfterJoint());
        this.setJointAngularAcceleration((Vector3DReadOnly)jointAcceleration.getAngularPart());
        this.setJointLinearAcceleration((Vector3DReadOnly)jointAcceleration.getLinearPart());
    }

    default public void setJointAngularAcceleration(FrameVector3DReadOnly jointAngularAcceleration) {
        jointAngularAcceleration.checkReferenceFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointAngularAcceleration((Vector3DReadOnly)jointAngularAcceleration);
    }

    default public void setJointLinearAcceleration(FrameVector3DReadOnly jointLinearAcceleration) {
        jointLinearAcceleration.checkReferenceFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointLinearAcceleration((Vector3DReadOnly)jointLinearAcceleration);
    }

    public void setJointAngularAcceleration(Vector3DReadOnly var1);

    public void setJointLinearAcceleration(Vector3DReadOnly var1);

    default public void setJointWrench(WrenchReadOnly jointWrench) {
        jointWrench.checkBodyFrameMatch(this.getSuccessor().getBodyFixedFrame());
        jointWrench.checkExpressedInFrameMatch(this.getFrameAfterJoint());
        this.setJointTorque((Vector3DReadOnly)jointWrench.getAngularPart());
        this.setJointForce((Vector3DReadOnly)jointWrench.getLinearPart());
    }

    default public void setJointTorque(FrameVector3DReadOnly jointTorque) {
        jointTorque.checkReferenceFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointTorque((Vector3DReadOnly)jointTorque);
    }

    default public void setJointForce(FrameVector3DReadOnly jointForce) {
        jointForce.checkReferenceFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointForce((Vector3DReadOnly)jointForce);
    }

    public void setJointTorque(Vector3DReadOnly var1);

    public void setJointForce(Vector3DReadOnly var1);

    default public void updateMotionSubspace() {
    }

    default public Iterable<? extends JointBasics> subtreeIterable() {
        return new JointIterable<JointBasics>(JointBasics.class, null, this);
    }

    default public Stream<? extends JointBasics> subtreeStream() {
        return SubtreeStreams.from(this);
    }

    default public List<? extends JointBasics> subtreeList() {
        return this.subtreeStream().collect(Collectors.toList());
    }

    default public JointBasics[] subtreeArray() {
        return (JointBasics[])this.subtreeStream().toArray(JointBasics[]::new);
    }

    default public void updateFrame() {
        this.getFrameBeforeJoint().update();
        this.getFrameAfterJoint().update();
    }

    default public void updateFramesRecursively() {
        this.updateFrame();
        if (this.getSuccessor() != null) {
            this.getSuccessor().updateFramesRecursively();
        }
    }
}

