/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.FixedFrameMomentumBasics;
import us.ihmc.mecano.spatial.interfaces.MomentumBasics;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class CentroidalMomentumCalculator
implements ReferenceFrameHolder {
    private final MultiBodySystemReadOnly input;
    private final ReferenceFrame matrixFrame;
    private final IterativeStep[] iterativeSteps;
    private final Twist jointUnitTwist;
    private final Twist intermediateUnitTwist;
    private final Momentum unitMomentum;
    private final Momentum intermediateMomentum;
    private final FixedFrameMomentumBasics momentum;
    private final FixedFrameVector3DBasics centerOfMassVelocity;
    private final DMatrixRMaj centroidalMomentumMatrix;
    private final DMatrixRMaj jointVelocityMatrix;
    private final DMatrixRMaj momentumMatrix = new DMatrixRMaj(6, 1);
    private double totalMass = 0.0;
    private boolean isCentroidalMomentumUpToDate = false;
    private boolean isJointVelocityMatrixUpToDate = false;
    private boolean isMomentumUpToDate = false;
    private boolean isTotalMassUpToDate = false;
    private boolean isCenterOfMassVelocityUpToDate = false;

    public CentroidalMomentumCalculator(RigidBodyReadOnly rootBody, ReferenceFrame matrixFrame) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody), matrixFrame);
    }

    public CentroidalMomentumCalculator(MultiBodySystemReadOnly input, ReferenceFrame matrixFrame) {
        this(input, matrixFrame, true);
    }

    public CentroidalMomentumCalculator(MultiBodySystemReadOnly input, ReferenceFrame matrixFrame, boolean considerIgnoredSubtreesInertia) {
        this.input = input;
        this.matrixFrame = matrixFrame;
        RigidBodyReadOnly rootBody = input.getRootBody();
        IterativeStep initialIterativeStep = new IterativeStep(rootBody, null);
        this.iterativeSteps = this.buildMultiBodyTree(initialIterativeStep, input.getJointsToIgnore()).toArray(new IterativeStep[0]);
        if (considerIgnoredSubtreesInertia) {
            initialIterativeStep.includeIgnoredSubtreeInertia();
        }
        this.jointUnitTwist = new Twist();
        this.unitMomentum = new Momentum(matrixFrame);
        this.intermediateUnitTwist = new Twist();
        this.intermediateMomentum = new Momentum();
        this.momentum = new Momentum(matrixFrame);
        this.centerOfMassVelocity = new FrameVector3D(matrixFrame);
        int nDegreesOfFreedom = MultiBodySystemTools.computeDegreesOfFreedom(input.getJointsToConsider());
        this.centroidalMomentumMatrix = new DMatrixRMaj(6, nDegreesOfFreedom);
        this.jointVelocityMatrix = new DMatrixRMaj(nDegreesOfFreedom, 1);
    }

    /*
     * WARNING - void declaration
     */
    private List<IterativeStep> buildMultiBodyTree(IterativeStep parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        ArrayList<IterativeStep> iterativeSteps = new ArrayList<IterativeStep>();
        iterativeSteps.add(parent);
        ArrayList<? extends JointReadOnly> childrenJoints = new ArrayList<JointReadOnly>(parent.rigidBody.getChildrenJoints());
        if (childrenJoints.size() > 1) {
            void var6_7;
            ArrayList<JointReadOnly> loopClosureAncestors = new ArrayList<JointReadOnly>();
            boolean bl = false;
            while (var6_7 < childrenJoints.size()) {
                if (MultiBodySystemTools.doesSubtreeContainLoopClosure(((JointReadOnly)childrenJoints.get((int)var6_7)).getSuccessor())) {
                    loopClosureAncestors.add((JointReadOnly)childrenJoints.remove((int)var6_7));
                    continue;
                }
                ++var6_7;
            }
            childrenJoints.addAll(loopClosureAncestors);
        }
        for (JointReadOnly jointReadOnly : childrenJoints) {
            RigidBodyReadOnly childBody;
            if (jointsToIgnore.contains(jointReadOnly) || jointReadOnly.isLoopClosure() || (childBody = jointReadOnly.getSuccessor()) == null) continue;
            int[] jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(jointReadOnly);
            IterativeStep child = new IterativeStep(childBody, jointIndices);
            parent.children.add(child);
            iterativeSteps.addAll(this.buildMultiBodyTree(child, jointsToIgnore));
        }
        return iterativeSteps;
    }

    public void reset() {
        this.isCentroidalMomentumUpToDate = false;
        this.isJointVelocityMatrixUpToDate = false;
        this.isMomentumUpToDate = false;
        this.isTotalMassUpToDate = false;
        this.isCenterOfMassVelocityUpToDate = false;
    }

    private void updateCentroidalMomentum() {
        if (this.isCentroidalMomentumUpToDate) {
            return;
        }
        this.passOne();
        this.passTwo();
        this.isCentroidalMomentumUpToDate = true;
    }

    private void passOne() {
        for (IterativeStep iterativeStep : this.iterativeSteps) {
            iterativeStep.passOne();
        }
    }

    private void passTwo() {
        for (IterativeStep iterativeStep : this.iterativeSteps) {
            iterativeStep.passTwo();
        }
    }

    private DMatrixRMaj getJointVelocityMatrix() {
        if (!this.isJointVelocityMatrixUpToDate) {
            List<? extends JointReadOnly> joints = this.input.getJointMatrixIndexProvider().getIndexedJointsInOrder();
            MultiBodySystemTools.extractJointsState(joints, JointStateType.VELOCITY, (DMatrix)this.jointVelocityMatrix);
            this.isJointVelocityMatrixUpToDate = true;
        }
        return this.jointVelocityMatrix;
    }

    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    public double getTotalMass() {
        if (!this.isTotalMassUpToDate) {
            this.totalMass = 0.0;
            List<? extends JointReadOnly> jointsToConsider = this.input.getJointsToConsider();
            for (int i = 0; i < jointsToConsider.size(); ++i) {
                this.totalMass += jointsToConsider.get(i).getSuccessor().getInertia().getMass();
            }
            this.isTotalMassUpToDate = true;
        }
        return this.totalMass;
    }

    public FrameVector3DReadOnly getCenterOfMassVelocity() {
        if (!this.isCenterOfMassVelocityUpToDate) {
            this.centerOfMassVelocity.setAndScale(1.0 / this.getTotalMass(), (FrameTuple3DReadOnly)this.getMomentum().getLinearPart());
            this.isCenterOfMassVelocityUpToDate = true;
        }
        return this.centerOfMassVelocity;
    }

    public void getCenterOfMassVelocity(DMatrix1Row jointVelocityMatrix, FrameVector3DBasics centerOfMassVelocityToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)this.getCentroidalMomentumMatrix(), (DMatrix1Row)jointVelocityMatrix, (DMatrix1Row)this.momentumMatrix);
        centerOfMassVelocityToPack.setIncludingFrame(this.matrixFrame, 3, (DMatrix)this.momentumMatrix);
        centerOfMassVelocityToPack.scale(1.0 / this.getTotalMass());
    }

    public MomentumReadOnly getMomentum() {
        if (!this.isMomentumUpToDate) {
            CommonOps_DDRM.mult((DMatrix1Row)this.getCentroidalMomentumMatrix(), (DMatrix1Row)this.getJointVelocityMatrix(), (DMatrix1Row)this.momentumMatrix);
            this.momentum.set((DMatrix)this.momentumMatrix);
            this.isMomentumUpToDate = true;
        }
        return this.momentum;
    }

    public void getMomentum(DMatrix1Row jointVelocityMatrix, MomentumBasics momentumToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)this.getCentroidalMomentumMatrix(), (DMatrix1Row)jointVelocityMatrix, (DMatrix1Row)this.momentumMatrix);
        momentumToPack.setIncludingFrame(this.matrixFrame, (DMatrix)this.momentumMatrix);
    }

    public DMatrixRMaj getCentroidalMomentumMatrix() {
        this.updateCentroidalMomentum();
        return this.centroidalMomentumMatrix;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.matrixFrame;
    }

    private class IterativeStep {
        private final RigidBodyReadOnly rigidBody;
        private final SpatialInertia bodyInertia;
        private final DMatrixRMaj centroidalMomentumMatrixBlock;
        private final RigidBodyTransform matrixFrameToBodyFixedFrameTransform;
        private final List<IterativeStep> children = new ArrayList<IterativeStep>();
        private final int[] jointIndices;

        public IterativeStep(RigidBodyReadOnly rigidBody, int[] jointIndices) {
            this.rigidBody = rigidBody;
            this.jointIndices = jointIndices;
            if (this.isRoot()) {
                this.bodyInertia = null;
                this.centroidalMomentumMatrixBlock = null;
                this.matrixFrameToBodyFixedFrameTransform = null;
            } else {
                this.bodyInertia = new SpatialInertia(rigidBody.getInertia());
                this.centroidalMomentumMatrixBlock = new DMatrixRMaj(6, this.getJoint().getDegreesOfFreedom());
                this.matrixFrameToBodyFixedFrameTransform = new RigidBodyTransform();
            }
        }

        public void includeIgnoredSubtreeInertia() {
            if (!this.isRoot() && this.children.size() != this.rigidBody.getChildrenJoints().size()) {
                for (JointReadOnly jointReadOnly : this.rigidBody.getChildrenJoints()) {
                    if (!CentroidalMomentumCalculator.this.input.getJointsToIgnore().contains(jointReadOnly)) continue;
                    SpatialInertia subtreeIneria = MultiBodySystemTools.computeSubtreeInertia(jointReadOnly);
                    subtreeIneria.changeFrame(this.rigidBody.getBodyFixedFrame());
                    this.bodyInertia.add(subtreeIneria);
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).includeIgnoredSubtreeInertia();
            }
        }

        public void passOne() {
            if (this.isRoot()) {
                return;
            }
            ReferenceFrame inertiaFrame = this.bodyInertia.getReferenceFrame();
            CentroidalMomentumCalculator.this.matrixFrame.getTransformToDesiredFrame(this.matrixFrameToBodyFixedFrameTransform, inertiaFrame);
        }

        public void passTwo() {
            if (this.isRoot()) {
                return;
            }
            for (int i = 0; i < this.getJoint().getDegreesOfFreedom(); ++i) {
                CentroidalMomentumCalculator.this.unitMomentum.setToZero();
                CentroidalMomentumCalculator.this.jointUnitTwist.setIncludingFrame(this.getJoint().getUnitTwists().get(i));
                CentroidalMomentumCalculator.this.jointUnitTwist.changeFrame(CentroidalMomentumCalculator.this.matrixFrame);
                this.addToUnitMomentumRecursively(CentroidalMomentumCalculator.this.jointUnitTwist, CentroidalMomentumCalculator.this.unitMomentum);
                CentroidalMomentumCalculator.this.unitMomentum.get(0, i, (DMatrix)this.centroidalMomentumMatrixBlock);
            }
            for (int dofIndex = 0; dofIndex < this.getJoint().getDegreesOfFreedom(); ++dofIndex) {
                int column = this.jointIndices[dofIndex];
                CommonOps_DDRM.extract((DMatrix)this.centroidalMomentumMatrixBlock, (int)0, (int)6, (int)dofIndex, (int)(dofIndex + 1), (DMatrix)CentroidalMomentumCalculator.this.centroidalMomentumMatrix, (int)0, (int)column);
            }
        }

        private void addToUnitMomentumRecursively(TwistReadOnly ancestorUnitTwist, FixedFrameMomentumBasics unitMomentumToAddTo) {
            ReferenceFrame inertiaFrame = this.bodyInertia.getReferenceFrame();
            CentroidalMomentumCalculator.this.intermediateUnitTwist.setIncludingFrame(ancestorUnitTwist);
            CentroidalMomentumCalculator.this.intermediateUnitTwist.applyTransform((RigidBodyTransformReadOnly)this.matrixFrameToBodyFixedFrameTransform);
            CentroidalMomentumCalculator.this.intermediateUnitTwist.setReferenceFrame(inertiaFrame);
            CentroidalMomentumCalculator.this.intermediateMomentum.setReferenceFrame(inertiaFrame);
            CentroidalMomentumCalculator.this.intermediateMomentum.compute(this.bodyInertia, CentroidalMomentumCalculator.this.intermediateUnitTwist);
            CentroidalMomentumCalculator.this.intermediateMomentum.applyInverseTransform((RigidBodyTransformReadOnly)this.matrixFrameToBodyFixedFrameTransform);
            CentroidalMomentumCalculator.this.intermediateMomentum.setReferenceFrame(CentroidalMomentumCalculator.this.matrixFrame);
            unitMomentumToAddTo.add(CentroidalMomentumCalculator.this.intermediateMomentum);
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).addToUnitMomentumRecursively(ancestorUnitTwist, unitMomentumToAddTo);
            }
        }

        public boolean isRoot() {
            return this.jointIndices == null;
        }

        public JointReadOnly getJoint() {
            return this.rigidBody.getParentJoint();
        }
    }
}

