/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.interfaces.MomentumBasics;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;

public class Momentum
implements MomentumBasics,
GeometryObject<Momentum> {
    private final SpatialForce spatialForceVector = new SpatialForce();

    public Momentum() {
        this.setToZero(null);
    }

    public Momentum(ReferenceFrame expressedInFrame) {
        this.setToZero(expressedInFrame);
    }

    public Momentum(ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.setIncludingFrame(expressedInFrame, linearPart, angularPart);
    }

    public Momentum(ReferenceFrame expressedInFrame, DMatrix matrix) {
        this.setIncludingFrame(expressedInFrame, matrix);
    }

    public Momentum(ReferenceFrame expressedInFrame, double[] array) {
        this.setIncludingFrame(expressedInFrame, array);
    }

    public Momentum(MomentumReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(Momentum other) {
        MomentumBasics.super.set((SpatialVectorReadOnly)other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame expressedInFrame) {
        this.spatialForceVector.setReferenceFrame(expressedInFrame);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.spatialForceVector.getReferenceFrame();
    }

    @Override
    public FixedFrameVector3DBasics getAngularPart() {
        return this.spatialForceVector.getAngularPart();
    }

    @Override
    public FixedFrameVector3DBasics getLinearPart() {
        return this.spatialForceVector.getLinearPart();
    }

    @Override
    public void applyTransform(Transform transform) {
        this.spatialForceVector.applyTransform(transform);
    }

    @Override
    public void applyInverseTransform(Transform transform) {
        this.spatialForceVector.applyInverseTransform(transform);
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        this.spatialForceVector.changeFrame(desiredFrame);
    }

    public boolean epsilonEquals(Momentum other, double epsilon) {
        return this.spatialForceVector.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(Momentum other, double epsilon) {
        return this.spatialForceVector.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MomentumReadOnly) {
            return this.equals((MomentumReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return MecanoIOTools.getMomentumString(this);
    }
}

