/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.function.DoubleSupplier;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.tools.MecanoTools;

public class MecanoFactories {
    private static final double TRANSFORM_UPDATER_EPSILON = 1.0E-7;

    public static MovingReferenceFrame newFrameBeforeJoint(JointReadOnly joint, RigidBodyTransformReadOnly transformToParent) {
        String beforeJointName = "before" + MecanoTools.capitalize(joint.getName());
        return MecanoFactories.newJointFrame(joint, transformToParent, beforeJointName);
    }

    public static MovingReferenceFrame newJointFrame(JointReadOnly joint, RigidBodyTransformReadOnly transformToParent, String beforeJointName) {
        MovingReferenceFrame parentFrame;
        RigidBodyReadOnly parentBody = joint.getPredecessor();
        if (parentBody.isRootBody()) {
            parentFrame = parentBody.getBodyFixedFrame();
            if (transformToParent == null) {
                return parentFrame;
            }
        } else {
            parentFrame = parentBody.getParentJoint().getFrameAfterJoint();
        }
        return MovingReferenceFrame.constructFrameFixedInParent(beforeJointName, parentFrame, transformToParent);
    }

    public static MovingReferenceFrame newFrameAfterJoint(final JointReadOnly joint) {
        MovingReferenceFrame frameBeforeJoint = joint.getFrameBeforeJoint();
        if (frameBeforeJoint == null) {
            throw new NullPointerException("The frameBeforeJoint has to be created before the frameAfterJoint.");
        }
        return new MovingReferenceFrame("after" + MecanoTools.capitalize(joint.getName()), (ReferenceFrame)frameBeforeJoint){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                joint.getJointConfiguration(transformToParent);
            }

            @Override
            protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
                twistRelativeToParentToPack.setIncludingFrame(joint.getJointTwist());
            }
        };
    }

    public static RevoluteJointTransformUpdater newRevoluteJointTransformUpdater(RevoluteJointReadOnly joint) {
        RevoluteJointTransformUpdater jointTransformUpdater;
        FrameVector3DReadOnly jointAxis = joint.getJointAxis();
        if (jointAxis.geometricallyEquals((Vector3DReadOnly)Axis3D.X, 1.0E-7)) {
            jointTransformUpdater = transform -> transform.setRotationRollAndZeroTranslation(joint.getQ());
        } else if (jointAxis.geometricallyEquals((Vector3DReadOnly)Axis3D.Y, 1.0E-7)) {
            jointTransformUpdater = transform -> transform.setRotationPitchAndZeroTranslation(joint.getQ());
        } else if (jointAxis.geometricallyEquals((Vector3DReadOnly)Axis3D.Z, 1.0E-7)) {
            jointTransformUpdater = transform -> transform.setRotationYawAndZeroTranslation(joint.getQ());
        } else {
            AxisAngle axisAngle = new AxisAngle();
            jointTransformUpdater = transform -> {
                axisAngle.set((Vector3DReadOnly)joint.getJointAxis(), joint.getQ());
                transform.setRotationAndZeroTranslation((Orientation3DReadOnly)axisAngle);
            };
        }
        return jointTransformUpdater;
    }

    public static QuaternionBasics newPitchOnlyQuaternionBasics() {
        return new QuaternionBasics(){
            private double x;
            private double y;
            private double z;
            private double s;

            public double getX() {
                return this.x;
            }

            public double getY() {
                return this.y;
            }

            public double getZ() {
                return this.z;
            }

            public double getS() {
                return this.s;
            }

            public void setUnsafe(double qx, double qy, double qz, double qs) {
                this.x = qx;
                this.y = qy;
                this.z = qz;
                this.s = qs;
                if (Math.abs(this.x) > 1.0E-5 || Math.abs(this.z) > 1.0E-5) {
                    this.setToPitchOrientation(this.getPitch());
                }
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof Tuple4DReadOnly) {
                    return this.equals((Tuple4DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple4DString((Tuple4DReadOnly)this);
            }
        };
    }

    public static Point3DBasics newXZOnlyPoint3DBasics() {
        return new Point3DBasics(){
            private double x;
            private double z;

            public double getX() {
                return this.x;
            }

            public double getY() {
                return 0.0;
            }

            public double getZ() {
                return this.z;
            }

            public void setX(double x) {
                this.x = x;
            }

            public void setY(double y) {
            }

            public void setZ(double z) {
                this.z = z;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof Tuple3DReadOnly) {
                    return this.equals((Tuple3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this);
            }
        };
    }

    public static FixedFrameVector3DBasics newXZOnlyFixedFrameVector3DBasics(final ReferenceFrame referenceFrame) {
        return new FixedFrameVector3DBasics(){
            private double x;
            private double z;

            public ReferenceFrame getReferenceFrame() {
                return referenceFrame;
            }

            public double getX() {
                return this.x;
            }

            public double getY() {
                return 0.0;
            }

            public double getZ() {
                return this.z;
            }

            public void setX(double x) {
                this.x = x;
            }

            public void setY(double y) {
            }

            public void setZ(double z) {
                this.z = z;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameTuple3DReadOnly) {
                    return this.equals((FrameTuple3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this);
            }
        };
    }

    public static FixedFrameVector3DBasics newYOnlyFixedFrameVector3DBasics(final ReferenceFrame referenceFrame) {
        return new FixedFrameVector3DBasics(){
            private double y;

            public ReferenceFrame getReferenceFrame() {
                return referenceFrame;
            }

            public double getX() {
                return 0.0;
            }

            public double getY() {
                return this.y;
            }

            public double getZ() {
                return 0.0;
            }

            public void setX(double x) {
            }

            public void setY(double y) {
                this.y = y;
            }

            public void setZ(double z) {
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameTuple3DReadOnly) {
                    return this.equals((FrameTuple3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this);
            }
        };
    }

    public static FixedFrameVector3DBasics newFixedFrameVector3DBasics(final ReferenceFrameHolder referenceFrameHolder) {
        return new FixedFrameVector3DBasics(){
            private double x;
            private double y;
            private double z;

            public void setX(double x) {
                this.x = x;
            }

            public void setY(double y) {
                this.y = y;
            }

            public void setZ(double z) {
                this.z = z;
            }

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public double getX() {
                return this.x;
            }

            public double getY() {
                return this.y;
            }

            public double getZ() {
                return this.z;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameTuple3DReadOnly) {
                    return this.equals((FrameTuple3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this) + "-" + this.getReferenceFrame();
            }
        };
    }

    @Deprecated
    public static FramePoint3DReadOnly newFramePoint3DReadOnly(DoubleSupplier scaleSupplier, FrameTuple3DReadOnly referenceTuple) {
        return EuclidFrameFactories.newLinkedFramePoint3DReadOnly((DoubleSupplier)scaleSupplier, (FrameTuple3DReadOnly)referenceTuple);
    }

    @Deprecated
    public static FrameVector3DReadOnly newFrameVector3DReadOnly(DoubleSupplier scaleSupplier, FrameVector3DReadOnly referenceVector) {
        return EuclidFrameFactories.newLinkedFrameVector3DReadOnly((DoubleSupplier)scaleSupplier, (FrameTuple3DReadOnly)referenceVector);
    }

    public static Pose3DBasics newPlanarPose3DBasics() {
        return new Pose3DBasics(){
            private final QuaternionBasics jointRotation = MecanoFactories.newPitchOnlyQuaternionBasics();
            private final Point3DBasics jointTranslation = MecanoFactories.newXZOnlyPoint3DBasics();

            public Point3DBasics getPosition() {
                return this.jointTranslation;
            }

            public QuaternionBasics getOrientation() {
                return this.jointRotation;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof Pose3DReadOnly) {
                    return this.equals((Pose3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidGeometryIOTools.getPose3DString((Pose3DReadOnly)this);
            }
        };
    }

    public static TwistReadOnly newTwistReadOnly(final DoubleSupplier scaleSupplier, final TwistReadOnly referenceTwist) {
        return new TwistReadOnly(){
            private final FrameVector3DReadOnly angularPart;
            private final FrameVector3DReadOnly linearPart;
            {
                this.angularPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((DoubleSupplier)scaleSupplier, (FrameTuple3DReadOnly)referenceTwist.getAngularPart());
                this.linearPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((DoubleSupplier)scaleSupplier, (FrameTuple3DReadOnly)referenceTwist.getLinearPart());
            }

            @Override
            public ReferenceFrame getBodyFrame() {
                return referenceTwist.getBodyFrame();
            }

            @Override
            public ReferenceFrame getBaseFrame() {
                return referenceTwist.getBaseFrame();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceTwist.getReferenceFrame();
            }

            @Override
            public FrameVector3DReadOnly getAngularPart() {
                return this.angularPart;
            }

            @Override
            public FrameVector3DReadOnly getLinearPart() {
                return this.linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof TwistReadOnly) {
                    return this.equals((TwistReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getTwistString(this);
            }
        };
    }

    public static TwistReadOnly newTwistReadOnly(final ReferenceFrame bodyFrame, final ReferenceFrame baseFrame, final FrameVector3DReadOnly angularPart, final FrameVector3DReadOnly linearPart) {
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
        return new TwistReadOnly(){

            @Override
            public ReferenceFrame getBodyFrame() {
                return bodyFrame;
            }

            @Override
            public ReferenceFrame getBaseFrame() {
                return baseFrame;
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
                return angularPart.getReferenceFrame();
            }

            @Override
            public FrameVector3DReadOnly getAngularPart() {
                return angularPart;
            }

            @Override
            public FrameVector3DReadOnly getLinearPart() {
                return linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof TwistReadOnly) {
                    return this.equals((TwistReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getTwistString(this);
            }
        };
    }

    public static FixedFrameTwistBasics newPlanarFixedFrameTwistBasics(final ReferenceFrame bodyFrame, final ReferenceFrame baseFrame, final ReferenceFrame expressedInFrame) {
        return new FixedFrameTwistBasics(){
            private final FixedFrameVector3DBasics angularPart;
            private final FixedFrameVector3DBasics linearPart;
            {
                this.angularPart = MecanoFactories.newYOnlyFixedFrameVector3DBasics(expressedInFrame);
                this.linearPart = MecanoFactories.newXZOnlyFixedFrameVector3DBasics(expressedInFrame);
            }

            @Override
            public ReferenceFrame getBodyFrame() {
                return bodyFrame;
            }

            @Override
            public ReferenceFrame getBaseFrame() {
                return baseFrame;
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return expressedInFrame;
            }

            @Override
            public FixedFrameVector3DBasics getAngularPart() {
                return this.angularPart;
            }

            @Override
            public FixedFrameVector3DBasics getLinearPart() {
                return this.linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof TwistReadOnly) {
                    return this.equals((TwistReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getTwistString(this);
            }
        };
    }

    public static SpatialAccelerationReadOnly newSpatialAccelerationVectorReadOnly(final DoubleSupplier scaleSupplier, final SpatialAccelerationReadOnly referenceAcceleration) {
        return new SpatialAccelerationReadOnly(){
            private final FrameVector3DReadOnly angularPart;
            private final FrameVector3DReadOnly linearPart;
            {
                this.angularPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((DoubleSupplier)scaleSupplier, (FrameTuple3DReadOnly)referenceAcceleration.getAngularPart());
                this.linearPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((DoubleSupplier)scaleSupplier, (FrameTuple3DReadOnly)referenceAcceleration.getLinearPart());
            }

            @Override
            public ReferenceFrame getBodyFrame() {
                return referenceAcceleration.getBodyFrame();
            }

            @Override
            public ReferenceFrame getBaseFrame() {
                return referenceAcceleration.getBaseFrame();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceAcceleration.getReferenceFrame();
            }

            @Override
            public FrameVector3DReadOnly getAngularPart() {
                return this.angularPart;
            }

            @Override
            public FrameVector3DReadOnly getLinearPart() {
                return this.linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof SpatialAccelerationReadOnly) {
                    return this.equals((SpatialAccelerationReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getSpatialAccelerationString(this);
            }
        };
    }

    public static SpatialAccelerationReadOnly newSpatialAccelerationVectorReadOnly(DoubleSupplier scaleSupplier, final SpatialAccelerationReadOnly referenceAcceleration, SpatialAccelerationReadOnly biasAcceleration) {
        referenceAcceleration.checkReferenceFrameMatch(biasAcceleration);
        final DoubleSupplier wx = () -> scaleSupplier.getAsDouble() * referenceAcceleration.getAngularPartX() + biasAcceleration.getAngularPartX();
        final DoubleSupplier wy = () -> scaleSupplier.getAsDouble() * referenceAcceleration.getAngularPartY() + biasAcceleration.getAngularPartY();
        final DoubleSupplier wz = () -> scaleSupplier.getAsDouble() * referenceAcceleration.getAngularPartZ() + biasAcceleration.getAngularPartZ();
        final DoubleSupplier vx = () -> scaleSupplier.getAsDouble() * referenceAcceleration.getLinearPartX() + biasAcceleration.getLinearPartX();
        final DoubleSupplier vy = () -> scaleSupplier.getAsDouble() * referenceAcceleration.getLinearPartY() + biasAcceleration.getLinearPartY();
        final DoubleSupplier vz = () -> scaleSupplier.getAsDouble() * referenceAcceleration.getLinearPartZ() + biasAcceleration.getLinearPartZ();
        return new SpatialAccelerationReadOnly(){
            private final FrameVector3DReadOnly angularPart;
            private final FrameVector3DReadOnly linearPart;
            {
                this.angularPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((ReferenceFrameHolder)referenceAcceleration, (DoubleSupplier)wx, (DoubleSupplier)wy, (DoubleSupplier)wz);
                this.linearPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((ReferenceFrameHolder)referenceAcceleration, (DoubleSupplier)vx, (DoubleSupplier)vy, (DoubleSupplier)vz);
            }

            @Override
            public ReferenceFrame getBodyFrame() {
                return referenceAcceleration.getBodyFrame();
            }

            @Override
            public ReferenceFrame getBaseFrame() {
                return referenceAcceleration.getBaseFrame();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceAcceleration.getReferenceFrame();
            }

            @Override
            public FrameVector3DReadOnly getAngularPart() {
                return this.angularPart;
            }

            @Override
            public FrameVector3DReadOnly getLinearPart() {
                return this.linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof SpatialAccelerationReadOnly) {
                    return this.equals((SpatialAccelerationReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getSpatialAccelerationString(this);
            }
        };
    }

    public static SpatialAccelerationReadOnly newSpatialAccelerationVectorReadOnly(final ReferenceFrame bodyFrame, final ReferenceFrame baseFrame, final FrameVector3DReadOnly angularPart, final FrameVector3DReadOnly linearPart) {
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
        return new SpatialAccelerationReadOnly(){

            @Override
            public ReferenceFrame getBodyFrame() {
                return bodyFrame;
            }

            @Override
            public ReferenceFrame getBaseFrame() {
                return baseFrame;
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
                return angularPart.getReferenceFrame();
            }

            @Override
            public FrameVector3DReadOnly getAngularPart() {
                return angularPart;
            }

            @Override
            public FrameVector3DReadOnly getLinearPart() {
                return linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof SpatialAccelerationReadOnly) {
                    return this.equals((SpatialAccelerationReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getSpatialAccelerationString(this);
            }
        };
    }

    public static FixedFrameSpatialAccelerationBasics newPlanarFixedFrameSpatialAccelerationVectorBasics(final ReferenceFrame bodyFrame, final ReferenceFrame baseFrame, final ReferenceFrame expressedInFrame) {
        return new FixedFrameSpatialAccelerationBasics(){
            private final FixedFrameVector3DBasics angularPart;
            private final FixedFrameVector3DBasics linearPart;
            {
                this.angularPart = MecanoFactories.newYOnlyFixedFrameVector3DBasics(expressedInFrame);
                this.linearPart = MecanoFactories.newXZOnlyFixedFrameVector3DBasics(expressedInFrame);
            }

            @Override
            public ReferenceFrame getBodyFrame() {
                return bodyFrame;
            }

            @Override
            public ReferenceFrame getBaseFrame() {
                return baseFrame;
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return expressedInFrame;
            }

            @Override
            public FixedFrameVector3DBasics getAngularPart() {
                return this.angularPart;
            }

            @Override
            public FixedFrameVector3DBasics getLinearPart() {
                return this.linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof SpatialAccelerationReadOnly) {
                    return this.equals((SpatialAccelerationReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getSpatialAccelerationString(this);
            }
        };
    }

    public static WrenchReadOnly newWrenchReadOnly(final DoubleSupplier scaleSupplier, final WrenchReadOnly referenceWrench) {
        return new WrenchReadOnly(){
            private final FrameVector3DReadOnly angularPart;
            private final FrameVector3DReadOnly linearPart;
            {
                this.angularPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((DoubleSupplier)scaleSupplier, (FrameTuple3DReadOnly)referenceWrench.getAngularPart());
                this.linearPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((DoubleSupplier)scaleSupplier, (FrameTuple3DReadOnly)referenceWrench.getLinearPart());
            }

            @Override
            public ReferenceFrame getBodyFrame() {
                return referenceWrench.getBodyFrame();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceWrench.getReferenceFrame();
            }

            @Override
            public FrameVector3DReadOnly getAngularPart() {
                return this.angularPart;
            }

            @Override
            public FrameVector3DReadOnly getLinearPart() {
                return this.linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof WrenchReadOnly) {
                    return this.equals((WrenchReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getWrenchString(this);
            }
        };
    }

    public static WrenchReadOnly newWrenchReadOnly(final ReferenceFrame bodyFrame, final FrameVector3DReadOnly angularPart, final FrameVector3DReadOnly linearPart) {
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
        return new WrenchReadOnly(){

            @Override
            public ReferenceFrame getBodyFrame() {
                return bodyFrame;
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
                return angularPart.getReferenceFrame();
            }

            @Override
            public FrameVector3DReadOnly getAngularPart() {
                return angularPart;
            }

            @Override
            public FrameVector3DReadOnly getLinearPart() {
                return linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof WrenchReadOnly) {
                    return this.equals((WrenchReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getWrenchString(this);
            }
        };
    }

    public static SpatialImpulseReadOnly newSpatialImpulseReadOnly(final DoubleSupplier scaleSupplier, final SpatialImpulseReadOnly referenceSpatialImpulse) {
        return new SpatialImpulseReadOnly(){
            private final FrameVector3DReadOnly angularPart;
            private final FrameVector3DReadOnly linearPart;
            {
                this.angularPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((DoubleSupplier)scaleSupplier, (FrameTuple3DReadOnly)referenceSpatialImpulse.getAngularPart());
                this.linearPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly((DoubleSupplier)scaleSupplier, (FrameTuple3DReadOnly)referenceSpatialImpulse.getLinearPart());
            }

            @Override
            public ReferenceFrame getBodyFrame() {
                return referenceSpatialImpulse.getBodyFrame();
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return referenceSpatialImpulse.getReferenceFrame();
            }

            @Override
            public FrameVector3DReadOnly getAngularPart() {
                return this.angularPart;
            }

            @Override
            public FrameVector3DReadOnly getLinearPart() {
                return this.linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof SpatialImpulseReadOnly) {
                    return this.equals((SpatialImpulseReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getSpatialImpulseString(this);
            }
        };
    }

    public static FixedFrameWrenchBasics newPlanarFixedFrameWrenchBasics(final ReferenceFrame bodyFrame, final ReferenceFrame expressedInFrame) {
        return new FixedFrameWrenchBasics(){
            private final FixedFrameVector3DBasics angularPart;
            private final FixedFrameVector3DBasics linearPart;
            {
                this.angularPart = MecanoFactories.newYOnlyFixedFrameVector3DBasics(expressedInFrame);
                this.linearPart = MecanoFactories.newXZOnlyFixedFrameVector3DBasics(expressedInFrame);
            }

            @Override
            public ReferenceFrame getBodyFrame() {
                return bodyFrame;
            }

            @Override
            public ReferenceFrame getReferenceFrame() {
                return expressedInFrame;
            }

            @Override
            public FixedFrameVector3DBasics getAngularPart() {
                return this.angularPart;
            }

            @Override
            public FixedFrameVector3DBasics getLinearPart() {
                return this.linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof WrenchReadOnly) {
                    return this.equals((WrenchReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return MecanoIOTools.getWrenchString(this);
            }
        };
    }

    public static SpatialAccelerationReadOnly newGravitationalSpatialAcceleration(RigidBodyReadOnly rootBody, double gravity) {
        Vector3D gravitationalAcceleration = new Vector3D(0.0, 0.0, gravity);
        Vector3D zero = new Vector3D();
        MovingReferenceFrame bodyFixedFrame = rootBody.getBodyFixedFrame();
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        return new SpatialAcceleration(bodyFixedFrame, worldFrame, bodyFixedFrame, (Vector3DReadOnly)zero, (Vector3DReadOnly)gravitationalAcceleration);
    }

    public static Matrix3DReadOnly createTransposeLinkedMatrix3DReadOnly(Matrix3DBasics original) {
        return EuclidCoreFactories.newTransposeLinkedMatrix3DReadOnly((Matrix3DReadOnly)original);
    }

    public static interface RevoluteJointTransformUpdater {
        public void updateJointTransform(RigidBodyTransform var1);
    }
}

