/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;

public interface SpatialVectorReadOnly
extends ReferenceFrameHolder {
    public static final int SIZE = 6;

    public FrameVector3DReadOnly getAngularPart();

    public FrameVector3DReadOnly getLinearPart();

    public ReferenceFrame getReferenceFrame();

    default public boolean containsNaN() {
        return this.getAngularPart().containsNaN() || this.getLinearPart().containsNaN();
    }

    default public double getAngularPartX() {
        return this.getAngularPart().getX();
    }

    default public double getAngularPartY() {
        return this.getAngularPart().getY();
    }

    default public double getAngularPartZ() {
        return this.getAngularPart().getZ();
    }

    default public double getLinearPartX() {
        return this.getLinearPart().getX();
    }

    default public double getLinearPartY() {
        return this.getLinearPart().getY();
    }

    default public double getLinearPartZ() {
        return this.getLinearPart().getZ();
    }

    default public double getElement(int index) {
        switch (index) {
            case 0: {
                return this.getAngularPartX();
            }
            case 1: {
                return this.getAngularPartY();
            }
            case 2: {
                return this.getAngularPartZ();
            }
            case 3: {
                return this.getLinearPartX();
            }
            case 4: {
                return this.getLinearPartY();
            }
            case 5: {
                return this.getLinearPartZ();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    default public void get(double[] arrayToPack) {
        this.get(0, arrayToPack);
    }

    default public void get(int startIndex, double[] arrayToPack) {
        this.getAngularPart().get(startIndex, arrayToPack);
        this.getLinearPart().get(startIndex + 3, arrayToPack);
    }

    default public void get(float[] arrayToPack) {
        this.get(0, arrayToPack);
    }

    default public void get(int startIndex, float[] arrayToPack) {
        this.getAngularPart().get(startIndex, arrayToPack);
        this.getLinearPart().get(startIndex + 3, arrayToPack);
    }

    default public void get(DMatrix matrixToPack) {
        this.get(0, 0, matrixToPack);
    }

    default public void get(int startRow, DMatrix matrixToPack) {
        this.get(startRow, 0, matrixToPack);
    }

    default public void get(int startRow, int column, DMatrix matrixToPack) {
        this.getAngularPart().get(startRow, column, matrixToPack);
        this.getLinearPart().get(startRow + 3, column, matrixToPack);
    }

    default public double dot(SpatialVectorReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return this.getAngularPart().dot(other.getAngularPart()) + this.getLinearPart().dot(other.getLinearPart());
    }

    default public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    default public double lengthSquared() {
        return this.getAngularPart().lengthSquared() + this.getLinearPart().lengthSquared();
    }

    default public boolean epsilonEquals(SpatialVectorReadOnly other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        if (!this.getAngularPart().epsilonEquals((FrameTuple3DReadOnly)other.getAngularPart(), epsilon)) {
            return false;
        }
        return this.getLinearPart().epsilonEquals((FrameTuple3DReadOnly)other.getLinearPart(), epsilon);
    }

    default public boolean equals(SpatialVectorReadOnly other) {
        if (other == null) {
            return false;
        }
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        if (!this.getAngularPart().equals((FrameTuple3DReadOnly)other.getAngularPart())) {
            return false;
        }
        return this.getLinearPart().equals((FrameTuple3DReadOnly)other.getLinearPart());
    }
}

