/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;

public interface SixDoFJointReadOnly
extends FloatingJointReadOnly {
    public static final int NUMBER_OF_DOFS = 6;

    @Override
    default public int getJointConfiguration(int rowStart, DMatrix matrixToPack) {
        this.getJointPose().getOrientation().get(rowStart, matrixToPack);
        this.getJointPose().getPosition().get(rowStart + 4, matrixToPack);
        return rowStart + this.getConfigurationMatrixSize();
    }

    @Override
    default public int getJointVelocity(int rowStart, DMatrix matrixToPack) {
        this.getJointTwist().get(rowStart, matrixToPack);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getJointAcceleration(int rowStart, DMatrix matrixToPack) {
        this.getJointAcceleration().get(rowStart, matrixToPack);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getJointTau(int rowStart, DMatrix matrixToPack) {
        this.getJointWrench().get(rowStart, matrixToPack);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getDegreesOfFreedom() {
        return 6;
    }

    @Override
    default public int getConfigurationMatrixSize() {
        return 7;
    }
}

