/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;

public interface CrossFourBarJointBasics
extends CrossFourBarJointReadOnly,
OneDoFJointBasics {
    @Override
    public RevoluteJointBasics getActuatedJoint();

    @Override
    public RevoluteJointBasics getJointA();

    @Override
    public RevoluteJointBasics getJointB();

    @Override
    public RevoluteJointBasics getJointC();

    @Override
    public RevoluteJointBasics getJointD();

    @Override
    default public RigidBodyBasics getBodyDA() {
        return this.getJointA().getSuccessor();
    }

    @Override
    default public RigidBodyBasics getBodyBC() {
        return this.getJointB().getSuccessor();
    }

    @Override
    public void updateFrame();

    @Override
    public void updateMotionSubspace();

    @Override
    default public void setQ(double q) {
        this.getActuatedJoint().setQ(this.computeActuatedJointQ(q));
    }

    @Override
    default public void setQd(double qd) {
        this.getActuatedJoint().setQd(this.computeActuatedJointQd(qd));
    }

    @Override
    default public void setQdd(double qdd) {
        this.getActuatedJoint().setQdd(this.computeActuatedJointQdd(qdd));
    }

    @Override
    default public void setTau(double tau) {
        this.getJointA().setJointTauToZero();
        this.getJointB().setJointTauToZero();
        this.getJointC().setJointTauToZero();
        this.getJointD().setJointTauToZero();
        this.getActuatedJoint().setTau(this.computeActuatedJointTau(tau));
    }

    @Override
    default public void setJointPosition(Tuple3DReadOnly jointPosition) {
    }

    @Override
    default public void setJointAngularVelocity(Vector3DReadOnly jointAngularVelocity) {
        this.setQd(jointAngularVelocity.dot((Vector3DReadOnly)this.getJointAxis()));
    }

    @Override
    default public void setJointLinearVelocity(Vector3DReadOnly jointLinearVelocity) {
    }

    @Override
    default public void setJointAngularAcceleration(Vector3DReadOnly jointAngularAcceleration) {
        this.setQdd(jointAngularAcceleration.dot((Vector3DReadOnly)this.getJointAxis()));
    }

    @Override
    default public void setJointLinearAcceleration(Vector3DReadOnly jointLinearAcceleration) {
    }

    @Override
    default public void setJointTorque(Vector3DReadOnly jointTorque) {
        this.setTau(jointTorque.dot((Vector3DReadOnly)this.getJointAxis()));
    }

    @Override
    default public void setJointForce(Vector3DReadOnly jointForce) {
    }
}

