/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FixedJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public class MultiBodySystemStateIntegrator {
    private double dt;
    private double half_dt_dt;
    private final Vector3D deltaPosition = new Vector3D();
    private final Vector3D rotationVector = new Vector3D();
    private final Quaternion integrated = new Quaternion();
    private final FrameVector3D linearAcceleration = new FrameVector3D();

    public MultiBodySystemStateIntegrator() {
        this(Double.NaN);
    }

    public MultiBodySystemStateIntegrator(double dt) {
        this.setIntegrationDT(dt);
    }

    public void setIntegrationDT(double dt) {
        this.dt = dt;
        this.half_dt_dt = 0.5 * dt * dt;
    }

    public double getIntegrationDT() {
        return this.dt;
    }

    public void integrateFromVelocitySubtree(RigidBodyBasics rootBody) {
        if (rootBody == null) {
            return;
        }
        List<JointBasics> childrenJoints = rootBody.getChildrenJoints();
        for (int i = 0; i < childrenJoints.size(); ++i) {
            JointBasics childJoint = childrenJoints.get(i);
            this.integrateFromVelocity(childJoint);
            this.integrateFromVelocitySubtree(childJoint.getSuccessor());
        }
    }

    public void integrateFromVelocity(List<? extends JointBasics> joints) {
        for (int i = 0; i < joints.size(); ++i) {
            JointBasics joint = joints.get(i);
            this.integrateFromVelocity(joint);
        }
    }

    public void integrateFromVelocity(JointBasics joint) {
        if (joint instanceof OneDoFJointBasics) {
            this.integrateFromVelocity((OneDoFJointBasics)joint);
        } else if (joint instanceof FloatingJointBasics) {
            this.integrateFromVelocity((FloatingJointBasics)joint);
        } else if (joint instanceof SphericalJointBasics) {
            this.integrateFromVelocity((SphericalJointBasics)joint);
        } else {
            if (joint instanceof FixedJointBasics) {
                return;
            }
            throw new UnsupportedOperationException("Integrator does not support the joint type: " + joint.getClass().getSimpleName());
        }
    }

    public void integrateFromVelocity(FloatingJointBasics joint) {
        this.integrate(joint.getJointTwist(), joint.getJointPose());
    }

    public void integrateFromVelocity(OneDoFJointBasics joint) {
        double initialQ = joint.getQ();
        double qd = joint.getQd();
        joint.setQ(this.integratePosition(qd, initialQ));
    }

    public void integrateFromVelocity(SphericalJointBasics joint) {
        this.integrate((Vector3DReadOnly)joint.getJointAngularVelocity(), (Orientation3DBasics)joint.getJointOrientation());
    }

    public void integrate(TwistReadOnly twist, Pose3DBasics poseToIntegrate) {
        this.integrate(twist, (Pose3DReadOnly)poseToIntegrate, poseToIntegrate);
    }

    public void integrate(TwistReadOnly twist, Pose3DReadOnly initialPose, Pose3DBasics finalPose) {
        twist.checkExpressedInFrameMatch(twist.getBodyFrame());
        FrameVector3DReadOnly angularVelocity = twist.getAngularPart();
        FrameVector3DReadOnly linearVelocity = twist.getLinearPart();
        QuaternionReadOnly initialOrientation = initialPose.getOrientation();
        Point3DReadOnly initialPosition = initialPose.getPosition();
        QuaternionBasics finalOrientation = finalPose.getOrientation();
        Point3DBasics finalPosition = finalPose.getPosition();
        this.integrate((Vector3DReadOnly)angularVelocity, (Orientation3DReadOnly)initialOrientation, (Orientation3DBasics)finalOrientation);
        this.integrate((Orientation3DReadOnly)initialOrientation, (Vector3DReadOnly)linearVelocity, (Tuple3DReadOnly)initialPosition, (Tuple3DBasics)finalPosition);
    }

    public void integrate(Vector3DReadOnly angularVelocity, Orientation3DBasics orientationToIntegrate) {
        this.integrate(angularVelocity, (Orientation3DReadOnly)orientationToIntegrate, orientationToIntegrate);
    }

    public void integrate(Vector3DReadOnly angularVelocity, Orientation3DReadOnly initialOrientation, Orientation3DBasics finalOrientation) {
        this.rotationVector.setAndScale(this.dt, (Tuple3DReadOnly)angularVelocity);
        this.integrated.setRotationVector((Vector3DReadOnly)this.rotationVector);
        finalOrientation.set(initialOrientation);
        finalOrientation.append((Orientation3DReadOnly)this.integrated);
    }

    public void integrate(Orientation3DReadOnly orientation, Vector3DReadOnly linearVelocity, Tuple3DBasics positionToIntegrate) {
        this.integrate(orientation, linearVelocity, (Tuple3DReadOnly)positionToIntegrate, positionToIntegrate);
    }

    public void integrate(Orientation3DReadOnly orientation, Vector3DReadOnly linearVelocity, Tuple3DReadOnly initialPosition, Tuple3DBasics finalPosition) {
        this.deltaPosition.setAndScale(this.dt, (Tuple3DReadOnly)linearVelocity);
        if (orientation != null) {
            orientation.transform((Tuple3DBasics)this.deltaPosition);
        }
        finalPosition.add(initialPosition, (Tuple3DReadOnly)this.deltaPosition);
    }

    public double integratePosition(double velocity, double initialPosition) {
        return this.dt * velocity + initialPosition;
    }

    public void doubleIntegrateFromAccelerationSubtree(RigidBodyBasics rootBody) {
        if (rootBody == null) {
            return;
        }
        List<JointBasics> childrenJoints = rootBody.getChildrenJoints();
        for (int i = 0; i < childrenJoints.size(); ++i) {
            JointBasics childJoint = childrenJoints.get(i);
            this.doubleIntegrateFromAcceleration(childJoint);
            this.doubleIntegrateFromAccelerationSubtree(childJoint.getSuccessor());
        }
    }

    public void doubleIntegrateFromAcceleration(List<? extends JointBasics> joints) {
        for (int i = 0; i < joints.size(); ++i) {
            JointBasics joint = joints.get(i);
            this.doubleIntegrateFromAcceleration(joint);
        }
    }

    public void doubleIntegrateFromAcceleration(JointBasics joint) {
        if (joint instanceof OneDoFJointBasics) {
            this.doubleIntegrateFromAcceleration((OneDoFJointBasics)joint);
        } else if (joint instanceof FloatingJointBasics) {
            this.doubleIntegrateFromAcceleration((FloatingJointBasics)joint);
        } else if (joint instanceof SphericalJointBasics) {
            this.doubleIntegrateFromAcceleration((SphericalJointBasics)joint);
        } else {
            if (joint instanceof FixedJointBasics) {
                return;
            }
            throw new UnsupportedOperationException("Integrator does not support the joint type: " + joint.getClass().getSimpleName());
        }
    }

    public void doubleIntegrateFromAcceleration(FloatingJointBasics joint) {
        this.doubleIntegrate(joint.getJointAcceleration(), joint.getJointTwist(), joint.getJointPose());
    }

    public void doubleIntegrateFromAcceleration(OneDoFJointBasics joint) {
        double initialQ = joint.getQ();
        double initialQd = joint.getQd();
        double qdd = joint.getQdd();
        joint.setQ(this.doubleIntegratePosition(qdd, initialQd, initialQ));
        joint.setQd(this.integrateVelocity(qdd, initialQd));
    }

    public void doubleIntegrateFromAcceleration(SphericalJointBasics joint) {
        this.doubleIntegrate((Vector3DReadOnly)joint.getJointAngularAcceleration(), (Vector3DBasics)joint.getJointAngularVelocity(), (Orientation3DBasics)joint.getJointOrientation());
    }

    public void doubleIntegrate(FixedFrameSpatialAccelerationBasics spatialAcceleration, FixedFrameTwistBasics twistToIntegrate, Pose3DBasics poseToIntegrate) {
        this.doubleIntegrate(spatialAcceleration, twistToIntegrate, (Pose3DReadOnly)poseToIntegrate, twistToIntegrate, poseToIntegrate);
    }

    public void doubleIntegrate(FixedFrameSpatialAccelerationBasics spatialAcceleration, TwistReadOnly initialTwist, Pose3DReadOnly initialPose, FixedFrameTwistBasics finalTwist, Pose3DBasics finalPose) {
        spatialAcceleration.checkReferenceFrameMatch(initialTwist);
        spatialAcceleration.checkExpressedInFrameMatch(spatialAcceleration.getBodyFrame());
        if (finalTwist != initialTwist) {
            finalTwist.checkReferenceFrameMatch(initialTwist);
        }
        QuaternionReadOnly initialOrientation = initialPose.getOrientation();
        QuaternionBasics finalOrientation = finalPose.getOrientation();
        Point3DReadOnly initialPosition = initialPose.getPosition();
        Point3DBasics finalPosition = finalPose.getPosition();
        FrameVector3DReadOnly initialAngularVelocity = initialTwist.getAngularPart();
        FixedFrameVector3DBasics finalAngularVelocity = finalTwist.getAngularPart();
        FrameVector3DReadOnly initialLinearVelocity = initialTwist.getLinearPart();
        FixedFrameVector3DBasics finalLinearVelocity = finalTwist.getLinearPart();
        FixedFrameVector3DBasics angularAcceleration = spatialAcceleration.getAngularPart();
        spatialAcceleration.getLinearAccelerationAtBodyOrigin(initialTwist, (FrameVector3DBasics)this.linearAcceleration);
        this.rotationVector.setAndScale(this.dt, (Tuple3DReadOnly)initialAngularVelocity);
        this.rotationVector.scaleAdd(this.half_dt_dt, (Tuple3DReadOnly)angularAcceleration, (Tuple3DReadOnly)this.rotationVector);
        this.integrated.setRotationVector((Vector3DReadOnly)this.rotationVector);
        if (finalAngularVelocity != null) {
            finalAngularVelocity.scaleAdd(this.dt, (FrameTuple3DReadOnly)angularAcceleration, (FrameTuple3DReadOnly)initialAngularVelocity);
        }
        if (finalPosition != null) {
            this.deltaPosition.setAndScale(this.dt, (Tuple3DReadOnly)initialLinearVelocity);
            this.deltaPosition.scaleAdd(this.half_dt_dt, (Tuple3DReadOnly)this.linearAcceleration, (Tuple3DReadOnly)this.deltaPosition);
            if (initialOrientation != null) {
                initialOrientation.transform((Tuple3DBasics)this.deltaPosition);
            }
            finalPosition.add((Tuple3DReadOnly)initialPosition, (Tuple3DReadOnly)this.deltaPosition);
        }
        if (finalLinearVelocity != null) {
            finalLinearVelocity.scaleAdd(this.dt, (FrameTuple3DReadOnly)this.linearAcceleration, (FrameTuple3DReadOnly)initialLinearVelocity);
            this.integrated.inverseTransform((Tuple3DBasics)finalLinearVelocity);
        }
        if (finalOrientation != null) {
            if (finalOrientation != initialOrientation) {
                finalOrientation.set(initialOrientation);
            }
            finalOrientation.append((Orientation3DReadOnly)this.integrated);
        }
        this.integrated.inverseTransform((Tuple3DBasics)this.linearAcceleration);
        spatialAcceleration.setBasedOnOriginAcceleration((FrameVector3DReadOnly)angularAcceleration, (FrameVector3DReadOnly)this.linearAcceleration, finalTwist);
    }

    public void doubleIntegrate(Vector3DReadOnly angularAcceleration, Vector3DBasics angularVelocityToIntegrate, Orientation3DBasics orientationToIntegrate) {
        this.doubleIntegrate(angularAcceleration, (Vector3DReadOnly)angularVelocityToIntegrate, (Orientation3DReadOnly)orientationToIntegrate, angularVelocityToIntegrate, orientationToIntegrate);
    }

    public void doubleIntegrate(Vector3DReadOnly angularAcceleration, Vector3DReadOnly initialAngularVelocity, Orientation3DReadOnly initialOrientation, Vector3DBasics finalAngularVelocity, Orientation3DBasics finalOrientation) {
        if (finalOrientation != null) {
            this.rotationVector.setAndScale(this.dt, (Tuple3DReadOnly)initialAngularVelocity);
            this.rotationVector.scaleAdd(this.half_dt_dt, (Tuple3DReadOnly)angularAcceleration, (Tuple3DReadOnly)this.rotationVector);
            this.integrated.setRotationVector((Vector3DReadOnly)this.rotationVector);
            finalOrientation.set(initialOrientation);
            finalOrientation.append((Orientation3DReadOnly)this.integrated);
        }
        if (finalAngularVelocity != null) {
            finalAngularVelocity.scaleAdd(this.dt, (Tuple3DReadOnly)angularAcceleration, (Tuple3DReadOnly)initialAngularVelocity);
        }
    }

    @Deprecated
    public void doubleIntegrate(Orientation3DReadOnly orientation, Vector3DReadOnly linearAcceleration, Vector3DBasics linearVelocityToIntegrate, Tuple3DBasics positionToIntegrate) {
        this.doubleIntegrate(orientation, linearAcceleration, (Vector3DReadOnly)linearVelocityToIntegrate, (Tuple3DReadOnly)positionToIntegrate, linearVelocityToIntegrate, positionToIntegrate);
    }

    @Deprecated
    public void doubleIntegrate(Orientation3DReadOnly orientation, Vector3DReadOnly linearAcceleration, Vector3DReadOnly initialLinearVelocity, Tuple3DReadOnly initialPosition, Vector3DBasics finalLinearVelocity, Tuple3DBasics finalPosition) {
        if (finalPosition != null) {
            this.deltaPosition.setAndScale(this.dt, (Tuple3DReadOnly)initialLinearVelocity);
            this.deltaPosition.scaleAdd(this.half_dt_dt, (Tuple3DReadOnly)linearAcceleration, (Tuple3DReadOnly)this.deltaPosition);
            if (orientation != null) {
                orientation.transform((Tuple3DBasics)this.deltaPosition);
            }
            finalPosition.add(initialPosition, (Tuple3DReadOnly)this.deltaPosition);
        }
        if (finalLinearVelocity != null) {
            finalLinearVelocity.scaleAdd(this.dt, (Tuple3DReadOnly)linearAcceleration, (Tuple3DReadOnly)initialLinearVelocity);
        }
    }

    public double doubleIntegratePosition(double acceleration, double initialVelocity, double initialPosition) {
        return this.half_dt_dt * acceleration + this.dt * initialVelocity + initialPosition;
    }

    public double integrateVelocity(double acceleration, double initialVelocity) {
        return this.dt * acceleration + initialVelocity;
    }
}

