/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoTools;

public interface FixedFrameSpatialVectorBasics
extends SpatialVectorReadOnly,
Clearable,
Transformable {
    public FixedFrameVector3DBasics getAngularPart();

    public FixedFrameVector3DBasics getLinearPart();

    default public void setToZero() {
        this.getAngularPart().setToZero();
        this.getLinearPart().setToZero();
    }

    default public void setToNaN() {
        this.getAngularPart().setToNaN();
        this.getLinearPart().setToNaN();
    }

    @Override
    default public boolean containsNaN() {
        return SpatialVectorReadOnly.super.containsNaN();
    }

    default public void setAngularPartX(double x) {
        this.getAngularPart().setX(x);
    }

    default public void setAngularPartY(double y) {
        this.getAngularPart().setY(y);
    }

    default public void setAngularPartZ(double z) {
        this.getAngularPart().setZ(z);
    }

    default public void setLinearPartX(double x) {
        this.getLinearPart().setX(x);
    }

    default public void setLinearPartY(double y) {
        this.getLinearPart().setY(y);
    }

    default public void setLinearPartZ(double z) {
        this.getLinearPart().setZ(z);
    }

    default public void setElement(int index, double value) {
        switch (index) {
            case 0: {
                this.setAngularPartX(value);
                break;
            }
            case 1: {
                this.setAngularPartY(value);
                break;
            }
            case 2: {
                this.setAngularPartZ(value);
                break;
            }
            case 3: {
                this.setLinearPartX(value);
                break;
            }
            case 4: {
                this.setLinearPartY(value);
                break;
            }
            case 5: {
                this.setLinearPartZ(value);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
        }
    }

    default public void set(double[] array) {
        this.set(0, array);
    }

    default public void set(int startIndex, double[] array) {
        this.getAngularPart().set(startIndex, array);
        this.getLinearPart().set(startIndex + 3, array);
    }

    default public void set(float[] array) {
        this.set(0, array);
    }

    default public void set(int startIndex, float[] array) {
        this.getAngularPart().set(startIndex, array);
        this.getLinearPart().set(startIndex + 3, array);
    }

    default public void set(DMatrix matrix) {
        this.set(0, matrix);
    }

    default public void set(int startRow, DMatrix matrix) {
        this.set(startRow, 0, matrix);
    }

    default public void set(int startRow, int column, DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize((int)(startRow + 6), (int)(column + 1), (Matrix)matrix);
        this.getAngularPart().set(matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column));
        this.getLinearPart().set(matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column));
    }

    default public void set(Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.getAngularPart().set((Tuple3DReadOnly)angularPart);
        this.getLinearPart().set((Tuple3DReadOnly)linearPart);
    }

    default public void set(SpatialVectorReadOnly other) {
        this.set(other.getReferenceFrame(), (Vector3DReadOnly)other.getAngularPart(), (Vector3DReadOnly)other.getLinearPart());
    }

    default public void setMatchingFrame(SpatialVectorReadOnly other) {
        this.getAngularPart().set((Tuple3DReadOnly)other.getAngularPart());
        this.getLinearPart().set((Tuple3DReadOnly)other.getLinearPart());
        other.getReferenceFrame().transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart) {
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
        this.getAngularPart().set((Tuple3DReadOnly)angularPart);
        this.getLinearPart().set((Tuple3DReadOnly)linearPart);
        angularPart.getReferenceFrame().transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void set(FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart) {
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
        this.set(angularPart.getReferenceFrame(), (Vector3DReadOnly)angularPart, (Vector3DReadOnly)linearPart);
    }

    default public void set(ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.checkReferenceFrameMatch(expressedInFrame);
        this.set(angularPart, linearPart);
    }

    default public void scale(double scalar) {
        this.getAngularPart().scale(scalar);
        this.getLinearPart().scale(scalar);
    }

    default public void negate() {
        this.getAngularPart().negate();
        this.getLinearPart().negate();
    }

    default public void normalize() {
        this.scale(1.0 / this.length());
    }

    default public void add(SpatialVectorReadOnly other) {
        this.checkReferenceFrameMatch(other);
        this.add((Vector3DReadOnly)other.getAngularPart(), (Vector3DReadOnly)other.getLinearPart());
    }

    default public void add(SpatialVectorReadOnly vector1, SpatialVectorReadOnly vector2) {
        this.checkReferenceFrameMatch(vector1, vector2);
        this.getAngularPart().add((Tuple3DReadOnly)vector1.getAngularPart(), (Tuple3DReadOnly)vector2.getAngularPart());
        this.getLinearPart().add((Tuple3DReadOnly)vector1.getLinearPart(), (Tuple3DReadOnly)vector2.getLinearPart());
    }

    default public void add(DMatrix matrix) {
        this.add(0, matrix);
    }

    default public void add(int startRow, DMatrix matrix) {
        this.add(startRow, 0, matrix);
    }

    default public void add(int startRow, int column, DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize((int)(startRow + 6), (int)(column + 1), (Matrix)matrix);
        this.getAngularPart().add(matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column));
        this.getLinearPart().add(matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column));
    }

    default public void add(Vector3DReadOnly angular, Vector3DReadOnly linear) {
        this.getAngularPart().add((Tuple3DReadOnly)angular);
        this.getLinearPart().add((Tuple3DReadOnly)linear);
    }

    default public void add(FrameVector3DReadOnly angular, FrameVector3DReadOnly linear) {
        this.getAngularPart().add((FrameTuple3DReadOnly)angular);
        this.getLinearPart().add((FrameTuple3DReadOnly)linear);
    }

    default public void sub(SpatialVectorReadOnly other) {
        this.checkReferenceFrameMatch(other);
        this.sub((Vector3DReadOnly)other.getAngularPart(), (Vector3DReadOnly)other.getLinearPart());
    }

    default public void sub(SpatialVectorReadOnly vector1, SpatialVectorReadOnly vector2) {
        this.checkReferenceFrameMatch(vector1, vector2);
        this.getAngularPart().sub((Tuple3DReadOnly)vector1.getAngularPart(), (Tuple3DReadOnly)vector2.getAngularPart());
        this.getLinearPart().sub((Tuple3DReadOnly)vector1.getLinearPart(), (Tuple3DReadOnly)vector2.getLinearPart());
    }

    default public void sub(DMatrix matrix) {
        this.sub(0, matrix);
    }

    default public void sub(int startRow, DMatrix matrix) {
        this.sub(startRow, 0, matrix);
    }

    default public void sub(int startRow, int column, DMatrix matrix) {
        EuclidCoreTools.checkMatrixMinimumSize((int)(startRow + 6), (int)(column + 1), (Matrix)matrix);
        this.getAngularPart().sub(matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column));
        this.getLinearPart().sub(matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column), matrix.unsafe_get(startRow++, column));
    }

    default public void sub(Vector3DReadOnly angular, Vector3DReadOnly linear) {
        this.getAngularPart().sub((Tuple3DReadOnly)angular);
        this.getLinearPart().sub((Tuple3DReadOnly)linear);
    }

    default public void sub(FrameVector3DReadOnly angular, FrameVector3DReadOnly linear) {
        this.getAngularPart().sub((FrameTuple3DReadOnly)angular);
        this.getLinearPart().sub((FrameTuple3DReadOnly)linear);
    }

    default public void interpolate(SpatialVectorReadOnly other, double alpha) {
        this.interpolate(this, other, alpha);
    }

    default public void interpolate(SpatialVectorReadOnly vector1, SpatialVectorReadOnly vector2, double alpha) {
        this.checkReferenceFrameMatch(vector1, vector2);
        this.getAngularPart().interpolate((Tuple3DReadOnly)vector1.getAngularPart(), (Tuple3DReadOnly)vector2.getAngularPart(), alpha);
        this.getLinearPart().interpolate((Tuple3DReadOnly)vector1.getLinearPart(), (Tuple3DReadOnly)vector2.getLinearPart(), alpha);
    }

    default public void addCrossToAngularPart(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        MecanoTools.addCrossToVector(tuple1, tuple2, (Vector3DBasics)this.getAngularPart());
    }

    default public void addCrossToLinearPart(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        MecanoTools.addCrossToVector(tuple1, tuple2, (Vector3DBasics)this.getLinearPart());
    }

    default public void applyTransform(Transform transform) {
        this.getAngularPart().applyTransform(transform);
        this.getLinearPart().applyTransform(transform);
    }

    default public void applyInverseTransform(Transform transform) {
        this.getAngularPart().applyInverseTransform(transform);
        this.getLinearPart().applyInverseTransform(transform);
    }
}

