/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;

public interface SphericalJointReadOnly
extends JointReadOnly {
    public static final int NUMBER_OF_DOFS = 3;

    public QuaternionReadOnly getJointOrientation();

    public FrameVector3DReadOnly getJointAngularVelocity();

    public FrameVector3DReadOnly getJointAngularAcceleration();

    public FrameVector3DReadOnly getJointTorque();

    @Override
    default public void getJointConfiguration(RigidBodyTransform jointTransform) {
        jointTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)this.getJointOrientation());
    }

    @Override
    default public int getJointConfiguration(int rowStart, DMatrix matrix) {
        this.getJointOrientation().get(rowStart, matrix);
        return rowStart + this.getConfigurationMatrixSize();
    }

    @Override
    default public int getJointVelocity(int rowStart, DMatrix matrixToPack) {
        this.getJointTwist().getAngularPart().get(rowStart, matrixToPack);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getJointAcceleration(int rowStart, DMatrix matrixToPack) {
        this.getJointAcceleration().getAngularPart().get(rowStart, matrixToPack);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getJointTau(int rowStart, DMatrix matrixToPack) {
        this.getJointWrench().getAngularPart().get(rowStart, matrixToPack);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getDegreesOfFreedom() {
        return 3;
    }

    @Override
    default public int getConfigurationMatrixSize() {
        return 4;
    }
}

