/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.dense.row.misc.UnrolledInverseFromMinor_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.ArticulatedBodyInertia;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class ForwardDynamicsCalculator {
    private final MultiBodySystemReadOnly input;
    private final ArticulatedBodyRecursionStep initialRecursionStep;
    private final Map<RigidBodyReadOnly, ArticulatedBodyRecursionStep> rigidBodyToRecursionStepMap = new LinkedHashMap<RigidBodyReadOnly, ArticulatedBodyRecursionStep>();
    private final DMatrixRMaj jointTauMatrix;
    private final DMatrixRMaj jointAccelerationMatrix;
    private final RigidBodyAccelerationProvider accelerationProvider;
    private final RigidBodyAccelerationProvider zeroVelocityAccelerationProvider;

    public ForwardDynamicsCalculator(RigidBodyReadOnly rootBody) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput(rootBody));
    }

    public ForwardDynamicsCalculator(MultiBodySystemReadOnly input) {
        this(input, true);
    }

    public ForwardDynamicsCalculator(MultiBodySystemReadOnly input, boolean considerIgnoredSubtreesInertia) {
        this.input = input;
        RigidBodyReadOnly rootBody = input.getRootBody();
        this.initialRecursionStep = new ArticulatedBodyRecursionStep(rootBody, null, null);
        this.rigidBodyToRecursionStepMap.put(rootBody, this.initialRecursionStep);
        this.buildMultiBodyTree(this.initialRecursionStep, input.getJointsToIgnore());
        if (considerIgnoredSubtreesInertia) {
            this.initialRecursionStep.includeIgnoredSubtreeInertia();
        }
        int nDoFs = MultiBodySystemTools.computeDegreesOfFreedom(input.getJointsToConsider());
        this.jointTauMatrix = new DMatrixRMaj(nDoFs, 1);
        this.jointAccelerationMatrix = new DMatrixRMaj(nDoFs, 1);
        Function<RigidBodyReadOnly, SpatialAccelerationReadOnly> accelerationFunction = body -> {
            ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(body);
            if (recursionStep == null) {
                return null;
            }
            recursionStep.rigidBodyAcceleration.changeFrame(body.getBodyFixedFrame());
            return recursionStep.rigidBodyAcceleration;
        };
        this.accelerationProvider = RigidBodyAccelerationProvider.toRigidBodyAccelerationProvider(accelerationFunction, input.getInertialFrame());
        Function<RigidBodyReadOnly, SpatialAccelerationReadOnly> zeroVelocityAccelerationFunction = body -> {
            ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(body);
            if (recursionStep == null) {
                return null;
            }
            recursionStep.rigidBodyZeroVelocityAcceleration.changeFrame(body.getBodyFixedFrame());
            return recursionStep.rigidBodyZeroVelocityAcceleration;
        };
        this.zeroVelocityAccelerationProvider = RigidBodyAccelerationProvider.toRigidBodyAccelerationProvider(zeroVelocityAccelerationFunction, input.getInertialFrame(), false, true);
    }

    /*
     * WARNING - void declaration
     */
    private void buildMultiBodyTree(ArticulatedBodyRecursionStep parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        ArrayList<? extends JointReadOnly> childrenJoints = new ArrayList<JointReadOnly>(parent.rigidBody.getChildrenJoints());
        if (childrenJoints.size() > 1) {
            void var5_6;
            ArrayList loopClosureAncestors = new ArrayList();
            boolean bl = false;
            while (var5_6 < childrenJoints.size()) {
                if (MultiBodySystemTools.doesSubtreeContainLoopClosure(((JointReadOnly)childrenJoints.get((int)var5_6)).getSuccessor())) {
                    loopClosureAncestors.add(childrenJoints.remove((int)var5_6));
                    continue;
                }
                ++var5_6;
            }
            childrenJoints.addAll(loopClosureAncestors);
        }
        for (JointReadOnly jointReadOnly : childrenJoints) {
            if (jointsToIgnore.contains(jointReadOnly)) continue;
            if (jointReadOnly.isLoopClosure()) {
                throw new UnsupportedOperationException("This calculator does not support kinematic loops.");
            }
            RigidBodyReadOnly childBody = jointReadOnly.getSuccessor();
            if (childBody == null) continue;
            int[] jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(jointReadOnly);
            ArticulatedBodyRecursionStep child = new ArticulatedBodyRecursionStep(childBody, parent, jointIndices);
            this.rigidBodyToRecursionStepMap.put(childBody, child);
            this.buildMultiBodyTree(child, jointsToIgnore);
        }
    }

    public void setGravitionalAcceleration(FrameTuple3DReadOnly gravity) {
        gravity.checkReferenceFrameMatch(this.input.getInertialFrame());
        this.setGravitionalAcceleration((Tuple3DReadOnly)gravity);
    }

    public void setGravitionalAcceleration(Tuple3DReadOnly gravity) {
        SpatialAcceleration rootAcceleration = this.initialRecursionStep.rigidBodyAcceleration;
        rootAcceleration.setToZero();
        rootAcceleration.getLinearPart().setAndNegate(gravity);
    }

    public void setGravitionalAcceleration(double gravity) {
        this.setGravitionalAcceleration(0.0, 0.0, gravity);
    }

    public void setGravitionalAcceleration(double gravityX, double gravityY, double gravityZ) {
        SpatialAcceleration rootAcceleration = this.initialRecursionStep.rigidBodyAcceleration;
        rootAcceleration.setToZero();
        rootAcceleration.getLinearPart().set(gravityX, gravityY, gravityZ);
        rootAcceleration.negate();
    }

    public void setRootAcceleration(SpatialAccelerationReadOnly newRootAcceleration) {
        this.initialRecursionStep.rigidBodyAcceleration.set(newRootAcceleration);
    }

    public void setExternalWrenchesToZero() {
        this.initialRecursionStep.setExternalWrenchToZeroRecursive();
    }

    public FixedFrameWrenchBasics getExternalWrench(RigidBodyReadOnly rigidBody) {
        ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(rigidBody);
        return recursionStep == null ? null : recursionStep.externalWrench;
    }

    public void setExternalWrench(RigidBodyReadOnly rigidBody, WrenchReadOnly externalWrench) {
        this.rigidBodyToRecursionStepMap.get((Object)rigidBody).externalWrench.setMatchingFrame(externalWrench);
    }

    public void compute() {
        this.compute(null);
    }

    public void compute(DMatrix jointTauMatrix) {
        if (jointTauMatrix != null) {
            this.jointTauMatrix.set((Matrix)jointTauMatrix);
        } else {
            List<? extends JointReadOnly> indexedJointsInOrder = this.input.getJointMatrixIndexProvider().getIndexedJointsInOrder();
            MultiBodySystemTools.extractJointsState(indexedJointsInOrder, JointStateType.EFFORT, (DMatrix)this.jointTauMatrix);
        }
        this.initialRecursionStep.passOne();
        this.initialRecursionStep.passTwo();
        this.initialRecursionStep.passThree();
    }

    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    public DMatrixRMaj getJointAccelerationMatrix() {
        return this.jointAccelerationMatrix;
    }

    public DMatrixRMaj getComputedJointAcceleration(JointReadOnly joint) {
        ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(joint.getSuccessor());
        if (recursionStep == null) {
            return null;
        }
        return recursionStep.qdd;
    }

    ArticulatedBodyRecursionStep getInitialRecursionStep() {
        return this.initialRecursionStep;
    }

    public void writeComputedJointAccelerations(JointBasics[] joints) {
        for (JointBasics joint : joints) {
            this.writeComputedJointAcceleration(joint);
        }
    }

    public void writeComputedJointAccelerations(List<? extends JointBasics> joints) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            this.writeComputedJointAcceleration(joints.get(jointIndex));
        }
    }

    public boolean writeComputedJointAcceleration(JointBasics joint) {
        ArticulatedBodyRecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(joint.getSuccessor());
        if (recursionStep == null) {
            return false;
        }
        joint.setJointAcceleration(0, (DMatrix)recursionStep.qdd);
        return true;
    }

    public RigidBodyAccelerationProvider getAccelerationProvider() {
        return this.accelerationProvider;
    }

    public RigidBodyAccelerationProvider getAccelerationProvider(boolean considerVelocities) {
        return considerVelocities ? this.accelerationProvider : this.zeroVelocityAccelerationProvider;
    }

    class ArticulatedBodyRecursionStep {
        final RigidBodyReadOnly rigidBody;
        final SpatialInertia bodyInertia;
        final Wrench externalWrench;
        final SpatialAcceleration biasAcceleration;
        final Wrench biasWrench;
        final SpatialInertia spatialInertia;
        final ArticulatedBodyInertia articulatedInertia;
        final SpatialForce articulatedBiasWrench;
        final ArticulatedBodyInertia articulatedInertiaForParent;
        final SpatialForce articulatedBiasWrenchForParent;
        final SpatialAcceleration rigidBodyAcceleration = new SpatialAcceleration();
        final SpatialAcceleration rigidBodyZeroVelocityAcceleration = new SpatialAcceleration();
        final DMatrixRMaj IA;
        final DMatrixRMaj S;
        final DMatrixRMaj U;
        final DMatrixRMaj D;
        final DMatrixRMaj Dinv;
        final DMatrixRMaj U_Dinv;
        final DMatrixRMaj U_Dinv_UT;
        final DMatrixRMaj Ia;
        final DMatrixRMaj tau;
        final DMatrixRMaj pA;
        final DMatrixRMaj u;
        final DMatrixRMaj c;
        final DMatrixRMaj pa;
        final DMatrixRMaj aPrime;
        final DMatrixRMaj a;
        final DMatrixRMaj qdd_intermediate;
        final DMatrixRMaj qdd;
        final ArticulatedBodyRecursionStep parent;
        final List<ArticulatedBodyRecursionStep> children = new ArrayList<ArticulatedBodyRecursionStep>();
        final LinearSolverDense<DMatrixRMaj> inverseSolver;
        final RigidBodyTransform transformToParentJointFrame;
        final int[] jointIndices;

        private ArticulatedBodyRecursionStep(RigidBodyReadOnly rigidBody, ArticulatedBodyRecursionStep parent, int[] jointIndices) {
            this.rigidBody = rigidBody;
            this.parent = parent;
            this.jointIndices = jointIndices;
            this.externalWrench = new Wrench((ReferenceFrame)this.getBodyFixedFrame(), this.getBodyFixedFrame());
            if (parent == null) {
                this.bodyInertia = null;
                this.biasAcceleration = null;
                this.biasWrench = null;
                this.spatialInertia = null;
                this.articulatedInertia = null;
                this.articulatedBiasWrench = null;
                this.articulatedInertiaForParent = null;
                this.articulatedBiasWrenchForParent = null;
                this.rigidBodyAcceleration.setToZero(this.getBodyFixedFrame(), ForwardDynamicsCalculator.this.input.getInertialFrame(), this.getBodyFixedFrame());
                this.rigidBodyZeroVelocityAcceleration.setToZero(this.getBodyFixedFrame(), ForwardDynamicsCalculator.this.input.getInertialFrame(), this.getBodyFixedFrame());
                this.IA = null;
                this.S = null;
                this.U = null;
                this.D = null;
                this.Dinv = null;
                this.U_Dinv = null;
                this.U_Dinv_UT = null;
                this.tau = null;
                this.pA = null;
                this.u = null;
                this.c = null;
                this.pa = null;
                this.Ia = null;
                this.qdd = null;
                this.qdd_intermediate = null;
                this.aPrime = null;
                this.a = null;
                this.inverseSolver = null;
                this.transformToParentJointFrame = null;
            } else {
                parent.children.add(this);
                int nDoFs = this.getJoint().getDegreesOfFreedom();
                this.bodyInertia = new SpatialInertia(rigidBody.getInertia());
                this.biasAcceleration = new SpatialAcceleration();
                this.biasWrench = new Wrench();
                this.spatialInertia = new SpatialInertia();
                this.articulatedInertia = new ArticulatedBodyInertia();
                this.articulatedBiasWrench = new SpatialForce();
                this.articulatedInertiaForParent = parent.isRoot() ? null : new ArticulatedBodyInertia();
                this.articulatedBiasWrenchForParent = parent.isRoot() ? null : new SpatialForce();
                this.IA = new DMatrixRMaj(6, 6);
                this.S = new DMatrixRMaj(6, nDoFs);
                this.U = new DMatrixRMaj(6, nDoFs);
                this.D = new DMatrixRMaj(nDoFs, nDoFs);
                this.Dinv = new DMatrixRMaj(nDoFs, nDoFs);
                this.U_Dinv = new DMatrixRMaj(6, nDoFs);
                this.U_Dinv_UT = new DMatrixRMaj(6, 6);
                this.tau = new DMatrixRMaj(nDoFs, 1);
                this.pA = new DMatrixRMaj(6, 1);
                this.u = new DMatrixRMaj(nDoFs, 1);
                this.c = new DMatrixRMaj(6, 1);
                this.pa = new DMatrixRMaj(6, 1);
                this.Ia = new DMatrixRMaj(6, 6);
                this.qdd = new DMatrixRMaj(nDoFs, 1);
                this.qdd_intermediate = new DMatrixRMaj(nDoFs, 1);
                this.aPrime = new DMatrixRMaj(6, 1);
                this.a = new DMatrixRMaj(6, 1);
                this.inverseSolver = nDoFs == 6 ? LinearSolverFactory_DDRM.symmPosDef((int)6) : null;
                this.transformToParentJointFrame = new RigidBodyTransform();
                if (!this.getJoint().isMotionSubspaceVariable()) {
                    this.getJoint().getMotionSubspace((DMatrix1Row)this.S);
                }
            }
        }

        public void includeIgnoredSubtreeInertia() {
            if (!this.isRoot() && this.children.size() != this.rigidBody.getChildrenJoints().size()) {
                for (JointReadOnly jointReadOnly : this.rigidBody.getChildrenJoints()) {
                    if (!ForwardDynamicsCalculator.this.input.getJointsToIgnore().contains(jointReadOnly)) continue;
                    SpatialInertia subtreeIneria = MultiBodySystemTools.computeSubtreeInertia(jointReadOnly);
                    subtreeIneria.changeFrame(this.getBodyFixedFrame());
                    this.bodyInertia.add(subtreeIneria);
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).includeIgnoredSubtreeInertia();
            }
        }

        public void passOne() {
            if (this.isRoot()) {
                this.rigidBodyZeroVelocityAcceleration.setIncludingFrame(this.rigidBodyAcceleration);
            } else {
                MovingReferenceFrame frameAfterJoint = this.getFrameAfterJoint();
                MovingReferenceFrame frameBeforeJoint = this.getJoint().getFrameBeforeJoint();
                if (this.parent.isRoot()) {
                    frameAfterJoint.getTransformToDesiredFrame(this.transformToParentJointFrame, this.parent.getBodyFixedFrame());
                } else {
                    frameAfterJoint.getTransformToDesiredFrame(this.transformToParentJointFrame, this.parent.getFrameAfterJoint());
                }
                this.bodyInertia.computeDynamicWrench(null, this.getBodyTwist(), this.biasWrench);
                this.biasWrench.sub(this.externalWrench);
                this.biasWrench.changeFrame(frameAfterJoint);
                this.biasAcceleration.setToZero(frameAfterJoint, ForwardDynamicsCalculator.this.input.getInertialFrame(), frameBeforeJoint);
                this.biasAcceleration.changeFrame(frameAfterJoint, this.getJoint().getJointTwist(), frameAfterJoint.getTwistOfFrame());
                if (this.getJoint().isMotionSubspaceVariable()) {
                    this.biasAcceleration.add(this.getJoint().getJointBiasAcceleration());
                }
                this.biasAcceleration.get((DMatrix)this.c);
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).passOne();
            }
        }

        public void passTwo() {
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).passTwo();
            }
            if (this.isRoot()) {
                return;
            }
            MovingReferenceFrame frameAfterJoint = this.getFrameAfterJoint();
            this.spatialInertia.setIncludingFrame(this.bodyInertia);
            this.spatialInertia.changeFrame(frameAfterJoint);
            this.articulatedInertia.setIncludingFrame(this.spatialInertia);
            this.articulatedBiasWrench.setIncludingFrame(this.biasWrench);
            this.articulatedBiasWrench.changeFrame(frameAfterJoint);
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                ArticulatedBodyRecursionStep child = this.children.get(childIndex);
                child.articulatedInertiaForParent.applyTransform(child.transformToParentJointFrame);
                child.articulatedBiasWrenchForParent.applyTransform((RigidBodyTransformReadOnly)child.transformToParentJointFrame);
                child.articulatedInertiaForParent.setReferenceFrame(frameAfterJoint);
                child.articulatedBiasWrenchForParent.setReferenceFrame(frameAfterJoint);
                this.articulatedInertia.add(child.articulatedInertiaForParent);
                this.articulatedBiasWrench.add(child.articulatedBiasWrenchForParent);
            }
            if (this.getJoint().isMotionSubspaceVariable()) {
                this.getJoint().getMotionSubspace((DMatrix1Row)this.S);
            }
            this.articulatedInertia.get((DMatrix)this.IA);
            CommonOps_DDRM.mult((DMatrix1Row)this.IA, (DMatrix1Row)this.S, (DMatrix1Row)this.U);
            CommonOps_DDRM.multTransA((DMatrix1Row)this.S, (DMatrix1Row)this.U, (DMatrix1Row)this.D);
            int nDoFs = this.getJoint().getDegreesOfFreedom();
            if (nDoFs == 1) {
                this.Dinv.set(0, 1.0 / this.D.get(0));
            } else if (nDoFs == 0) {
                this.Dinv.reshape(0, 0);
            } else if (nDoFs <= 5) {
                UnrolledInverseFromMinor_DDRM.inv((DMatrixRMaj)this.D, (DMatrixRMaj)this.Dinv);
            } else {
                this.inverseSolver.setA((Matrix)this.D);
                this.inverseSolver.invert((Matrix)this.Dinv);
            }
            for (int dofIndex = 0; dofIndex < nDoFs; ++dofIndex) {
                this.tau.set(dofIndex, 0, ForwardDynamicsCalculator.this.jointTauMatrix.get(this.jointIndices[dofIndex], 0));
            }
            this.articulatedBiasWrench.get((DMatrix)this.pA);
            CommonOps_DDRM.multTransA((double)-1.0, (DMatrix1Row)this.S, (DMatrix1Row)this.pA, (DMatrix1Row)this.u);
            CommonOps_DDRM.addEquals((DMatrixD1)this.u, (DMatrixD1)this.tau);
            if (!this.parent.isRoot()) {
                CommonOps_DDRM.mult((DMatrix1Row)this.U, (DMatrix1Row)this.Dinv, (DMatrix1Row)this.U_Dinv);
                CommonOps_DDRM.multTransB((DMatrix1Row)this.U_Dinv, (DMatrix1Row)this.U, (DMatrix1Row)this.U_Dinv_UT);
                this.articulatedInertiaForParent.setIncludingFrame(this.articulatedInertia);
                this.articulatedInertiaForParent.sub((DMatrix)this.U_Dinv_UT);
                this.articulatedInertiaForParent.get((DMatrix)this.Ia);
                this.articulatedBiasWrench.get((DMatrix)this.pa);
                CommonOps_DDRM.multAdd((DMatrix1Row)this.Ia, (DMatrix1Row)this.c, (DMatrix1Row)this.pa);
                CommonOps_DDRM.multAdd((DMatrix1Row)this.U_Dinv, (DMatrix1Row)this.u, (DMatrix1Row)this.pa);
                this.articulatedBiasWrenchForParent.setIncludingFrame(frameAfterJoint, (DMatrix)this.pa);
            }
        }

        public void passThree() {
            if (!this.isRoot()) {
                this.rigidBodyZeroVelocityAcceleration.setIncludingFrame(this.parent.rigidBodyZeroVelocityAcceleration);
                this.rigidBodyZeroVelocityAcceleration.applyInverseTransform((RigidBodyTransformReadOnly)this.transformToParentJointFrame);
                this.rigidBodyZeroVelocityAcceleration.setBodyFrame(this.getBodyFixedFrame());
                this.rigidBodyZeroVelocityAcceleration.setBaseFrame(ForwardDynamicsCalculator.this.input.getInertialFrame());
                this.rigidBodyZeroVelocityAcceleration.setReferenceFrame(this.getFrameAfterJoint());
                this.rigidBodyAcceleration.setIncludingFrame(this.parent.rigidBodyAcceleration);
                this.rigidBodyAcceleration.applyInverseTransform((RigidBodyTransformReadOnly)this.transformToParentJointFrame);
                this.rigidBodyAcceleration.setReferenceFrame(this.getFrameAfterJoint());
                this.rigidBodyAcceleration.add(this.biasAcceleration);
                this.rigidBodyAcceleration.get((DMatrix)this.aPrime);
                CommonOps_DDRM.multTransA((double)-1.0, (DMatrix1Row)this.U, (DMatrix1Row)this.aPrime, (DMatrix1Row)this.qdd_intermediate);
                CommonOps_DDRM.addEquals((DMatrixD1)this.qdd_intermediate, (DMatrixD1)this.u);
                CommonOps_DDRM.mult((DMatrix1Row)this.Dinv, (DMatrix1Row)this.qdd_intermediate, (DMatrix1Row)this.qdd);
                CommonOps_DDRM.mult((DMatrix1Row)this.S, (DMatrix1Row)this.qdd, (DMatrix1Row)this.a);
                this.rigidBodyZeroVelocityAcceleration.add((DMatrix)this.a);
                CommonOps_DDRM.addEquals((DMatrixD1)this.a, (DMatrixD1)this.aPrime);
                this.rigidBodyAcceleration.setIncludingFrame(this.getBodyFixedFrame(), ForwardDynamicsCalculator.this.input.getInertialFrame(), this.getFrameAfterJoint(), (DMatrix)this.a);
                for (int dofIndex = 0; dofIndex < this.getJoint().getDegreesOfFreedom(); ++dofIndex) {
                    ForwardDynamicsCalculator.this.jointAccelerationMatrix.set(this.jointIndices[dofIndex], 0, this.qdd.get(dofIndex, 0));
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).passThree();
            }
        }

        public void setExternalWrenchToZeroRecursive() {
            if (this.externalWrench != null) {
                this.externalWrench.setToZero();
            }
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).setExternalWrenchToZeroRecursive();
            }
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public MovingReferenceFrame getBodyFixedFrame() {
            return this.rigidBody.getBodyFixedFrame();
        }

        public MovingReferenceFrame getFrameAfterJoint() {
            return this.getJoint().getFrameAfterJoint();
        }

        public JointReadOnly getJoint() {
            return this.rigidBody.getParentJoint();
        }

        public TwistReadOnly getBodyTwist() {
            return this.getBodyFixedFrame().getTwistOfFrame();
        }

        public String toString() {
            return "RigidBody: " + this.rigidBody + ", parent: " + this.parent.rigidBody + ", children: " + Arrays.asList(this.children.stream().map(c -> c.rigidBody).toArray());
        }
    }
}

