/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;

public interface FixedFrameSpatialMotionBasics
extends SpatialMotionReadOnly,
FixedFrameSpatialVectorBasics {
    default public void set(SpatialMotionReadOnly other) {
        this.set(other.getBodyFrame(), other.getBaseFrame(), other.getReferenceFrame(), (Vector3DReadOnly)other.getAngularPart(), (Vector3DReadOnly)other.getLinearPart());
    }

    default public void setMatchingFrame(SpatialMotionReadOnly other) {
        other.checkBodyFrameMatch(this.getBodyFrame());
        other.checkBaseFrameMatch(this.getBaseFrame());
        FixedFrameSpatialVectorBasics.super.setMatchingFrame(other);
    }

    default public void set(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, SpatialVectorReadOnly spatialVector) {
        this.set(bodyFrame, baseFrame, spatialVector.getReferenceFrame(), (Vector3DReadOnly)spatialVector.getAngularPart(), (Vector3DReadOnly)spatialVector.getLinearPart());
    }

    default public void set(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart) {
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
        this.set(bodyFrame, baseFrame, angularPart.getReferenceFrame(), (Vector3DReadOnly)angularPart, (Vector3DReadOnly)linearPart);
    }

    default public void set(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.checkReferenceFrameMatch(bodyFrame, baseFrame, expressedInFrame);
        this.set(angularPart, linearPart);
    }

    default public void set(Vector3DReadOnly angularPart, Vector3DReadOnly linearPart, Point3DReadOnly observerPosition) {
        this.getAngularPart().set((Tuple3DReadOnly)angularPart);
        double linearPartX = linearPart.getX();
        double linearPartY = linearPart.getY();
        double linearPartZ = linearPart.getZ();
        this.getLinearPart().cross((Tuple3DReadOnly)observerPosition, (Tuple3DReadOnly)angularPart);
        this.getLinearPart().add(linearPartX, linearPartY, linearPartZ);
    }

    default public void set(ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart, Point3DReadOnly observerPosition) {
        this.checkExpressedInFrameMatch(expressedInFrame);
        this.set(angularPart, linearPart, observerPosition);
    }

    default public void set(FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart, FramePoint3DReadOnly observerPosition) {
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)linearPart);
        angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)observerPosition);
        this.set(angularPart.getReferenceFrame(), (Vector3DReadOnly)angularPart, (Vector3DReadOnly)linearPart, (Point3DReadOnly)observerPosition);
    }

    @Override
    default public void applyTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransformReadOnly)) {
            throw new UnsupportedOperationException("The feature applyTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyTransform((RigidBodyTransformReadOnly)transform);
    }

    @Override
    default public void applyInverseTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransformReadOnly)) {
            throw new UnsupportedOperationException("The feature applyInverseTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyInverseTransform((RigidBodyTransformReadOnly)transform);
    }

    default public void applyTransform(RigidBodyTransformReadOnly transform) {
        if (transform.hasRotation()) {
            this.getAngularPart().applyTransform((Transform)transform);
            this.getLinearPart().applyTransform((Transform)transform);
        }
        if (transform.hasTranslation()) {
            this.addCrossToLinearPart(transform.getTranslation(), (Tuple3DReadOnly)this.getAngularPart());
        }
    }

    default public void applyInverseTransform(RigidBodyTransformReadOnly transform) {
        if (transform.hasTranslation()) {
            this.addCrossToLinearPart((Tuple3DReadOnly)this.getAngularPart(), transform.getTranslation());
        }
        if (transform.hasRotation()) {
            this.getAngularPart().applyInverseTransform((Transform)transform);
            this.getLinearPart().applyInverseTransform((Transform)transform);
        }
    }
}

