/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterable;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;

public interface JointReadOnly {
    public static final int MAX_NUMBER_OF_DOFS = 6;
    public static final String NAME_ID_SEPARATOR = ":";

    public RigidBodyReadOnly getPredecessor();

    public RigidBodyReadOnly getSuccessor();

    public MovingReferenceFrame getFrameBeforeJoint();

    public MovingReferenceFrame getFrameAfterJoint();

    public void getJointConfiguration(RigidBodyTransform var1);

    public TwistReadOnly getJointTwist();

    public List<TwistReadOnly> getUnitTwists();

    public MovingReferenceFrame getLoopClosureFrame();

    default public boolean isLoopClosure() {
        return this.getLoopClosureFrame() != null;
    }

    default public boolean isMotionSubspaceVariable() {
        return false;
    }

    default public void getMotionSubspace(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(6, this.getDegreesOfFreedom());
        for (int dofIndex = 0; dofIndex < this.getDegreesOfFreedom(); ++dofIndex) {
            this.getUnitTwists().get(dofIndex).get(0, dofIndex, (DMatrix)matrixToPack);
        }
    }

    default public boolean getMotionSubspaceDot(DMatrix1Row matrixToPack) {
        return false;
    }

    default public void getSuccessorTwist(TwistBasics successorTwistToPack) {
        successorTwistToPack.setIncludingFrame(this.getJointTwist());
        MovingReferenceFrame predecessorFrame = this.getPredecessor().getBodyFixedFrame();
        MovingReferenceFrame successorFrame = this.getSuccessor().getBodyFixedFrame();
        successorTwistToPack.setBaseFrame(predecessorFrame);
        successorTwistToPack.setBodyFrame(successorFrame);
        successorTwistToPack.changeFrame(successorFrame);
    }

    default public void getPredecessorTwist(TwistBasics predecessorTwistToPack) {
        predecessorTwistToPack.setIncludingFrame(this.getJointTwist());
        MovingReferenceFrame predecessorFrame = this.getPredecessor().getBodyFixedFrame();
        MovingReferenceFrame successorFrame = this.getSuccessor().getBodyFixedFrame();
        predecessorTwistToPack.setBaseFrame(predecessorFrame);
        predecessorTwistToPack.setBodyFrame(successorFrame);
        predecessorTwistToPack.invert();
        predecessorTwistToPack.changeFrame(predecessorFrame);
    }

    public SpatialAccelerationReadOnly getJointAcceleration();

    default public SpatialAccelerationReadOnly getJointBiasAcceleration() {
        return null;
    }

    default public void getSuccessorAcceleration(SpatialAccelerationBasics successorAccelerationToPack) {
        successorAccelerationToPack.setIncludingFrame(this.getJointAcceleration());
        MovingReferenceFrame predecessorFrame = this.getPredecessor().getBodyFixedFrame();
        MovingReferenceFrame successorFrame = this.getSuccessor().getBodyFixedFrame();
        successorAccelerationToPack.setBaseFrame(predecessorFrame);
        successorAccelerationToPack.setBodyFrame(successorFrame);
        successorAccelerationToPack.changeFrame(successorFrame);
        if (this.isMotionSubspaceVariable()) {
            SpatialAccelerationReadOnly successorBiasAcceleration = this.getSuccessorBiasAcceleration();
            successorAccelerationToPack.checkReferenceFrameMatch(successorBiasAcceleration);
            successorAccelerationToPack.add(successorBiasAcceleration);
        }
    }

    default public SpatialAccelerationReadOnly getSuccessorBiasAcceleration() {
        return null;
    }

    default public void getPredecessorAcceleration(SpatialAccelerationBasics predecessorAccelerationToPack) {
        predecessorAccelerationToPack.setIncludingFrame(this.getJointAcceleration());
        MovingReferenceFrame predecessorFrame = this.getPredecessor().getBodyFixedFrame();
        MovingReferenceFrame successorFrame = this.getSuccessor().getBodyFixedFrame();
        predecessorAccelerationToPack.setBaseFrame(predecessorFrame);
        predecessorAccelerationToPack.setBodyFrame(successorFrame);
        predecessorAccelerationToPack.invert();
        predecessorAccelerationToPack.changeFrame(predecessorFrame);
        if (this.isMotionSubspaceVariable()) {
            SpatialAccelerationReadOnly predecessorBiasAcceleration = this.getPredecessorBiasAcceleration();
            predecessorAccelerationToPack.checkReferenceFrameMatch(predecessorBiasAcceleration);
            predecessorAccelerationToPack.add(predecessorBiasAcceleration);
        }
    }

    default public SpatialAccelerationReadOnly getPredecessorBiasAcceleration() {
        return null;
    }

    public WrenchReadOnly getJointWrench();

    public int getJointConfiguration(int var1, DMatrix var2);

    public int getJointVelocity(int var1, DMatrix var2);

    public int getJointAcceleration(int var1, DMatrix var2);

    public int getJointTau(int var1, DMatrix var2);

    default public void getJointOffset(RigidBodyTransform jointOffsetTransformToPack) {
        this.getFrameBeforeJoint().getTransformToParent(jointOffsetTransformToPack);
    }

    public int getDegreesOfFreedom();

    public int getConfigurationMatrixSize();

    default public Iterable<? extends JointReadOnly> subtreeIterable() {
        return new JointIterable<JointReadOnly>(JointReadOnly.class, null, this);
    }

    default public Stream<? extends JointReadOnly> subtreeStream() {
        return SubtreeStreams.from(this);
    }

    default public List<? extends JointReadOnly> subtreeList() {
        return this.subtreeStream().collect(Collectors.toList());
    }

    default public JointReadOnly[] subtreeArray() {
        return (JointReadOnly[])this.subtreeStream().toArray(JointReadOnly[]::new);
    }

    public String getName();

    public String getNameId();
}

