/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.frames;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.exceptions.ScrewTheoryException;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public abstract class MovingReferenceFrame
extends ReferenceFrame {
    private boolean isTwistOfFrameUpToDate = false;
    private final Twist twistRelativeToParent;
    private final Twist twistOfFrame = new Twist();
    private final MovingReferenceFrame parentMovingFrame;
    private final List<MovingReferenceFrame> childrenMovingFrames = new ArrayList<MovingReferenceFrame>();
    private final boolean isFixedInParent;

    public static MovingReferenceFrame constructFrameFixedInParent(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent) {
        boolean isZUpFrame = parentFrame.isZupFrame() && transformToParent.isRotation2D();
        boolean isFixedInParent = true;
        MovingReferenceFrame newFrame = new MovingReferenceFrame(frameName, parentFrame, transformToParent, isZUpFrame, isFixedInParent){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            }

            @Override
            protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
            }
        };
        return newFrame;
    }

    public MovingReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        this(frameName, parentFrame, null, false, false);
    }

    public MovingReferenceFrame(String frameName, ReferenceFrame parentFrame, boolean isZUpFrame) {
        this(frameName, parentFrame, (RigidBodyTransformReadOnly)new RigidBodyTransform(), isZUpFrame, false);
    }

    public MovingReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent) {
        this(frameName, parentFrame, transformToParent, false, false);
    }

    public MovingReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent, boolean isZUpFrame) {
        this(frameName, parentFrame, transformToParent, isZUpFrame, false);
    }

    private MovingReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent, boolean isZUpFrame, boolean isFixedInParent) {
        super(frameName, parentFrame, transformToParent, parentFrame.isAStationaryFrame() && isFixedInParent, isZUpFrame);
        this.isFixedInParent = isFixedInParent;
        if (parentFrame instanceof MovingReferenceFrame) {
            this.parentMovingFrame = (MovingReferenceFrame)parentFrame;
            this.parentMovingFrame.childrenMovingFrames.add(this);
        } else {
            this.parentMovingFrame = null;
            if (!parentFrame.isAStationaryFrame()) {
                throw MovingReferenceFrame.unhandledReferenceFrameTypeException(parentFrame);
            }
        }
        this.twistRelativeToParent = isFixedInParent ? null : new Twist((ReferenceFrame)this, parentFrame, this);
    }

    public void update() {
        super.update();
        if (!this.isFixedInParent) {
            this.updateTwistRelativeToParent(this.twistRelativeToParent);
            this.twistRelativeToParent.checkReferenceFrameMatch(this, this.getParent(), this);
        }
        this.isTwistOfFrameUpToDate = false;
    }

    protected abstract void updateTwistRelativeToParent(Twist var1);

    private void updateTwistOfFrame() {
        if (this.isTwistOfFrameUpToDateRecursive()) {
            return;
        }
        if (this.parentMovingFrame == null) {
            if (this.isFixedInParent) {
                this.twistOfFrame.setToZero(this, this.getParent(), this);
            } else {
                this.twistOfFrame.setIncludingFrame(this.twistRelativeToParent);
            }
        } else {
            this.twistOfFrame.setIncludingFrame(this.parentMovingFrame.getTwistOfFrame());
            this.twistOfFrame.changeFrame(this);
            if (this.isFixedInParent) {
                this.twistOfFrame.setBodyFrame(this);
            } else {
                this.twistOfFrame.add(this.twistRelativeToParent);
            }
        }
        this.isTwistOfFrameUpToDate = true;
        for (int i = 0; i < this.childrenMovingFrames.size(); ++i) {
            this.childrenMovingFrames.get((int)i).isTwistOfFrameUpToDate = false;
        }
    }

    private boolean isTwistOfFrameUpToDateRecursive() {
        return this.isTwistOfFrameUpToDate && (this.parentMovingFrame == null || this.parentMovingFrame.isTwistOfFrameUpToDateRecursive());
    }

    public TwistReadOnly getTwistRelativeToParent() {
        return this.twistRelativeToParent;
    }

    public TwistReadOnly getTwistOfFrame() {
        this.updateTwistOfFrame();
        return this.twistOfFrame;
    }

    public void getTwistOfFrame(TwistBasics twistToPack) {
        twistToPack.setIncludingFrame(this.getTwistOfFrame());
    }

    public void getTwistRelativeToOther(ReferenceFrame base, TwistBasics relativeTwistToPack) {
        this.verifySameRoots(base);
        if (base.isAStationaryFrame()) {
            this.getTwistOfFrame(relativeTwistToPack);
            relativeTwistToPack.setBaseFrame(base);
        } else if (base instanceof MovingReferenceFrame) {
            ((MovingReferenceFrame)base).getTwistOfFrame(relativeTwistToPack);
            relativeTwistToPack.changeFrame(this);
            relativeTwistToPack.sub(this.getTwistOfFrame());
            relativeTwistToPack.invert();
        } else {
            throw MovingReferenceFrame.unhandledReferenceFrameTypeException(base);
        }
    }

    public MovingReferenceFrame getMovingParent() {
        return this.parentMovingFrame;
    }

    private static ScrewTheoryException unhandledReferenceFrameTypeException(ReferenceFrame referenceFrame) {
        return new ScrewTheoryException("The reference frame type: " + referenceFrame.getClass().getSimpleName() + " is currently not handled. Reference frame name: " + referenceFrame.getName());
    }
}

