/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.iterators;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterator;

public class JointIterable<J extends JointReadOnly>
implements Iterable<J> {
    private final Collection<? extends JointReadOnly> roots;
    private final Predicate<J> selectionRule;
    private final Class<J> filteringClass;

    public JointIterable(Class<J> filteringClass, Predicate<J> selectionRule, JointReadOnly root) {
        this.filteringClass = filteringClass;
        this.selectionRule = selectionRule;
        this.roots = Collections.singleton(root);
    }

    public JointIterable(Class<J> filteringClass, Predicate<J> selectionRule, Collection<? extends JointReadOnly> roots) {
        this.filteringClass = filteringClass;
        this.selectionRule = selectionRule;
        this.roots = roots;
    }

    @Override
    public Iterator<J> iterator() {
        return new JointIterator<J>(this.filteringClass, this.selectionRule, this.roots);
    }

    public Stream<J> toStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

