/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;

public interface FloatingJointBasics
extends FloatingJointReadOnly,
JointBasics {
    public Pose3DBasics getJointPose();

    @Override
    public FixedFrameTwistBasics getJointTwist();

    @Override
    public FixedFrameSpatialAccelerationBasics getJointAcceleration();

    @Override
    public FixedFrameWrenchBasics getJointWrench();

    @Override
    default public void setJointConfigurationToZero() {
        this.getJointPose().setToZero();
    }

    @Override
    default public void setJointTwistToZero() {
        this.getJointTwist().setToZero();
    }

    @Override
    default public void setJointAccelerationToZero() {
        this.getJointAcceleration().setToZero();
    }

    @Override
    default public void setJointTauToZero() {
        this.getJointWrench().setToZero();
    }

    @Override
    default public void setJointOrientation(Orientation3DReadOnly jointOrientation) {
        this.getJointPose().getOrientation().set(jointOrientation);
    }

    @Override
    default public void setJointPosition(Tuple3DReadOnly jointTranslation) {
        this.getJointPose().getPosition().set(jointTranslation);
    }

    @Override
    default public void setJointAngularVelocity(Vector3DReadOnly jointAngularVelocity) {
        this.getJointTwist().getAngularPart().set((Tuple3DReadOnly)jointAngularVelocity);
    }

    @Override
    default public void setJointLinearVelocity(Vector3DReadOnly jointLinearVelocity) {
        this.getJointTwist().getLinearPart().set((Tuple3DReadOnly)jointLinearVelocity);
    }

    @Override
    default public void setJointAngularAcceleration(Vector3DReadOnly jointAngularAcceleration) {
        this.getJointAcceleration().getAngularPart().set((Tuple3DReadOnly)jointAngularAcceleration);
    }

    @Override
    default public void setJointLinearAcceleration(Vector3DReadOnly jointLinearAcceleration) {
        this.getJointAcceleration().getLinearPart().set((Tuple3DReadOnly)jointLinearAcceleration);
    }

    @Override
    default public void setJointTorque(Vector3DReadOnly jointTorque) {
        this.getJointWrench().getAngularPart().set((Tuple3DReadOnly)jointTorque);
    }

    @Override
    default public void setJointForce(Vector3DReadOnly jointForce) {
        this.getJointWrench().getLinearPart().set((Tuple3DReadOnly)jointForce);
    }
}

