/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoTools;

public interface SpatialAccelerationReadOnly
extends SpatialMotionReadOnly {
    default public void getLinearAccelerationAt(TwistReadOnly bodyTwist, FramePoint3DReadOnly bodyFixedPoint, FrameVector3DBasics linearAccelerationToPack) {
        linearAccelerationToPack.setReferenceFrame(this.getReferenceFrame());
        this.getLinearAccelerationAt(bodyTwist, bodyFixedPoint, (FixedFrameVector3DBasics)linearAccelerationToPack);
    }

    default public void getLinearAccelerationAt(TwistReadOnly bodyTwist, FramePoint3DReadOnly bodyFixedPoint, FixedFrameVector3DBasics linearAccelerationToPack) {
        if (this.getReferenceFrame() != this.getBodyFrame() && this.getReferenceFrame() != this.getBaseFrame()) {
            throw new ReferenceFrameMismatchException("This spatial acceleration has to either be expressed in base frame or body frame to use this feature: body frame = " + this.getBodyFrame() + ", base frame = " + this.getBaseFrame() + ", expressed in frame = " + this.getReferenceFrame());
        }
        this.checkExpressedInFrameMatch(bodyFixedPoint.getReferenceFrame());
        if (bodyTwist != null) {
            this.checkReferenceFrameMatch(bodyTwist);
            linearAccelerationToPack.set((FrameTuple3DReadOnly)bodyTwist.getLinearPart());
            MecanoTools.addCrossToVector((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DReadOnly)bodyFixedPoint, (Vector3DBasics)linearAccelerationToPack);
            linearAccelerationToPack.cross(bodyTwist.getAngularPart(), (FrameVector3DReadOnly)linearAccelerationToPack);
            MecanoTools.addCrossToVector((Tuple3DReadOnly)this.getAngularPart(), (Tuple3DReadOnly)bodyFixedPoint, (Vector3DBasics)linearAccelerationToPack);
            linearAccelerationToPack.add((FrameTuple3DReadOnly)this.getLinearPart());
        } else {
            linearAccelerationToPack.set((FrameTuple3DReadOnly)this.getLinearPart());
            MecanoTools.addCrossToVector((Tuple3DReadOnly)this.getAngularPart(), (Tuple3DReadOnly)bodyFixedPoint, (Vector3DBasics)linearAccelerationToPack);
        }
    }

    default public void getLinearAccelerationAtBodyOrigin(TwistReadOnly bodyTwist, FrameVector3DBasics linearAccelerationToPack) {
        this.getBodyFrame().checkReferenceFrameMatch(this.getReferenceFrame());
        this.checkReferenceFrameMatch(bodyTwist);
        linearAccelerationToPack.setIncludingFrame((FrameTuple3DReadOnly)this.getLinearPart());
        MecanoTools.addCrossToVector((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DReadOnly)bodyTwist.getLinearPart(), (Vector3DBasics)linearAccelerationToPack);
    }

    default public boolean geometricallyEquals(SpatialAccelerationReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        if (!this.getAngularPart().geometricallyEquals(other.getAngularPart(), epsilon)) {
            return false;
        }
        return this.getLinearPart().geometricallyEquals(other.getLinearPart(), epsilon);
    }
}

