/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.spatial;

import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialForce;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFixedFrameWrench
implements FixedFrameWrenchBasics,
Settable<YoFixedFrameWrench> {
    private final ReferenceFrame bodyFrame;
    private final YoFixedFrameSpatialForce spatialForceVector;

    public YoFixedFrameWrench(String namePrefix, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, YoRegistry registry) {
        this(bodyFrame, new YoFixedFrameSpatialVector(namePrefix, expressedInFrame, registry));
    }

    public YoFixedFrameWrench(String namePrefix, String nameSuffix, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, YoRegistry registry) {
        this(bodyFrame, new YoFixedFrameSpatialVector(namePrefix, nameSuffix, expressedInFrame, registry));
    }

    public YoFixedFrameWrench(ReferenceFrame bodyFrame, YoFrameVector3D angularPart, YoFrameVector3D linearPart) {
        this(bodyFrame, new YoFixedFrameSpatialVector(angularPart, linearPart));
    }

    public YoFixedFrameWrench(ReferenceFrame bodyFrame, YoFixedFrameSpatialVector spatialVector) {
        this.bodyFrame = bodyFrame;
        this.spatialForceVector = new YoFixedFrameSpatialForce(spatialVector);
    }

    public void set(YoFixedFrameWrench other) {
        super.set((WrenchReadOnly)other);
    }

    public ReferenceFrame getBodyFrame() {
        return this.bodyFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.spatialForceVector.getReferenceFrame();
    }

    public YoFrameVector3D getAngularPart() {
        return this.spatialForceVector.getAngularPart();
    }

    public YoFrameVector3D getLinearPart() {
        return this.spatialForceVector.getLinearPart();
    }

    public void applyTransform(Transform transform) {
        this.spatialForceVector.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.spatialForceVector.applyInverseTransform(transform);
    }

    public boolean equals(Object object) {
        if (object instanceof WrenchReadOnly) {
            return super.equals((WrenchReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return MecanoIOTools.getWrenchString((WrenchReadOnly)this);
    }
}

