/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.spatial;

import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.mecano.spatial.interfaces.FixedFrameMomentumBasics;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialForce;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFixedFrameMomentum
implements FixedFrameMomentumBasics,
Settable<YoFixedFrameMomentum> {
    private final YoFixedFrameSpatialForce spatialForceVector;

    public YoFixedFrameMomentum(String namePrefix, ReferenceFrame expressedInFrame, YoRegistry registry) {
        this(new YoFixedFrameSpatialVector(namePrefix, expressedInFrame, registry));
    }

    public YoFixedFrameMomentum(String namePrefix, String nameSuffix, ReferenceFrame expressedInFrame, YoRegistry registry) {
        this(new YoFixedFrameSpatialVector(namePrefix, nameSuffix, expressedInFrame, registry));
    }

    public YoFixedFrameMomentum(YoFrameVector3D angularPart, YoFrameVector3D linearPart) {
        this(new YoFixedFrameSpatialVector(angularPart, linearPart));
    }

    public YoFixedFrameMomentum(YoFixedFrameSpatialVector spatialVector) {
        this.spatialForceVector = new YoFixedFrameSpatialForce(spatialVector.getAngularPart(), spatialVector.getLinearPart());
    }

    public void set(YoFixedFrameMomentum other) {
        super.set((SpatialVectorReadOnly)other);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.spatialForceVector.getReferenceFrame();
    }

    public YoFrameVector3D getAngularPart() {
        return this.spatialForceVector.getAngularPart();
    }

    public YoFrameVector3D getLinearPart() {
        return this.spatialForceVector.getLinearPart();
    }

    public void applyTransform(Transform transform) {
        this.spatialForceVector.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.spatialForceVector.applyInverseTransform(transform);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MomentumReadOnly) {
            return this.equals((SpatialVectorReadOnly)((MomentumReadOnly)object));
        }
        return false;
    }

    public String toString() {
        return MecanoIOTools.getMomentumString((MomentumReadOnly)this);
    }
}

