/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.yoVariables.multiBodySystem.interfaces.YoOneDoFJointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class YoOneDoFJoint
extends Joint
implements YoOneDoFJointBasics {
    private final YoDouble q;
    private final YoDouble qd;
    private final YoDouble qdd;
    private final YoDouble tau;
    private final YoDouble jointLimitLower;
    private final YoDouble jointLimitUpper;
    private final YoDouble velocityLimitLower;
    private final YoDouble velocityLimitUpper;
    private final YoDouble effortLimitLower;
    private final YoDouble effortLimitUpper;
    private final TwistReadOnly jointTwist;
    private final TwistReadOnly unitJointTwist;
    private final List<TwistReadOnly> unitTwists;
    private TwistReadOnly unitSuccessorTwist;
    private TwistReadOnly unitPredecessorTwist;
    private final SpatialAccelerationReadOnly jointAcceleration;
    private final SpatialAccelerationReadOnly unitJointAcceleration;
    private SpatialAccelerationReadOnly unitSuccessorAcceleration;
    private SpatialAccelerationReadOnly unitPredecessorAcceleration;
    private WrenchReadOnly jointWrench;
    private WrenchReadOnly unitJointWrench;

    public YoOneDoFJoint(String name, RigidBodyBasics predecessor, Vector3DReadOnly jointAxisAngularPart, Vector3DReadOnly jointAxisLinearPart, RigidBodyTransformReadOnly transformToParent, YoRegistry registry) {
        super(name, predecessor, transformToParent);
        this.q = new YoDouble("q_" + this.getName(), registry);
        this.qd = new YoDouble("qd_" + this.getName(), registry);
        this.qdd = new YoDouble("qdd_" + this.getName(), registry);
        this.tau = new YoDouble("tau_" + this.getName(), registry);
        this.jointLimitLower = new YoDouble("q_min_" + this.getName(), registry);
        this.jointLimitUpper = new YoDouble("q_max_" + this.getName(), registry);
        this.velocityLimitLower = new YoDouble("qd_min_" + this.getName(), registry);
        this.velocityLimitUpper = new YoDouble("qd_max_" + this.getName(), registry);
        this.effortLimitLower = new YoDouble("tau_min_" + this.getName(), registry);
        this.effortLimitUpper = new YoDouble("tau_max_" + this.getName(), registry);
        this.jointLimitLower.set(Double.NEGATIVE_INFINITY);
        this.jointLimitUpper.set(Double.POSITIVE_INFINITY);
        this.velocityLimitLower.set(Double.NEGATIVE_INFINITY);
        this.velocityLimitUpper.set(Double.POSITIVE_INFINITY);
        this.effortLimitLower.set(Double.NEGATIVE_INFINITY);
        this.effortLimitUpper.set(Double.POSITIVE_INFINITY);
        this.unitJointTwist = new Twist((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, (ReferenceFrame)this.afterJointFrame, jointAxisAngularPart, jointAxisLinearPart);
        this.unitTwists = Collections.singletonList(this.unitJointTwist);
        this.jointTwist = MecanoFactories.newTwistReadOnly(this::getQd, (TwistReadOnly)this.unitJointTwist);
        this.unitJointAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)this.unitJointTwist);
        this.jointAcceleration = MecanoFactories.newSpatialAccelerationVectorReadOnly(this::getQdd, (SpatialAccelerationReadOnly)this.unitJointAcceleration);
    }

    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        this.unitSuccessorTwist = MecanoFactories.newOneDoFJointUnitSuccessorTwist((OneDoFJointReadOnly)this);
        this.unitPredecessorTwist = MecanoFactories.newOneDoFJointUnitPredecessorTwist((OneDoFJointReadOnly)this);
        this.unitSuccessorAcceleration = MecanoFactories.newOneDoFJointUnitSuccessorAcceleration((OneDoFJointReadOnly)this);
        this.unitPredecessorAcceleration = MecanoFactories.newOneDoFJointUnitPredecessorAcceleration((OneDoFJointReadOnly)this);
        this.unitJointWrench = MecanoFactories.newOneDoFJointUnitJointWrench((OneDoFJointReadOnly)this);
        this.jointWrench = MecanoFactories.newWrenchReadOnly(this::getTau, (WrenchReadOnly)this.unitJointWrench);
    }

    public TwistReadOnly getJointTwist() {
        return this.jointTwist;
    }

    public TwistReadOnly getUnitJointTwist() {
        return this.unitJointTwist;
    }

    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }

    public TwistReadOnly getUnitSuccessorTwist() {
        return this.unitSuccessorTwist;
    }

    public TwistReadOnly getUnitPredecessorTwist() {
        return this.unitPredecessorTwist;
    }

    public SpatialAccelerationReadOnly getJointAcceleration() {
        return this.jointAcceleration;
    }

    public SpatialAccelerationReadOnly getUnitJointAcceleration() {
        return this.unitJointAcceleration;
    }

    public SpatialAccelerationReadOnly getUnitSuccessorAcceleration() {
        return this.unitSuccessorAcceleration;
    }

    public SpatialAccelerationReadOnly getUnitPredecessorAcceleration() {
        return this.unitPredecessorAcceleration;
    }

    public WrenchReadOnly getJointWrench() {
        return this.jointWrench;
    }

    @Override
    public YoDouble getYoQ() {
        return this.q;
    }

    @Override
    public YoDouble getYoQd() {
        return this.qd;
    }

    @Override
    public YoDouble getYoQdd() {
        return this.qdd;
    }

    @Override
    public YoDouble getYoTau() {
        return this.tau;
    }

    @Override
    public YoDouble getYoJointLimitLower() {
        return this.jointLimitLower;
    }

    @Override
    public YoDouble getYoJointLimitUpper() {
        return this.jointLimitUpper;
    }

    @Override
    public YoDouble getYoVelocityLimitLower() {
        return this.velocityLimitLower;
    }

    @Override
    public YoDouble getYoVelocityLimitUpper() {
        return this.velocityLimitUpper;
    }

    @Override
    public YoDouble getYoEffortLimitLower() {
        return this.effortLimitLower;
    }

    @Override
    public YoDouble getYoEffortLimitUpper() {
        return this.effortLimitUpper;
    }

    public String toString() {
        String qAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQ());
        String qdAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQd());
        String qddAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQdd());
        String tauAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getTau());
        return super.toString() + ", q: " + qAsString + ", qd: " + qdAsString + ", qdd: " + qddAsString + ", tau: " + tauAsString;
    }
}

