/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.spatial;

import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFixedFrameSpatialAcceleration
implements FixedFrameSpatialAccelerationBasics,
Settable<YoFixedFrameSpatialAcceleration> {
    private final ReferenceFrame bodyFrame;
    private final ReferenceFrame baseFrame;
    private final YoFixedFrameSpatialVector spatialVector;
    private final Point3D observerPosition = new Point3D();

    public YoFixedFrameSpatialAcceleration(String namePrefix, ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, YoRegistry registry) {
        this(bodyFrame, baseFrame, new YoFixedFrameSpatialVector(namePrefix, expressedInFrame, registry));
    }

    public YoFixedFrameSpatialAcceleration(String namePrefix, String nameSuffix, ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, YoRegistry registry) {
        this(bodyFrame, baseFrame, new YoFixedFrameSpatialVector(namePrefix, nameSuffix, expressedInFrame, registry));
    }

    public YoFixedFrameSpatialAcceleration(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, YoFrameVector3D angularPart, YoFrameVector3D linearPart) {
        this(bodyFrame, baseFrame, new YoFixedFrameSpatialVector(angularPart, linearPart));
    }

    public YoFixedFrameSpatialAcceleration(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, YoFixedFrameSpatialVector spatialVector) {
        this.bodyFrame = bodyFrame;
        this.baseFrame = baseFrame;
        this.spatialVector = spatialVector;
    }

    public void set(YoFixedFrameSpatialAcceleration other) {
        super.set((SpatialMotionReadOnly)other);
    }

    public void applyTransform(Transform transform) {
        if (transform instanceof RigidBodyTransform) {
            this.applyTransform((RigidBodyTransformReadOnly)((RigidBodyTransform)transform));
        } else {
            this.observerPosition.setToZero();
            this.observerPosition.applyTransform(transform);
            this.spatialVector.applyTransform(transform);
            this.addCrossToLinearPart((Tuple3DReadOnly)this.observerPosition, (Tuple3DReadOnly)this.getAngularPart());
        }
    }

    public void applyInverseTransform(Transform transform) {
        if (transform instanceof RigidBodyTransform) {
            this.applyInverseTransform((RigidBodyTransformReadOnly)((RigidBodyTransform)transform));
        } else {
            this.observerPosition.setToZero();
            this.observerPosition.applyInverseTransform(transform);
            this.spatialVector.applyInverseTransform(transform);
            this.addCrossToLinearPart((Tuple3DReadOnly)this.observerPosition, (Tuple3DReadOnly)this.getAngularPart());
        }
    }

    public ReferenceFrame getBodyFrame() {
        return this.bodyFrame;
    }

    public ReferenceFrame getBaseFrame() {
        return this.baseFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.spatialVector.getReferenceFrame();
    }

    public YoFrameVector3D getAngularPart() {
        return this.spatialVector.getAngularPart();
    }

    public YoFrameVector3D getLinearPart() {
        return this.spatialVector.getLinearPart();
    }

    public boolean equals(Object object) {
        if (object instanceof SpatialAccelerationReadOnly) {
            return super.equals((SpatialMotionReadOnly)((SpatialAccelerationReadOnly)object));
        }
        return false;
    }

    public String toString() {
        return MecanoIOTools.getSpatialAccelerationString((SpatialAccelerationReadOnly)this);
    }
}

