/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.yoVariables.tools.YoMecanoFactories;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoPlanarJoint
extends Joint
implements PlanarJointBasics {
    private final YoRegistry registry;
    private final Pose3DBasics jointPose;
    private final FixedFrameTwistBasics jointTwist;
    private final FixedFrameSpatialAccelerationBasics jointAcceleration;
    private FixedFrameWrenchBasics jointWrench;
    private final List<TwistReadOnly> unitTwists;
    private final String varName;

    public YoPlanarJoint(String name, RigidBodyBasics predecessor, YoRegistry registry) {
        this(name, predecessor, null, registry);
    }

    public YoPlanarJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, YoRegistry registry) {
        super(name, predecessor, transformToParent);
        this.registry = registry;
        this.varName = !name.isEmpty() ? "_" + name + "_" : "_";
        YoDouble x = new YoDouble("q" + this.varName + "x", registry);
        YoDouble z = new YoDouble("q" + this.varName + "z", registry);
        YoDouble pitch = new YoDouble("q" + this.varName + "pitch", registry);
        this.jointPose = YoMecanoFactories.newPlanarYoPose3DBasics(pitch, x, z);
        YoDouble angularVelocityY = new YoDouble("qd" + this.varName + "wy", registry);
        YoDouble linearVelocityX = new YoDouble("qd" + this.varName + "x", registry);
        YoDouble linearVelocityZ = new YoDouble("qd" + this.varName + "z", registry);
        this.jointTwist = YoMecanoFactories.newPlanarYoFixedFrameTwistBasics(angularVelocityY, linearVelocityX, linearVelocityZ, (ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, (ReferenceFrame)this.afterJointFrame);
        YoDouble angularAccelerationY = new YoDouble("qdd" + this.varName + "wy", registry);
        YoDouble linearAccelerationX = new YoDouble("qdd" + this.varName + "x", registry);
        YoDouble linearAccelerationZ = new YoDouble("qdd" + this.varName + "z", registry);
        this.jointAcceleration = YoMecanoFactories.newPlanarYoFixedFrameSpatialAccelerationVectorBasics(angularAccelerationY, linearAccelerationX, linearAccelerationZ, (ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, (ReferenceFrame)this.afterJointFrame);
        this.unitTwists = MecanoTools.computePlanarJointMotionSubspace((ReferenceFrame)this.beforeJointFrame, (ReferenceFrame)this.afterJointFrame);
    }

    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        MovingReferenceFrame successorFrame = successor.getBodyFixedFrame();
        YoDouble torqueY = new YoDouble("tau" + this.varName + "wy", this.registry);
        YoDouble forceX = new YoDouble("tau" + this.varName + "x", this.registry);
        YoDouble forceZ = new YoDouble("tau" + this.varName + "z", this.registry);
        this.jointWrench = YoMecanoFactories.newPlanarYoFixedFrameWrenchBasics(torqueY, forceX, forceZ, (ReferenceFrame)successorFrame, (ReferenceFrame)this.afterJointFrame);
    }

    public Pose3DBasics getJointPose() {
        return this.jointPose;
    }

    public FixedFrameTwistBasics getJointTwist() {
        return this.jointTwist;
    }

    public FixedFrameSpatialAccelerationBasics getJointAcceleration() {
        return this.jointAcceleration;
    }

    public FixedFrameWrenchBasics getJointWrench() {
        return this.jointWrench;
    }

    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }
}

