/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialAcceleration;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameTwist;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameWrench;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoSixDoFJoint
extends Joint
implements SixDoFJointBasics {
    private final YoRegistry registry;
    private final YoFramePose3D jointPose;
    private final YoFixedFrameTwist jointTwist;
    private final YoFixedFrameSpatialAcceleration jointAcceleration;
    private YoFixedFrameWrench jointWrench;
    private final List<TwistReadOnly> unitTwists;
    private final String varName;

    public YoSixDoFJoint(String name, RigidBodyBasics predecessor, YoRegistry registry) {
        this(name, predecessor, null, registry);
    }

    public YoSixDoFJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, YoRegistry registry) {
        super(name, predecessor, transformToParent);
        this.registry = registry;
        this.varName = !name.isEmpty() ? "_" + name + "_" : "_";
        this.jointPose = new YoFramePose3D(new YoFramePoint3D("q" + this.varName, (ReferenceFrame)this.beforeJointFrame, registry), new YoFrameQuaternion("q" + this.varName, (ReferenceFrame)this.beforeJointFrame, registry));
        this.jointTwist = new YoFixedFrameTwist((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, new YoFrameVector3D("qd" + this.varName + "w", (ReferenceFrame)this.afterJointFrame, registry), new YoFrameVector3D("qd" + this.varName, (ReferenceFrame)this.afterJointFrame, registry));
        this.jointAcceleration = new YoFixedFrameSpatialAcceleration((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, new YoFrameVector3D("qdd" + this.varName + "w", (ReferenceFrame)this.afterJointFrame, registry), new YoFrameVector3D("qdd" + this.varName, (ReferenceFrame)this.afterJointFrame, registry));
        this.unitTwists = MecanoTools.computeSixDoFJointMotionSubspace((ReferenceFrame)this.beforeJointFrame, (ReferenceFrame)this.afterJointFrame);
    }

    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        MovingReferenceFrame successorFrame = successor.getBodyFixedFrame();
        if (this.jointWrench == null) {
            this.jointWrench = new YoFixedFrameWrench((ReferenceFrame)successorFrame, new YoFrameVector3D("tau" + this.varName + "w", (ReferenceFrame)this.afterJointFrame, this.registry), new YoFrameVector3D("tau" + this.varName, (ReferenceFrame)this.afterJointFrame, this.registry));
        } else {
            this.jointWrench.checkBodyFrameMatch((ReferenceFrame)successorFrame);
        }
    }

    public YoFramePose3D getJointPose() {
        return this.jointPose;
    }

    public YoFixedFrameTwist getJointTwist() {
        return this.jointTwist;
    }

    public YoFixedFrameSpatialAcceleration getJointAcceleration() {
        return this.jointAcceleration;
    }

    public YoFixedFrameWrench getJointWrench() {
        return this.jointWrench;
    }

    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }

    public String toString() {
        return super.toString() + ", configuration: " + this.jointPose + ", velocity: " + this.jointTwist + ", acceleration: " + this.jointAcceleration + ", wrench" + this.jointWrench;
    }
}

