/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.tools;

import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteTwinsJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoCrossFourBarJoint;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoPlanarJoint;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoPrismaticJoint;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoRevoluteJoint;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoRevoluteTwinsJoint;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoRigidBody;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoSixDoFJoint;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoSphericalJoint;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoMultiBodySystemFactories {
    public static MultiBodySystemFactories.JointBuilder newYoJointBuilder(final YoRegistry registry) {
        return new MultiBodySystemFactories.JointBuilder(){

            public YoSixDoFJoint buildSixDoFJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
                return new YoSixDoFJoint(name, predecessor, transformToParent, registry);
            }

            public YoPlanarJoint buildPlanarJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
                return new YoPlanarJoint(name, predecessor, transformToParent, registry);
            }

            public YoSphericalJoint buildSphericalJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
                return new YoSphericalJoint(name, predecessor, transformToParent, registry);
            }

            public YoRevoluteJoint buildRevoluteJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, Vector3DReadOnly jointAxis) {
                return new YoRevoluteJoint(name, predecessor, transformToParent, jointAxis, registry);
            }

            public YoPrismaticJoint buildPrismaticJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, Vector3DReadOnly jointAxis) {
                return new YoPrismaticJoint(name, predecessor, transformToParent, jointAxis, registry);
            }

            public YoCrossFourBarJoint cloneCrossFourBarJoint(CrossFourBarJointReadOnly original, String cloneSuffix, RigidBodyBasics clonePredecessor) {
                RevoluteJointReadOnly originalJointA = original.getJointA();
                RevoluteJointReadOnly originalJointB = original.getJointB();
                RevoluteJointReadOnly originalJointC = original.getJointC();
                RevoluteJointReadOnly originalJointD = original.getJointD();
                RigidBodyReadOnly originalBodyDA = originalJointA.getSuccessor();
                RigidBodyReadOnly originalBodyBC = originalJointB.getSuccessor();
                int loopClosureIndex = originalJointA.isLoopClosure() ? 0 : (originalJointB.isLoopClosure() ? 1 : (originalJointC.isLoopClosure() ? 2 : 3));
                return new YoCrossFourBarJoint(original.getName() + cloneSuffix, clonePredecessor, originalJointA.getName() + cloneSuffix, originalJointB.getName() + cloneSuffix, originalJointC.getName() + cloneSuffix, originalJointD.getName() + cloneSuffix, originalBodyDA.getName() + cloneSuffix, originalBodyBC.getName() + cloneSuffix, (RigidBodyTransformReadOnly)originalJointA.getFrameBeforeJoint().getTransformToParent(), (RigidBodyTransformReadOnly)originalJointB.getFrameBeforeJoint().getTransformToParent(), (RigidBodyTransformReadOnly)originalJointD.getFrameBeforeJoint().getTransformToParent(), (RigidBodyTransformReadOnly)originalJointC.getFrameBeforeJoint().getTransformToParent(), originalBodyDA.getInertia().getMomentOfInertia(), originalBodyBC.getInertia().getMomentOfInertia(), originalBodyDA.getInertia().getMass(), originalBodyBC.getInertia().getMass(), (RigidBodyTransformReadOnly)originalBodyDA.getBodyFixedFrame().getTransformToParent(), (RigidBodyTransformReadOnly)originalBodyBC.getBodyFixedFrame().getTransformToParent(), original.getActuatedJointIndex(), loopClosureIndex, (Vector3DReadOnly)original.getJointAxis(), registry);
            }

            public YoRevoluteTwinsJoint cloneRevoluteTwinsJoint(RevoluteTwinsJointReadOnly original, String cloneSuffix, RigidBodyBasics clonePredecessor) {
                RevoluteJointReadOnly originalJointA = original.getJointA();
                RevoluteJointReadOnly originalJointB = original.getJointB();
                RigidBodyReadOnly originalBodyAB = originalJointA.getSuccessor();
                return new YoRevoluteTwinsJoint(original.getName() + cloneSuffix, clonePredecessor, originalJointA.getName() + cloneSuffix, originalJointB.getName() + cloneSuffix, originalBodyAB.getName() + cloneSuffix, (RigidBodyTransformReadOnly)originalJointA.getFrameBeforeJoint().getTransformToParent(), (RigidBodyTransformReadOnly)originalJointB.getFrameBeforeJoint().getTransformToParent(), originalBodyAB.getInertia().getMomentOfInertia(), originalBodyAB.getInertia().getMass(), (RigidBodyTransformReadOnly)originalBodyAB.getBodyFixedFrame().getTransformToParent(), original.getActuatedJointIndex(), original.getConstraintRatio(), original.getConstraintOffset(), (Vector3DReadOnly)original.getJointAxis(), registry);
            }
        };
    }

    public static MultiBodySystemFactories.RigidBodyBuilder newYoRigidBodyBuilder(final YoRegistry registry) {
        return new MultiBodySystemFactories.RigidBodyBuilder(){

            public YoRigidBody buildRoot(String bodyName, RigidBodyTransformReadOnly transformToParent, ReferenceFrame parentStationaryFrame) {
                return new YoRigidBody(bodyName, transformToParent, parentStationaryFrame);
            }

            public YoRigidBody build(String bodyName, JointBasics parentJoint, Matrix3DReadOnly momentOfInertia, double mass, RigidBodyTransformReadOnly inertiaPose) {
                return new YoRigidBody(bodyName, parentJoint, momentOfInertia, mass, inertiaPose, registry);
            }

            public YoRigidBody cloneRigidBody(RigidBodyReadOnly original, ReferenceFrame cloneStationaryFrame, String cloneSuffix, JointBasics parentJointOfClone) {
                if (original.isRootBody() && parentJointOfClone != null) {
                    throw new IllegalArgumentException("Inconsistent set of arguments. If the original body is the root body, the parent joint should be null.");
                }
                String nameOriginal = original.getName();
                if (parentJointOfClone == null) {
                    MovingReferenceFrame originalBodyFixedFrame = original.getBodyFixedFrame();
                    if (cloneStationaryFrame == null) {
                        cloneStationaryFrame = originalBodyFixedFrame;
                    }
                    return this.buildRoot(nameOriginal + cloneSuffix, (RigidBodyTransformReadOnly)originalBodyFixedFrame.getTransformToParent(), cloneStationaryFrame);
                }
                SpatialInertiaReadOnly originalInertia = original.getInertia();
                double mass = originalInertia.getMass();
                Matrix3DReadOnly momentOfInertia = originalInertia.getMomentOfInertia();
                RigidBodyTransform inertiaPose = new RigidBodyTransform((RigidBodyTransformReadOnly)original.getBodyFixedFrame().getTransformToParent());
                YoRigidBody clone = this.build(nameOriginal + cloneSuffix, parentJointOfClone, momentOfInertia, mass, (RigidBodyTransformReadOnly)inertiaPose);
                clone.getInertia().getCenterOfMassOffset().set((Tuple3DReadOnly)originalInertia.getCenterOfMassOffset());
                return clone;
            }
        };
    }
}

