/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;
import us.ihmc.mecano.yoVariables.spatial.YoSpatialInertia;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoRigidBody
implements RigidBodyBasics {
    private final YoSpatialInertia spatialInertia;
    private final MovingReferenceFrame bodyFixedFrame;
    private final JointBasics parentJoint;
    private final List<JointBasics> parentLoopClosureJoints = new ArrayList<JointBasics>();
    private final List<JointBasics> childrenJoints = new ArrayList<JointBasics>();
    private final String name;
    private final String nameId;

    public YoRigidBody(String bodyName, RigidBodyTransformReadOnly transformToParent, ReferenceFrame parentStationaryFrame) {
        if (bodyName == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = bodyName;
        this.spatialInertia = null;
        this.bodyFixedFrame = MovingReferenceFrame.constructFrameFixedInParent((String)(bodyName + "Frame"), (ReferenceFrame)parentStationaryFrame, (RigidBodyTransformReadOnly)transformToParent);
        this.parentJoint = null;
        this.nameId = bodyName;
    }

    public YoRigidBody(String bodyName, JointBasics parentJoint, Matrix3DReadOnly momentOfInertia, double mass, RigidBodyTransformReadOnly inertiaPose, YoRegistry registry) {
        this(bodyName, parentJoint, inertiaPose, registry);
        this.spatialInertia.getMomentOfInertia().set(momentOfInertia);
        this.spatialInertia.setMass(mass);
    }

    private YoRigidBody(String bodyName, JointBasics parentJoint, RigidBodyTransformReadOnly inertiaPose, YoRegistry registry) {
        if (bodyName == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = bodyName;
        this.parentJoint = parentJoint;
        MovingReferenceFrame frameAfterJoint = parentJoint.getFrameAfterJoint();
        this.bodyFixedFrame = MovingReferenceFrame.constructFrameFixedInParent((String)(bodyName + "CoM"), (ReferenceFrame)frameAfterJoint, (RigidBodyTransformReadOnly)inertiaPose);
        this.spatialInertia = new YoSpatialInertia((ReferenceFrame)this.bodyFixedFrame, (ReferenceFrame)this.bodyFixedFrame, registry);
        this.spatialInertia.getBodyFrame().checkReferenceFrameMatch(this.spatialInertia.getReferenceFrame());
        parentJoint.setSuccessor((RigidBodyBasics)this);
        this.nameId = parentJoint.getPredecessor().getNameId() + ":" + bodyName;
    }

    public SpatialInertiaBasics getInertia() {
        return this.spatialInertia;
    }

    public MovingReferenceFrame getBodyFixedFrame() {
        return this.bodyFixedFrame;
    }

    public JointBasics getParentJoint() {
        return this.parentJoint;
    }

    public List<JointBasics> getParentLoopClosureJoints() {
        return this.parentLoopClosureJoints;
    }

    public void addChildJoint(JointBasics joint) {
        this.childrenJoints.add(joint);
    }

    public List<JointBasics> getChildrenJoints() {
        return this.childrenJoints;
    }

    public String getName() {
        return this.name;
    }

    public String getNameId() {
        return this.nameId;
    }

    public YoRigidBody[] subtreeArray() {
        return (YoRigidBody[])this.subtreeStream().toArray(YoRigidBody[]::new);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.nameId.hashCode();
    }
}

