/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import java.util.Collections;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteTwinsJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteTwinsJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteTwinsJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoRevoluteJoint;
import us.ihmc.mecano.yoVariables.multiBodySystem.interfaces.YoOneDoFJointBasics;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoRevoluteTwinsJoint
implements RevoluteTwinsJointBasics,
YoOneDoFJointBasics {
    private final YoDouble q;
    private final YoDouble qd;
    private final YoDouble qdd;
    private final YoDouble tau;
    private final String name;
    private final String nameId;
    private final RigidBodyBasics predecessor;
    private RigidBodyBasics successor;
    private final MovingReferenceFrame beforeJointFrame;
    private final MovingReferenceFrame afterJointFrame;
    private final YoRevoluteJoint jointA;
    private final YoRevoluteJoint jointB;
    private final YoRevoluteJoint actuatedJoint;
    private final YoRevoluteJoint constrainedJoint;
    private final TwistReadOnly jointTwist;
    private final Twist unitJointTwist = new Twist();
    private final Twist unitSuccessorTwist = new Twist();
    private final Twist unitPredecessorTwist = new Twist();
    private final List<TwistReadOnly> unitTwists;
    private final SpatialAccelerationReadOnly jointAcceleration;
    private final SpatialAcceleration jointBiasAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration successorBiasAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitJointAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitSuccessorAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitPredecessorAcceleration = new SpatialAcceleration();
    private final Wrench unitJointWrench = new Wrench();
    private WrenchReadOnly jointWrench;
    private final int actuatedJointIndex;
    private final DMatrixRMaj constraintJacobian;
    private final DMatrixRMaj constraintConvectiveTerm = new DMatrixRMaj(2, 1);
    private final double constraintRatio;
    private final double constraintOffset;
    private final Vector3D rotationVector = new Vector3D();
    private final YoDouble jointLimitLower;
    private final YoDouble jointLimitUpper;
    private final YoDouble velocityLimitLower;
    private final YoDouble velocityLimitUpper;
    private final YoDouble effortLimitLower;
    private final YoDouble effortLimitUpper;
    private final YoDouble jointInternalLimitLower;
    private final YoDouble jointInternalLimitUpper;
    private final YoDouble internalVelocityLimitLower;
    private final YoDouble internalVelocityLimitUpper;
    private final Twist deltaTwist = new Twist();
    private final Twist bodyTwist = new Twist();

    public YoRevoluteTwinsJoint(String name, RigidBodyBasics predecessor, String jointNameA, String jointNameB, String bodyNameAB, RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToA, Matrix3DReadOnly bodyInertiaAB, double bodyMassAB, RigidBodyTransformReadOnly bodyInertiaPoseAB, int actuatedJointIndex, double constraintRatio, double constraintOffset, Vector3DReadOnly jointAxis, YoRegistry registry) {
        this(name, predecessor, jointNameA, jointNameB, bodyNameAB, transformAToPredecessor, transformBToA, bodyInertiaAB, bodyMassAB, bodyInertiaPoseAB, MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER, actuatedJointIndex, constraintRatio, constraintOffset, jointAxis, registry);
    }

    public YoRevoluteTwinsJoint(String name, RigidBodyBasics predecessor, String jointNameA, String jointNameB, String bodyNameAB, RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToA, Matrix3DReadOnly bodyInertiaAB, double bodyMassAB, RigidBodyTransformReadOnly bodyInertiaPoseAB, MultiBodySystemFactories.RigidBodyBuilder rigidBodyBuilder, int actuatedJointIndex, double constraintRatio, double constraintOffset, Vector3DReadOnly jointAxis, YoRegistry registry) {
        if (actuatedJointIndex < 0 || actuatedJointIndex > 1) {
            throw new IllegalArgumentException("The actuated joint index has to be either 0 or 1, was: " + actuatedJointIndex);
        }
        this.actuatedJointIndex = actuatedJointIndex;
        JointReadOnly.checkJointNameSanity((String)name);
        jointNameA = CrossFourBarJoint.getInternalName((String)name, (String)jointNameA, (String)"A");
        jointNameB = CrossFourBarJoint.getInternalName((String)name, (String)jointNameB, (String)"B");
        bodyNameAB = CrossFourBarJoint.getInternalName((String)name, (String)bodyNameAB, (String)"AB");
        if (bodyInertiaAB == null) {
            bodyInertiaAB = new Matrix3D();
        }
        if (bodyInertiaPoseAB == null) {
            bodyInertiaPoseAB = new RigidBodyTransform();
        }
        MovingReferenceFrame parentFrame = predecessor.isRootBody() ? predecessor.getBodyFixedFrame() : predecessor.getParentJoint().getFrameAfterJoint();
        RigidBody base = new RigidBody(name + "InternalBase", (ReferenceFrame)parentFrame);
        this.jointA = new YoRevoluteJoint(jointNameA, (RigidBodyBasics)base, transformAToPredecessor, jointAxis, registry);
        RigidBodyBasics bodyAB = rigidBodyBuilder.build(bodyNameAB, (JointBasics)this.jointA, bodyInertiaAB, bodyMassAB, bodyInertiaPoseAB);
        this.jointB = new YoRevoluteJoint(jointNameB, bodyAB, transformBToA, jointAxis, registry);
        this.actuatedJoint = actuatedJointIndex == 0 ? this.jointA : this.jointB;
        this.constrainedJoint = actuatedJointIndex == 0 ? this.jointB : this.jointA;
        this.name = name;
        this.predecessor = predecessor;
        predecessor.addChildJoint((JointBasics)this);
        this.nameId = JointReadOnly.computeNameId((JointReadOnly)this);
        this.beforeJointFrame = this.jointA.getFrameBeforeJoint();
        this.afterJointFrame = this.jointB.getFrameAfterJoint();
        this.unitTwists = Collections.singletonList(this.unitJointTwist);
        this.jointTwist = MecanoFactories.newTwistReadOnly(this::getQd, (TwistReadOnly)this.unitJointTwist);
        this.jointAcceleration = MecanoFactories.newSpatialAccelerationVectorReadOnly(this::getQdd, (SpatialAccelerationReadOnly)this.unitJointAcceleration, (SpatialAccelerationReadOnly)this.jointBiasAcceleration);
        this.constraintRatio = constraintRatio;
        this.constraintOffset = constraintOffset;
        this.constraintJacobian = new DMatrixRMaj(2, 1);
        this.constraintJacobian.set(actuatedJointIndex, 0, 1.0);
        this.constraintJacobian.set(1 - actuatedJointIndex, 0, constraintRatio);
        this.q = new YoDouble("q_" + name, registry);
        this.qd = new YoDouble("qd_" + name, registry);
        this.qdd = new YoDouble("qdd_" + name, registry);
        this.tau = new YoDouble("tau_" + name, registry);
        this.jointLimitLower = new YoDouble("q_min_" + name, registry);
        this.jointLimitUpper = new YoDouble("q_max_" + name, registry);
        this.velocityLimitLower = new YoDouble("qd_min_" + name, registry);
        this.velocityLimitUpper = new YoDouble("qd_max_" + name, registry);
        this.effortLimitLower = new YoDouble("tau_min_" + name, registry);
        this.effortLimitUpper = new YoDouble("tau_max_" + name, registry);
        this.jointInternalLimitLower = new YoDouble("q_min_internal_" + name, registry);
        this.jointInternalLimitUpper = new YoDouble("q_max_internal_" + name, registry);
        this.internalVelocityLimitLower = new YoDouble("qd_min_internal_" + name, registry);
        this.internalVelocityLimitUpper = new YoDouble("qd_max_internal_" + name, registry);
        this.jointLimitLower.set(Double.NEGATIVE_INFINITY);
        this.jointLimitUpper.set(Double.POSITIVE_INFINITY);
        this.velocityLimitLower.set(Double.NEGATIVE_INFINITY);
        this.velocityLimitUpper.set(Double.POSITIVE_INFINITY);
        this.effortLimitLower.set(Double.NEGATIVE_INFINITY);
        this.effortLimitUpper.set(Double.POSITIVE_INFINITY);
        this.updateJointLimits();
        this.updateVelocityLimits();
        this.q.addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setQ(this.q.getValue())));
        this.qd.addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setQd(this.qd.getValue())));
        this.qdd.addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setQdd(this.qdd.getValue())));
        this.tau.addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setTau(this.tau.getValue())));
        this.actuatedJoint.getYoQ().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setQ(this.actuatedJoint.getQ() * (1.0 + constraintRatio) + constraintOffset)));
        this.actuatedJoint.getYoQd().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setQd(this.actuatedJoint.getQd() * (1.0 + constraintRatio))));
        this.actuatedJoint.getYoQdd().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setQdd(this.actuatedJoint.getQdd() * (1.0 + constraintRatio))));
        this.actuatedJoint.getYoTau().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setTau(this.actuatedJoint.getTau() / (1.0 + constraintRatio))));
        this.constrainedJoint.getYoQ().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setQ((this.constrainedJoint.getQ() - constraintOffset) / constraintRatio + this.constrainedJoint.getQ())));
        this.constrainedJoint.getYoQd().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setQd(this.constrainedJoint.getQd() * (1.0 + 1.0 / constraintRatio))));
        this.constrainedJoint.getYoQdd().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.setQdd(this.constrainedJoint.getQdd() * (1.0 + 1.0 / constraintRatio))));
        this.constrainedJoint.getYoTau().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.constrainedJoint.setTau(0.0)));
        this.actuatedJoint.getYoJointLimitLower().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.updateJointLimits()));
        this.actuatedJoint.getYoJointLimitUpper().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.updateJointLimits()));
        this.actuatedJoint.getYoVelocityLimitLower().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.updateVelocityLimits()));
        this.actuatedJoint.getYoVelocityLimitUpper().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.updateVelocityLimits()));
        this.constrainedJoint.getYoJointLimitLower().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.updateJointLimits()));
        this.constrainedJoint.getYoJointLimitUpper().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.updateJointLimits()));
        this.constrainedJoint.getYoVelocityLimitLower().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.updateVelocityLimits()));
        this.constrainedJoint.getYoVelocityLimitUpper().addListener(YoRevoluteTwinsJoint.yoListener(() -> this.updateVelocityLimits()));
    }

    private void updateJointLimits() {
        this.jointInternalLimitLower.set(RevoluteTwinsJointReadOnly.computeJointLimitLower((RevoluteTwinsJointReadOnly)this));
        this.jointInternalLimitUpper.set(RevoluteTwinsJointReadOnly.computeJointLimitUpper((RevoluteTwinsJointReadOnly)this));
    }

    private void updateVelocityLimits() {
        this.internalVelocityLimitLower.set(RevoluteTwinsJointReadOnly.computeVelocityLimitLower((RevoluteTwinsJointReadOnly)this));
        this.internalVelocityLimitUpper.set(RevoluteTwinsJointReadOnly.computeVelocityLimitUpper((RevoluteTwinsJointReadOnly)this));
    }

    private static YoVariableChangedListener yoListener(final Runnable action) {
        return new YoVariableChangedListener(){
            private boolean isInsideListener = false;

            public void changed(YoVariable source) {
                if (this.isInsideListener) {
                    return;
                }
                this.isInsideListener = true;
                action.run();
                this.isInsideListener = false;
            }
        };
    }

    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        this.jointWrench = MecanoFactories.newWrenchReadOnly(this::getTau, (WrenchReadOnly)this.unitJointWrench);
    }

    public void updateFrame() {
        double q_actuated = this.actuatedJoint.getQ();
        double qDot_actuated = this.actuatedJoint.getQd();
        double qDDot_actuated = this.actuatedJoint.getQdd();
        double q_constrained = this.constraintRatio * q_actuated + this.constraintOffset;
        double qDot_constrained = this.constraintRatio * qDot_actuated;
        double qDDot_constrained = this.constraintRatio * qDDot_actuated;
        this.constrainedJoint.setQ(q_constrained);
        this.constrainedJoint.setQd(qDot_constrained);
        this.constrainedJoint.setQdd(qDDot_constrained);
        this.jointA.updateFrame();
        this.jointB.updateFrame();
        this.updateMotionSubspace();
    }

    public void updateMotionSubspace() {
        RevoluteTwinsJoint.updateUnitJointTwist((RevoluteTwinsJointReadOnly)this, (TwistBasics)this.unitJointTwist);
        this.unitJointAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.unitJointTwist);
        RevoluteTwinsJoint.updateBiasAcceleration((RevoluteTwinsJointReadOnly)this, (TwistBasics)this.deltaTwist, (TwistBasics)this.bodyTwist, (SpatialAccelerationBasics)this.jointBiasAcceleration);
        if (this.getSuccessor() != null) {
            this.unitSuccessorTwist.setIncludingFrame((SpatialMotionReadOnly)this.unitJointTwist);
            this.unitSuccessorTwist.setBaseFrame((ReferenceFrame)this.predecessor.getBodyFixedFrame());
            this.unitSuccessorTwist.setBodyFrame((ReferenceFrame)this.successor.getBodyFixedFrame());
            this.unitSuccessorTwist.changeFrame((ReferenceFrame)this.successor.getBodyFixedFrame());
            this.unitPredecessorTwist.setIncludingFrame((SpatialMotionReadOnly)this.unitSuccessorTwist);
            this.unitPredecessorTwist.invert();
            this.unitPredecessorTwist.changeFrame((ReferenceFrame)this.predecessor.getBodyFixedFrame());
            this.unitSuccessorAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.unitSuccessorTwist);
            this.unitPredecessorAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.unitPredecessorTwist);
            this.successorBiasAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.jointBiasAcceleration);
            this.successorBiasAcceleration.setBaseFrame((ReferenceFrame)this.getPredecessor().getBodyFixedFrame());
            this.successorBiasAcceleration.setBodyFrame((ReferenceFrame)this.getSuccessor().getBodyFixedFrame());
            this.successorBiasAcceleration.changeFrame((ReferenceFrame)this.getSuccessor().getBodyFixedFrame());
            this.unitJointWrench.setIncludingFrame((SpatialVectorReadOnly)this.actuatedJoint.getUnitJointTwist());
            this.unitJointWrench.changeFrame((ReferenceFrame)this.afterJointFrame);
            this.unitJointWrench.setBodyFrame((ReferenceFrame)this.getSuccessor().getBodyFixedFrame());
        }
    }

    public RevoluteJointBasics getActuatedJoint() {
        return this.actuatedJoint;
    }

    public RevoluteJointBasics getConstrainedJoint() {
        return this.constrainedJoint;
    }

    public RevoluteJointBasics getJointA() {
        return this.jointA;
    }

    public RevoluteJointBasics getJointB() {
        return this.jointB;
    }

    public int getActuatedJointIndex() {
        return this.actuatedJointIndex;
    }

    public double getConstraintRatio() {
        return this.constraintRatio;
    }

    public double getConstraintOffset() {
        return this.constraintOffset;
    }

    public DMatrixRMaj getConstraintJacobian() {
        return this.constraintJacobian;
    }

    public DMatrixRMaj getConstraintConvectiveTerm() {
        return this.constraintConvectiveTerm;
    }

    public MovingReferenceFrame getFrameBeforeJoint() {
        return this.beforeJointFrame;
    }

    public MovingReferenceFrame getFrameAfterJoint() {
        return this.afterJointFrame;
    }

    public RigidBodyBasics getPredecessor() {
        return this.predecessor;
    }

    public RigidBodyBasics getSuccessor() {
        return this.successor;
    }

    public MovingReferenceFrame getLoopClosureFrame() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getNameId() {
        return this.nameId;
    }

    public void setupLoopClosure(RigidBodyBasics successor, RigidBodyTransformReadOnly transformFromSuccessorParentJoint) {
        throw new UnsupportedOperationException("Loop closure using a four bar joint has not been implemented.");
    }

    @Override
    public double getQ() {
        this.q.set(super.getQ(), false);
        return this.q.getValue();
    }

    @Override
    public double getQd() {
        this.qd.set(super.getQd(), false);
        return this.qd.getValue();
    }

    @Override
    public double getQdd() {
        this.qdd.set(super.getQdd(), false);
        return this.qdd.getValue();
    }

    @Override
    public double getTau() {
        this.tau.set(this.actuatedJoint.getTau() / (1.0 + this.constraintRatio), false);
        return this.tau.getValue();
    }

    public TwistReadOnly getUnitJointTwist() {
        return this.unitJointTwist;
    }

    public TwistReadOnly getUnitSuccessorTwist() {
        return this.unitSuccessorTwist;
    }

    public TwistReadOnly getUnitPredecessorTwist() {
        return this.unitPredecessorTwist;
    }

    public SpatialAccelerationReadOnly getUnitJointAcceleration() {
        return this.unitJointAcceleration;
    }

    public SpatialAccelerationReadOnly getUnitSuccessorAcceleration() {
        return this.unitSuccessorAcceleration;
    }

    public SpatialAccelerationReadOnly getUnitPredecessorAcceleration() {
        return this.unitPredecessorAcceleration;
    }

    public void getJointConfiguration(RigidBodyTransform jointConfigurationToPack) {
        this.afterJointFrame.getTransformToDesiredFrame(jointConfigurationToPack, (ReferenceFrame)this.beforeJointFrame);
    }

    public TwistReadOnly getJointTwist() {
        return this.jointTwist;
    }

    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }

    public SpatialAccelerationReadOnly getJointAcceleration() {
        return this.jointAcceleration;
    }

    public SpatialAccelerationReadOnly getJointBiasAcceleration() {
        return this.jointBiasAcceleration;
    }

    public SpatialAccelerationReadOnly getSuccessorBiasAcceleration() {
        return this.successorBiasAcceleration;
    }

    public void getPredecessorAcceleration(SpatialAccelerationBasics accelerationToPack) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public SpatialAccelerationReadOnly getPredecessorBiasAcceleration() {
        throw new UnsupportedOperationException("Implement me!");
    }

    public WrenchReadOnly getJointWrench() {
        return this.jointWrench;
    }

    public void setJointOrientation(Orientation3DReadOnly jointOrientation) {
        jointOrientation.getRotationVector((Vector3DBasics)this.rotationVector);
        this.setQ(this.rotationVector.dot((Tuple3DReadOnly)this.getJointAxis()));
    }

    @Override
    public void setJointLimitLower(double jointLimitLower) {
        this.jointLimitLower.set(jointLimitLower);
    }

    @Override
    public void setJointLimitUpper(double jointLimitUpper) {
        this.jointLimitUpper.set(jointLimitUpper);
    }

    @Override
    public void setVelocityLimitLower(double velocityLimitLower) {
        this.velocityLimitLower.set(velocityLimitLower);
    }

    @Override
    public void setVelocityLimitUpper(double velocityLimitUpper) {
        this.velocityLimitUpper.set(velocityLimitUpper);
    }

    @Override
    public void setQ(double q) {
        super.setQ(q);
        this.q.set(q, false);
    }

    @Override
    public void setQd(double qd) {
        super.setQd(qd);
        this.qd.set(qd, false);
    }

    @Override
    public void setQdd(double qdd) {
        super.setQdd(qdd);
        this.qdd.set(qdd, false);
    }

    @Override
    public void setTau(double tau) {
        super.setTau(tau);
        this.tau.set(tau, false);
    }

    @Override
    public void setEffortLimitLower(double effortLimitLower) {
        this.effortLimitLower.set(effortLimitLower);
    }

    @Override
    public void setEffortLimitUpper(double effortLimitUpper) {
        this.effortLimitUpper.set(effortLimitUpper);
    }

    @Override
    public double getJointLimitLower() {
        if (this.jointInternalLimitLower.getValue() > this.jointInternalLimitUpper.getValue()) {
            throw new IllegalStateException("The joint limits are inconsistent: [" + this.jointInternalLimitLower.getValue() + ", " + this.jointInternalLimitUpper.getValue() + "]. This probably means that limits for the joints A and B are incompatible given the constraint ratio.");
        }
        return Math.max(this.jointLimitLower.getValue(), this.jointInternalLimitLower.getValue());
    }

    @Override
    public double getJointLimitUpper() {
        if (this.jointInternalLimitLower.getValue() > this.jointInternalLimitUpper.getValue()) {
            throw new IllegalStateException("The joint limits are inconsistent: [" + this.jointInternalLimitLower.getValue() + ", " + this.jointInternalLimitUpper.getValue() + "]. This probably means that limits for the joints A and B are incompatible given the constraint ratio.");
        }
        return Math.min(this.jointLimitUpper.getValue(), this.jointInternalLimitUpper.getValue());
    }

    @Override
    public double getVelocityLimitLower() {
        if (this.internalVelocityLimitLower.getValue() > this.internalVelocityLimitUpper.getValue()) {
            throw new IllegalStateException("The velocity limits are inconsistent: [" + this.internalVelocityLimitLower.getValue() + ", " + this.internalVelocityLimitUpper.getValue() + "]. This probably means that limits for the joints A and B are incompatible given the constraint ratio.");
        }
        return Math.max(this.velocityLimitLower.getValue(), this.internalVelocityLimitLower.getValue());
    }

    @Override
    public double getVelocityLimitUpper() {
        if (this.internalVelocityLimitLower.getValue() > this.internalVelocityLimitUpper.getValue()) {
            throw new IllegalStateException("The velocity limits are inconsistent: [" + this.internalVelocityLimitLower.getValue() + ", " + this.internalVelocityLimitUpper.getValue() + "]. This probably means that limits for the joints A and B are incompatible given the constraint ratio.");
        }
        return Math.min(this.velocityLimitUpper.getValue(), this.internalVelocityLimitUpper.getValue());
    }

    @Override
    public double getEffortLimitLower() {
        return Math.max(super.getEffortLimitLower(), this.effortLimitLower.getValue());
    }

    @Override
    public double getEffortLimitUpper() {
        return Math.min(super.getEffortLimitUpper(), this.effortLimitUpper.getValue());
    }

    @Override
    public YoDouble getYoQ() {
        return this.q;
    }

    @Override
    public YoDouble getYoQd() {
        return this.qd;
    }

    @Override
    public YoDouble getYoQdd() {
        return this.qdd;
    }

    @Override
    public YoDouble getYoTau() {
        return this.tau;
    }

    @Override
    public YoDouble getYoJointLimitLower() {
        return this.jointLimitLower;
    }

    @Override
    public YoDouble getYoJointLimitUpper() {
        return this.jointLimitUpper;
    }

    @Override
    public YoDouble getYoVelocityLimitLower() {
        return this.velocityLimitLower;
    }

    @Override
    public YoDouble getYoVelocityLimitUpper() {
        return this.velocityLimitUpper;
    }

    @Override
    public YoDouble getYoEffortLimitLower() {
        return this.effortLimitLower;
    }

    @Override
    public YoDouble getYoEffortLimitUpper() {
        return this.effortLimitUpper;
    }

    public String toString() {
        String qAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQ());
        String qdAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQd());
        String qddAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQdd());
        String tauAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getTau());
        return this.getClass().getSimpleName() + " " + this.getName() + ", q: " + qAsString + ", qd: " + qdAsString + ", qdd: " + qddAsString + ", tau: " + tauAsString;
    }

    public int hashCode() {
        return this.nameId.hashCode();
    }
}

