/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoOneDoFJoint;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoRevoluteJoint
extends YoOneDoFJoint
implements RevoluteJointBasics {
    private final FrameVector3D jointAxis;
    private final Vector3D rotationVector = new Vector3D();
    private final MecanoFactories.RevoluteJointTransformUpdater jointTransformUpdater;

    public YoRevoluteJoint(String name, RigidBodyBasics predecessor, Vector3DReadOnly jointAxis, YoRegistry registry) {
        this(name, predecessor, (RigidBodyTransformReadOnly)((RigidBodyTransform)null), jointAxis, registry);
    }

    public YoRevoluteJoint(String name, RigidBodyBasics predecessor, Tuple3DReadOnly jointOffset, Vector3DReadOnly jointAxis, YoRegistry registry) {
        this(name, predecessor, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), jointOffset), jointAxis, registry);
    }

    public YoRevoluteJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, Vector3DReadOnly jointAxis, YoRegistry registry) {
        super(name, predecessor, jointAxis, (Vector3DReadOnly)new Vector3D(), transformToParent, registry);
        this.jointAxis = new FrameVector3D((ReferenceFrame)this.beforeJointFrame, (Tuple3DReadOnly)jointAxis);
        this.jointTransformUpdater = MecanoFactories.newRevoluteJointTransformUpdater((RevoluteJointReadOnly)this);
    }

    public void getJointConfiguration(RigidBodyTransform jointTransform) {
        this.jointTransformUpdater.updateJointTransform(jointTransform);
    }

    public void setJointOrientation(Orientation3DReadOnly jointOrientation) {
        jointOrientation.getRotationVector((Vector3DBasics)this.rotationVector);
        this.setQ(this.rotationVector.dot((Tuple3DReadOnly)this.jointAxis));
    }

    public FrameVector3DBasics getJointAxis() {
        return this.jointAxis;
    }
}

