/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.tools;

import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoMecanoFactories {
    public static Pose3DBasics newPlanarYoPose3DBasics(final YoDouble yoPitch, final YoDouble yoX, final YoDouble yoZ) {
        return new Pose3DBasics(){
            private final QuaternionBasics jointRotation;
            private final Point3DBasics jointTranslation;
            {
                this.jointRotation = YoMecanoFactories.newPitchOnlyYoQuaternionBasics(yoPitch);
                this.jointTranslation = YoMecanoFactories.newXZOnlyYoPoint3DBasics(yoX, yoZ);
            }

            public Point3DBasics getPosition() {
                return this.jointTranslation;
            }

            public QuaternionBasics getOrientation() {
                return this.jointRotation;
            }
        };
    }

    public static QuaternionBasics newPitchOnlyYoQuaternionBasics(final YoDouble yoPitch) {
        return new QuaternionBasics(){
            private double y;
            private double s;

            public double getX() {
                return 0.0;
            }

            public double getY() {
                return this.y;
            }

            public double getZ() {
                return 0.0;
            }

            public double getS() {
                return this.s;
            }

            public void setUnsafe(double qx, double qy, double qz, double qs) {
                double pitchArgument = 2.0 * (qs * qy - qx * qz);
                if (pitchArgument > 1.0) {
                    pitchArgument = 1.0;
                } else if (pitchArgument < -1.0) {
                    pitchArgument = -1.0;
                }
                yoPitch.set(Math.asin(pitchArgument));
                double halfPitch = 0.5 * yoPitch.getValue();
                this.y = Math.sin(halfPitch);
                this.s = Math.cos(halfPitch);
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple4DString((Tuple4DReadOnly)this);
            }
        };
    }

    public static Point3DBasics newXZOnlyYoPoint3DBasics(final YoDouble yoX, final YoDouble yoZ) {
        return new Point3DBasics(){

            public double getX() {
                return yoX.getValue();
            }

            public double getY() {
                return 0.0;
            }

            public double getZ() {
                return yoZ.getValue();
            }

            public void setX(double x) {
                yoX.set(x);
            }

            public void setY(double y) {
            }

            public void setZ(double z) {
                yoZ.set(z);
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this);
            }
        };
    }

    public static FixedFrameVector3DBasics newXZOnlyYoFixedFrameVector3DBasics(final YoDouble yoX, final YoDouble yoZ, final ReferenceFrame referenceFrame) {
        return new FixedFrameVector3DBasics(){

            public ReferenceFrame getReferenceFrame() {
                return referenceFrame;
            }

            public double getX() {
                return yoX.getValue();
            }

            public double getY() {
                return 0.0;
            }

            public double getZ() {
                return yoZ.getValue();
            }

            public void setX(double x) {
                yoX.set(x);
            }

            public void setY(double y) {
            }

            public void setZ(double z) {
                yoZ.set(z);
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this);
            }
        };
    }

    public static FixedFrameVector3DBasics newYOnlyYoFixedFrameVector3DBasics(final YoDouble yoY, final ReferenceFrame referenceFrame) {
        return new FixedFrameVector3DBasics(){

            public ReferenceFrame getReferenceFrame() {
                return referenceFrame;
            }

            public double getX() {
                return 0.0;
            }

            public double getY() {
                return yoY.getValue();
            }

            public double getZ() {
                return 0.0;
            }

            public void setX(double x) {
            }

            public void setY(double y) {
                yoY.set(y);
            }

            public void setZ(double z) {
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this);
            }
        };
    }

    public static FixedFrameTwistBasics newPlanarYoFixedFrameTwistBasics(final YoDouble angularY, final YoDouble linearX, final YoDouble linearZ, final ReferenceFrame bodyFrame, final ReferenceFrame baseFrame, final ReferenceFrame expressedInFrame) {
        return new FixedFrameTwistBasics(){
            private final FixedFrameVector3DBasics angularPart;
            private final FixedFrameVector3DBasics linearPart;
            {
                this.angularPart = YoMecanoFactories.newYOnlyYoFixedFrameVector3DBasics(angularY, expressedInFrame);
                this.linearPart = YoMecanoFactories.newXZOnlyYoFixedFrameVector3DBasics(linearX, linearZ, expressedInFrame);
            }

            public ReferenceFrame getBodyFrame() {
                return bodyFrame;
            }

            public ReferenceFrame getBaseFrame() {
                return baseFrame;
            }

            public ReferenceFrame getReferenceFrame() {
                return expressedInFrame;
            }

            public FixedFrameVector3DBasics getAngularPart() {
                return this.angularPart;
            }

            public FixedFrameVector3DBasics getLinearPart() {
                return this.linearPart;
            }

            public String toString() {
                return MecanoIOTools.getTwistString((TwistReadOnly)this);
            }
        };
    }

    public static FixedFrameSpatialAccelerationBasics newPlanarYoFixedFrameSpatialAccelerationVectorBasics(final YoDouble angularY, final YoDouble linearX, final YoDouble linearZ, final ReferenceFrame bodyFrame, final ReferenceFrame baseFrame, final ReferenceFrame expressedInFrame) {
        return new FixedFrameSpatialAccelerationBasics(){
            private final FixedFrameVector3DBasics angularPart;
            private final FixedFrameVector3DBasics linearPart;
            {
                this.angularPart = YoMecanoFactories.newYOnlyYoFixedFrameVector3DBasics(angularY, expressedInFrame);
                this.linearPart = YoMecanoFactories.newXZOnlyYoFixedFrameVector3DBasics(linearX, linearZ, expressedInFrame);
            }

            public ReferenceFrame getBodyFrame() {
                return bodyFrame;
            }

            public ReferenceFrame getBaseFrame() {
                return baseFrame;
            }

            public ReferenceFrame getReferenceFrame() {
                return expressedInFrame;
            }

            public FixedFrameVector3DBasics getAngularPart() {
                return this.angularPart;
            }

            public FixedFrameVector3DBasics getLinearPart() {
                return this.linearPart;
            }

            public String toString() {
                return MecanoIOTools.getSpatialAccelerationString((SpatialAccelerationReadOnly)this);
            }
        };
    }

    public static FixedFrameWrenchBasics newPlanarYoFixedFrameWrenchBasics(final YoDouble angularY, final YoDouble linearX, final YoDouble linearZ, final ReferenceFrame bodyFrame, final ReferenceFrame expressedInFrame) {
        return new FixedFrameWrenchBasics(){
            private final FixedFrameVector3DBasics angularPart;
            private final FixedFrameVector3DBasics linearPart;
            {
                this.angularPart = YoMecanoFactories.newYOnlyYoFixedFrameVector3DBasics(angularY, expressedInFrame);
                this.linearPart = YoMecanoFactories.newXZOnlyYoFixedFrameVector3DBasics(linearX, linearZ, expressedInFrame);
            }

            public ReferenceFrame getBodyFrame() {
                return bodyFrame;
            }

            public ReferenceFrame getReferenceFrame() {
                return expressedInFrame;
            }

            public FixedFrameVector3DBasics getAngularPart() {
                return this.angularPart;
            }

            public FixedFrameVector3DBasics getLinearPart() {
                return this.linearPart;
            }

            public String toString() {
                return MecanoIOTools.getWrenchString((WrenchReadOnly)this);
            }
        };
    }
}

