/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.yoVariables.multiBodySystem.interfaces.YoOneDoFJointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoCrossFourBarJoint
extends CrossFourBarJoint
implements YoOneDoFJointBasics {
    private final YoDouble q;
    private final YoDouble qd;
    private final YoDouble qdd;
    private final YoDouble tau;
    private final YoDouble jointLimitLower;
    private final YoDouble jointLimitUpper;
    private final YoDouble velocityLimitLower;
    private final YoDouble velocityLimitUpper;
    private final YoDouble effortLimitLower;
    private final YoDouble effortLimitUpper;

    public YoCrossFourBarJoint(String name, RigidBodyBasics predecessor, String jointNameA, String jointNameB, String jointNameC, String jointNameD, String bodyNameDA, String bodyNameBC, RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToPredecessor, RigidBodyTransformReadOnly transformDToA, RigidBodyTransformReadOnly transformCToB, Matrix3DReadOnly bodyInertiaDA, Matrix3DReadOnly bodyInertiaBC, double bodyMassDA, double bodyMassBC, RigidBodyTransformReadOnly bodyInertiaPoseDA, RigidBodyTransformReadOnly bodyInertiaPoseBC, int actuatedJointIndex, int loopClosureJointIndex, Vector3DReadOnly jointAxis, YoRegistry registry) {
        this(name, predecessor, jointNameA, jointNameB, jointNameC, jointNameD, bodyNameDA, bodyNameBC, transformAToPredecessor, transformBToPredecessor, transformDToA, transformCToB, bodyInertiaDA, bodyInertiaBC, bodyMassDA, bodyMassBC, bodyInertiaPoseDA, bodyInertiaPoseBC, MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER, actuatedJointIndex, loopClosureJointIndex, jointAxis, registry);
    }

    public YoCrossFourBarJoint(String name, RigidBodyBasics predecessor, String jointNameA, String jointNameB, String jointNameC, String jointNameD, String bodyNameDA, String bodyNameBC, RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToPredecessor, RigidBodyTransformReadOnly transformDToA, RigidBodyTransformReadOnly transformCToB, Matrix3DReadOnly bodyInertiaDA, Matrix3DReadOnly bodyInertiaBC, double bodyMassDA, double bodyMassBC, RigidBodyTransformReadOnly bodyInertiaPoseDA, RigidBodyTransformReadOnly bodyInertiaPoseBC, MultiBodySystemFactories.RigidBodyBuilder rigidBodyBuilder, int actuatedJointIndex, int loopClosureJointIndex, Vector3DReadOnly jointAxis, YoRegistry registry) {
        super(name, predecessor, jointNameA, jointNameB, jointNameC, jointNameD, bodyNameDA, bodyNameBC, transformAToPredecessor, transformBToPredecessor, transformDToA, transformCToB, bodyInertiaDA, bodyInertiaBC, bodyMassDA, bodyMassBC, bodyInertiaPoseDA, bodyInertiaPoseBC, rigidBodyBuilder, actuatedJointIndex, loopClosureJointIndex, jointAxis);
        this.q = new YoDouble("q_" + this.getName(), registry);
        this.qd = new YoDouble("qd_" + this.getName(), registry);
        this.qdd = new YoDouble("qdd_" + this.getName(), registry);
        this.tau = new YoDouble("tau_" + this.getName(), registry);
        this.jointLimitLower = new YoDouble("q_min_" + this.getName(), registry);
        this.jointLimitUpper = new YoDouble("q_max_" + this.getName(), registry);
        this.velocityLimitLower = new YoDouble("qd_min_" + this.getName(), registry);
        this.velocityLimitUpper = new YoDouble("qd_max_" + this.getName(), registry);
        this.effortLimitLower = new YoDouble("tau_min_" + this.getName(), registry);
        this.effortLimitUpper = new YoDouble("tau_max_" + this.getName(), registry);
        this.q.addListener(v -> super.setQ(this.q.getValue()));
        this.qd.addListener(v -> super.setQd(this.qd.getValue()));
        this.qdd.addListener(v -> super.setQdd(this.qdd.getValue()));
        this.tau.addListener(v -> super.setTau(this.tau.getValue()));
        this.jointLimitLower.addListener(v -> super.setJointLimitLower(this.jointLimitLower.getValue()));
        this.jointLimitUpper.addListener(v -> super.setJointLimitUpper(this.jointLimitUpper.getValue()));
        this.velocityLimitLower.addListener(v -> super.setVelocityLimitLower(this.velocityLimitLower.getValue()));
        this.velocityLimitUpper.addListener(v -> super.setVelocityLimitUpper(this.velocityLimitUpper.getValue()));
        this.effortLimitLower.addListener(v -> super.setEffortLimitLower(this.effortLimitLower.getValue()));
        this.effortLimitUpper.addListener(v -> super.setEffortLimitUpper(this.effortLimitUpper.getValue()));
    }

    @Override
    public void setQ(double q) {
        this.q.set(q);
    }

    @Override
    public void setQd(double qd) {
        this.qd.set(qd);
    }

    @Override
    public void setQdd(double qdd) {
        this.qdd.set(qdd);
    }

    @Override
    public void setTau(double tau) {
        this.tau.set(tau);
    }

    public void setJointOrientation(Orientation3DReadOnly jointOrientation) {
        super.setJointOrientation(jointOrientation);
        this.getQ();
    }

    public void setJointAngularVelocity(Vector3DReadOnly jointAngularVelocity) {
        super.setJointAngularVelocity(jointAngularVelocity);
        this.getQd();
    }

    public void setJointAngularAcceleration(Vector3DReadOnly jointAngularAcceleration) {
        super.setJointAngularAcceleration(jointAngularAcceleration);
        this.getQdd();
    }

    public void setJointTorque(Vector3DReadOnly jointTorque) {
        super.setJointTorque(jointTorque);
        this.getTau();
    }

    @Override
    public void setJointLimitLower(double jointLimitLower) {
        this.jointLimitLower.set(jointLimitLower);
    }

    @Override
    public void setJointLimitUpper(double jointLimitUpper) {
        this.jointLimitUpper.set(jointLimitUpper);
    }

    @Override
    public void setVelocityLimitLower(double velocityLimitLower) {
        this.velocityLimitLower.set(velocityLimitLower);
    }

    @Override
    public void setVelocityLimitUpper(double velocityLimitUpper) {
        this.velocityLimitUpper.set(velocityLimitUpper);
    }

    @Override
    public void setEffortLimitLower(double effortLimitLower) {
        this.effortLimitLower.set(effortLimitLower);
    }

    @Override
    public void setEffortLimitUpper(double effortLimitUpper) {
        this.effortLimitUpper.set(effortLimitUpper);
    }

    @Override
    public double getQ() {
        this.q.set(super.getQ(), false);
        return this.q.getValue();
    }

    @Override
    public double getQd() {
        this.qd.set(super.getQd(), false);
        return this.qd.getValue();
    }

    @Override
    public double getQdd() {
        this.qdd.set(super.getQdd(), false);
        return this.qdd.getValue();
    }

    @Override
    public double getTau() {
        this.tau.set(super.getTau(), false);
        return this.tau.getValue();
    }

    @Override
    public double getJointLimitLower() {
        this.jointLimitLower.set(super.getJointLimitLower(), false);
        return this.jointLimitLower.getValue();
    }

    @Override
    public double getJointLimitUpper() {
        this.jointLimitUpper.set(super.getJointLimitUpper(), false);
        return this.jointLimitUpper.getValue();
    }

    @Override
    public double getVelocityLimitLower() {
        this.velocityLimitLower.set(super.getVelocityLimitLower(), false);
        return this.velocityLimitLower.getValue();
    }

    @Override
    public double getVelocityLimitUpper() {
        this.velocityLimitUpper.set(super.getVelocityLimitUpper(), false);
        return this.velocityLimitUpper.getValue();
    }

    @Override
    public double getEffortLimitLower() {
        this.effortLimitLower.set(super.getEffortLimitLower(), false);
        return this.effortLimitLower.getValue();
    }

    @Override
    public double getEffortLimitUpper() {
        this.effortLimitUpper.set(super.getEffortLimitUpper(), false);
        return this.effortLimitUpper.getValue();
    }

    @Override
    public YoDouble getYoQ() {
        return this.q;
    }

    @Override
    public YoDouble getYoQd() {
        return this.qd;
    }

    @Override
    public YoDouble getYoQdd() {
        return this.qdd;
    }

    @Override
    public YoDouble getYoTau() {
        return this.tau;
    }

    @Override
    public YoDouble getYoJointLimitLower() {
        return this.jointLimitLower;
    }

    @Override
    public YoDouble getYoJointLimitUpper() {
        return this.jointLimitUpper;
    }

    @Override
    public YoDouble getYoVelocityLimitLower() {
        return this.velocityLimitLower;
    }

    @Override
    public YoDouble getYoVelocityLimitUpper() {
        return this.velocityLimitUpper;
    }

    @Override
    public YoDouble getYoEffortLimitLower() {
        return this.effortLimitLower;
    }

    @Override
    public YoDouble getYoEffortLimitUpper() {
        return this.effortLimitUpper;
    }
}

