/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import java.util.List;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoSphericalJoint
extends Joint
implements SphericalJointBasics {
    private final YoFrameQuaternion jointOrientation;
    private final YoFrameVector3D jointAngularVelocity;
    private final YoFrameVector3D jointAngularAcceleration;
    private final YoFrameVector3D jointTorque;
    private final TwistReadOnly jointTwist;
    private final SpatialAccelerationReadOnly jointAcceleration;
    private WrenchReadOnly successorWrench;
    private final List<TwistReadOnly> unitTwists;

    public YoSphericalJoint(String name, RigidBodyBasics predecessor, Tuple3DReadOnly jointOffset, YoRegistry registry) {
        this(name, predecessor, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), jointOffset), registry);
    }

    public YoSphericalJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, YoRegistry registry) {
        super(name, predecessor, transformToParent);
        Object varName = !name.isEmpty() ? "_" + name + "_" : "_";
        this.jointOrientation = new YoFrameQuaternion("q" + (String)varName, (ReferenceFrame)this.beforeJointFrame, registry);
        this.jointAngularVelocity = new YoFrameVector3D("qd" + (String)varName + "w", (ReferenceFrame)this.afterJointFrame, registry);
        this.jointAngularAcceleration = new YoFrameVector3D("qdd" + (String)varName + "w", (ReferenceFrame)this.afterJointFrame, registry);
        this.jointTwist = MecanoFactories.newTwistReadOnly((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, (FrameVector3DReadOnly)this.jointAngularVelocity, (FrameVector3DReadOnly)new FrameVector3D((ReferenceFrame)this.afterJointFrame));
        this.jointAcceleration = MecanoFactories.newSpatialAccelerationVectorReadOnly((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, (FrameVector3DReadOnly)this.jointAngularAcceleration, (FrameVector3DReadOnly)new FrameVector3D((ReferenceFrame)this.afterJointFrame));
        this.unitTwists = MecanoTools.computeSphericalJointMotionSubspace((ReferenceFrame)this.beforeJointFrame, (ReferenceFrame)this.afterJointFrame);
        this.jointTorque = new YoFrameVector3D("tau" + (String)varName + "w", (ReferenceFrame)this.afterJointFrame, registry);
    }

    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        MovingReferenceFrame successorFrame = successor.getBodyFixedFrame();
        this.successorWrench = MecanoFactories.newWrenchReadOnly((ReferenceFrame)successorFrame, (FrameVector3DReadOnly)this.jointTorque, (FrameVector3DReadOnly)new FrameVector3D((ReferenceFrame)this.afterJointFrame));
    }

    public QuaternionBasics getJointOrientation() {
        return this.jointOrientation;
    }

    public FixedFrameVector3DBasics getJointAngularVelocity() {
        return this.jointAngularVelocity;
    }

    public FixedFrameVector3DBasics getJointAngularAcceleration() {
        return this.jointAngularAcceleration;
    }

    public FixedFrameVector3DBasics getJointTorque() {
        return this.jointTorque;
    }

    public TwistReadOnly getJointTwist() {
        return this.jointTwist;
    }

    public SpatialAccelerationReadOnly getJointAcceleration() {
        return this.jointAcceleration;
    }

    public WrenchReadOnly getJointWrench() {
        return this.successorWrench;
    }

    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }

    public String toString() {
        return super.toString() + ", orientation: " + this.jointOrientation + ", velocity" + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this.jointAngularVelocity) + ", acceleration: " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this.jointAngularAcceleration) + ", torque: " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this.jointTorque);
    }
}

