/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.yoVariables.tools.YoMultiBodySystemFactories;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoMultiBodySystem
implements MultiBodySystemBasics {
    private final RigidBodyBasics yoRootBody;
    private final List<? extends JointBasics> allJoints;
    private final List<? extends JointBasics> jointsToConsider;
    private final List<? extends JointBasics> jointsToIgnore;
    private final JointMatrixIndexProvider jointMatrixIndexProvider;

    public YoMultiBodySystem(MultiBodySystemReadOnly input, ReferenceFrame stationaryFrame, YoRegistry registry) {
        this(input, stationaryFrame, registry, MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER, YoMultiBodySystemFactories.newYoJointBuilder(registry));
    }

    public YoMultiBodySystem(MultiBodySystemReadOnly input, ReferenceFrame stationaryFrame, YoRegistry registry, MultiBodySystemFactories.RigidBodyBuilder rigidBodyBuilder, MultiBodySystemFactories.JointBuilder yoJointBuilder) {
        this.yoRootBody = MultiBodySystemFactories.cloneMultiBodySystem((RigidBodyReadOnly)input.getRootBody(), (ReferenceFrame)stationaryFrame, (String)"", (MultiBodySystemFactories.RigidBodyBuilder)rigidBodyBuilder, (MultiBodySystemFactories.JointBuilder)yoJointBuilder);
        this.allJoints = SubtreeStreams.fromChildren((RigidBodyBasics)this.yoRootBody).collect(Collectors.toList());
        Set nameOfJointsToConsider = input.getJointsToConsider().stream().map(JointReadOnly::getName).collect(Collectors.toSet());
        this.jointsToConsider = SubtreeStreams.fromChildren((RigidBodyBasics)this.yoRootBody).filter(joint -> nameOfJointsToConsider.contains(joint.getName())).collect(Collectors.toList());
        Set nameOfJointsToIgnore = input.getJointsToIgnore().stream().map(JointReadOnly::getName).collect(Collectors.toSet());
        this.jointsToIgnore = SubtreeStreams.fromChildren((RigidBodyBasics)this.yoRootBody).filter(joint -> nameOfJointsToIgnore.contains(joint.getName())).collect(Collectors.toList());
        this.jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(this.jointsToConsider);
    }

    public RigidBodyBasics getRootBody() {
        return this.yoRootBody;
    }

    public List<? extends JointBasics> getAllJoints() {
        return this.allJoints;
    }

    public List<? extends JointBasics> getJointsToConsider() {
        return this.jointsToConsider;
    }

    public List<? extends JointBasics> getJointsToIgnore() {
        return this.jointsToIgnore;
    }

    public JointMatrixIndexProvider getJointMatrixIndexProvider() {
        return this.jointMatrixIndexProvider;
    }
}

