/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.spatial;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialForceBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFixedFrameSpatialForce
implements FixedFrameSpatialForceBasics,
GeometryObject<YoFixedFrameSpatialForce> {
    private final YoFixedFrameSpatialVector spatialVector;
    private final Point3D pointOfApplication = new Point3D();

    public YoFixedFrameSpatialForce(String namePrefix, ReferenceFrame expressedInFrame, YoRegistry registry) {
        this(new YoFixedFrameSpatialVector(namePrefix, expressedInFrame, registry));
    }

    public YoFixedFrameSpatialForce(String namePrefix, String nameSuffix, ReferenceFrame expressedInFrame, YoRegistry registry) {
        this(new YoFixedFrameSpatialVector(namePrefix, nameSuffix, expressedInFrame, registry));
    }

    public YoFixedFrameSpatialForce(YoFrameVector3D angularPart, YoFrameVector3D linearPart) {
        this(new YoFixedFrameSpatialVector(angularPart, linearPart));
    }

    public YoFixedFrameSpatialForce(YoFixedFrameSpatialVector spatialVector) {
        this.spatialVector = spatialVector;
    }

    public void set(YoFixedFrameSpatialForce other) {
        super.set((SpatialVectorReadOnly)other);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.spatialVector.getReferenceFrame();
    }

    public YoFrameVector3D getAngularPart() {
        return this.spatialVector.getAngularPart();
    }

    public YoFrameVector3D getLinearPart() {
        return this.spatialVector.getLinearPart();
    }

    public void applyTransform(Transform transform) {
        if (transform instanceof RigidBodyTransform) {
            this.applyTransform((RigidBodyTransformReadOnly)((RigidBodyTransform)transform));
        } else {
            this.pointOfApplication.setToZero();
            this.pointOfApplication.applyTransform(transform);
            this.spatialVector.applyTransform(transform);
            this.addCrossToAngularPart((Tuple3DReadOnly)this.pointOfApplication, (Tuple3DReadOnly)this.getLinearPart());
        }
    }

    public void applyInverseTransform(Transform transform) {
        if (transform instanceof RigidBodyTransform) {
            this.applyInverseTransform((RigidBodyTransformReadOnly)((RigidBodyTransform)transform));
        } else {
            this.pointOfApplication.setToZero();
            this.pointOfApplication.applyInverseTransform(transform);
            this.spatialVector.applyInverseTransform(transform);
            this.addCrossToAngularPart((Tuple3DReadOnly)this.pointOfApplication, (Tuple3DReadOnly)this.getLinearPart());
        }
    }

    public boolean epsilonEquals(YoFixedFrameSpatialForce other, double epsilon) {
        return super.epsilonEquals((SpatialVectorReadOnly)other, epsilon);
    }

    public boolean geometricallyEquals(YoFixedFrameSpatialForce other, double epsilon) {
        return super.geometricallyEquals((SpatialVectorReadOnly)other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof SpatialForceReadOnly) {
            return super.equals((SpatialVectorReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return MecanoIOTools.getSpatialForceVectorString((SpatialForceReadOnly)this);
    }
}

